/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.universal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1263;
import net.minecraft.class_1273;
import net.minecraft.class_1730;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2609;
import net.minecraft.class_2611;
import net.minecraft.class_2621;
import net.minecraft.class_2624;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7265;
import org.apache.commons.lang3.mutable.MutableBoolean;
import snownee.jade.JadeCommonConfig;
import snownee.jade.addon.universal.ItemCollector;
import snownee.jade.addon.universal.ItemIterator;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ItemView;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.ui.HorizontalLineElement;
import snownee.jade.impl.ui.ScaledTextElement;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.WailaExceptionHandler;

public enum ItemStorageProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>,
IServerExtensionProvider<Object, class_1799>,
IClientExtensionProvider<class_1799, ItemView>
{
    INSTANCE;

    public final Cache<Object, ItemCollector<?>> targetCache = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(60L, TimeUnit.SECONDS).build();
    public final Cache<Object, ItemCollector<?>> containerCache = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(120L, TimeUnit.SECONDS).build();

    public static void append(ITooltip tooltip, Accessor<?> accessor, IPluginConfig config) {
        if (!accessor.getServerData().method_10545("JadeItemStorage")) {
            if (accessor.getServerData().method_10577("Loot")) {
                tooltip.add((class_2561)class_2561.method_43471((String)"jade.not_generated"));
            } else if (accessor.getServerData().method_10577("Locked")) {
                tooltip.add((class_2561)class_2561.method_43471((String)"jade.locked"));
            }
            return;
        }
        Optional<IClientExtensionProvider> provider = Optional.ofNullable(class_2960.method_12829((String)accessor.getServerData().method_10558("JadeItemStorageUid"))).map(WailaClientRegistration.INSTANCE.itemStorageProviders::get);
        if (provider.isEmpty()) {
            return;
        }
        List groups = provider.get().getClientGroups(accessor, ViewGroup.readList(accessor.getServerData(), "JadeItemStorage", itemTag -> {
            class_1799 item = class_1799.method_7915((class_2487)itemTag);
            if (!item.method_7960() && itemTag.method_10545("NewCount")) {
                item.method_7939(itemTag.method_10550("NewCount"));
            }
            return item;
        }));
        if (groups.isEmpty()) {
            return;
        }
        MutableBoolean showName = new MutableBoolean(true);
        int totalSize = 0;
        for (ClientViewGroup clientViewGroup : groups) {
            for (ItemView view : clientViewGroup.views) {
                if (view.text != null) {
                    showName.setFalse();
                }
                if (view.item.method_7960()) continue;
                ++totalSize;
            }
        }
        if (showName.isTrue()) {
            showName.setValue(totalSize < PluginConfig.INSTANCE.getInt(Identifiers.MC_ITEM_STORAGE_SHOW_NAME_AMOUNT));
        }
        IElementHelper helper = IElementHelper.get();
        boolean renderGroup = groups.size() > 1 || groups.get(0).shouldRenderGroup();
        ClientViewGroup.tooltip(tooltip, groups, renderGroup, (theTooltip, group) -> {
            float progress;
            class_2487 data;
            if (renderGroup) {
                theTooltip.add(new HorizontalLineElement());
                if (group.title != null) {
                    theTooltip.append(new ScaledTextElement(group.title, 0.5f));
                    theTooltip.append(new HorizontalLineElement());
                }
            }
            if (group.views.isEmpty() && (data = group.extraData) != null && data.method_10573("Collecting", 99) && (progress = data.method_10583("Collecting")) < 1.0f) {
                class_5250 component = class_2561.method_43471((String)"jade.collectingItems");
                if (progress > 0.0f) {
                    component.method_27693(" %s%%".formatted((int)(progress * 100.0f)));
                }
                theTooltip.add((class_2561)component);
            }
            int drawnCount = 0;
            int realSize = PluginConfig.INSTANCE.getInt(accessor.showDetails() ? Identifiers.MC_ITEM_STORAGE_DETAILED_AMOUNT : Identifiers.MC_ITEM_STORAGE_NORMAL_AMOUNT);
            realSize = Math.min(group.views.size(), realSize);
            ArrayList elements = Lists.newArrayList();
            for (int i = 0; i < realSize; ++i) {
                ItemView itemView = (ItemView)group.views.get(i);
                class_1799 stack = itemView.item;
                if (stack.method_7960()) continue;
                if (i > 0 && (showName.isTrue() || drawnCount >= PluginConfig.INSTANCE.getInt(Identifiers.MC_ITEM_STORAGE_ITEMS_PER_LINE))) {
                    theTooltip.add(elements);
                    elements.clear();
                    drawnCount = 0;
                }
                if (showName.isTrue()) {
                    class_1799 copy = stack.method_7972();
                    copy.method_7939(1);
                    elements.add(helper.smallItem(copy).clearCachedMessage());
                    elements.add(helper.text((class_2561)class_2561.method_43470((String)(itemView.text != null ? itemView.text : IDisplayHelper.get().humanReadableNumber(stack.method_7947(), "", false, null))).method_27693("\u00d7 ").method_10852((class_2561)IDisplayHelper.get().stripColor(stack.method_7964()))).message(null));
                } else if (itemView.text != null) {
                    elements.add(helper.item(stack, 1.0f, itemView.text));
                } else {
                    elements.add(helper.item(stack));
                }
                ++drawnCount;
            }
            if (!elements.isEmpty()) {
                theTooltip.add(elements);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void putData(Accessor<?> accessor) {
        class_7265 containerEntity;
        class_2487 tag = accessor.getServerData();
        Object target = accessor.getTarget();
        class_3222 player = (class_3222)accessor.getPlayer();
        boolean showDetails = accessor.showDetails();
        for (IServerExtensionProvider<Object, class_1799> provider : WailaCommonRegistration.INSTANCE.itemStorageProviders.get(target)) {
            List groups = provider.getGroups(player, player.method_51469(), target, showDetails);
            if (groups == null) continue;
            if (!ViewGroup.saveList(tag, "JadeItemStorage", groups, item -> {
                class_2487 itemTag = new class_2487();
                int count = item.method_7947();
                if (count > 64) {
                    item.method_7939(1);
                }
                item.method_7953(itemTag);
                if (count > 64) {
                    itemTag.method_10569("NewCount", count);
                    item.method_7939(count);
                }
                return itemTag;
            })) break;
            tag.method_10582("JadeItemStorageUid", provider.getUid().toString());
            return;
        }
        if (target instanceof class_2621) {
            class_2621 te = (class_2621)target;
            if (te.field_12037 != null) {
                tag.method_10556("Loot", true);
                return;
            }
        }
        if (target instanceof class_7265 && (containerEntity = (class_7265)target).method_42276() != null) {
            tag.method_10556("Loot", true);
            return;
        }
        if (player.method_7337()) return;
        if (player.method_7325()) return;
        if (!(target instanceof class_2624)) return;
        class_2624 te = (class_2624)target;
        if (te.field_12045 == class_1273.field_5817) return;
        tag.method_10556("Locked", true);
    }

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (accessor.getBlockEntity() instanceof class_2609) {
            return;
        }
        ItemStorageProvider.append(tooltip, accessor, config);
    }

    @Override
    public void appendServerData(class_2487 tag, BlockAccessor accessor) {
        if (JadeCommonConfig.shouldIgnoreTE(tag.method_10558("id")) || accessor.getBlockEntity() instanceof class_2609) {
            return;
        }
        ItemStorageProvider.putData(accessor);
    }

    @Override
    public class_2960 getUid() {
        return Identifiers.UNIVERSAL_ITEM_STORAGE;
    }

    @Override
    public int getDefaultPriority() {
        return 1000;
    }

    @Override
    public List<ViewGroup<class_1799>> getGroups(class_3222 player, class_3218 world, Object target, boolean showDetails) {
        ItemCollector itemCollector;
        class_7265 containerEntity;
        class_2621 te;
        if (target instanceof class_2621) {
            te = (class_2621)target;
            if (te.field_12037 != null) {
                return null;
            }
        }
        if (target instanceof class_7265 && (containerEntity = (class_7265)target).method_42276() != null) {
            return null;
        }
        if (!JadeCommonConfig.bypassLockedContainer && !player.method_7337() && !player.method_7325() && target instanceof class_2624) {
            te = (class_2624)target;
            if (te.field_12045 != class_1273.field_5817) {
                return null;
            }
        }
        if (player != null && target instanceof class_2611) {
            class_1730 inventory = player.method_7274();
            return new ItemCollector<class_1263>(new ItemIterator.ContainerItemIterator(0)).update(inventory, world.method_8510());
        }
        try {
            itemCollector = (ItemCollector)this.targetCache.get(target, () -> CommonProxy.createItemStorageCache(target, this.containerCache));
        }
        catch (ExecutionException e) {
            WailaExceptionHandler.handleErr(e, null, null, null);
            return null;
        }
        if (itemCollector == ItemCollector.EMPTY) {
            return null;
        }
        return itemCollector.update(target, world.method_8510());
    }

    @Override
    public List<ClientViewGroup<ItemView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<class_1799>> groups) {
        return ClientViewGroup.map(groups, ItemView::new, null);
    }
}

