/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.bulkupdate.comparison;

import me.lucko.luckperms.common.bulkupdate.PreparedStatementBuilder;
import me.lucko.luckperms.common.bulkupdate.comparison.Comparison;

public class Constraint {
    private final Comparison comparison;
    private final String expressionValue;
    private final Comparison.CompiledExpression compiledExpression;

    public static Constraint of(Comparison comparison, String expression) {
        return new Constraint(comparison, expression);
    }

    private Constraint(Comparison comparison, String expression) {
        this.comparison = comparison;
        this.expressionValue = expression;
        this.compiledExpression = this.comparison.compile(this.expressionValue);
    }

    public boolean eval(String value) {
        return this.compiledExpression.test(value);
    }

    public void appendSql(PreparedStatementBuilder builder, String field) {
        builder.append(field).append(' ');
        this.comparison.appendSql(builder);
        builder.append(' ');
        builder.variable(this.expressionValue);
    }

    public String toString() {
        return this.comparison + " " + this.expressionValue;
    }
}

