/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.cacheddata.result;

import me.lucko.luckperms.common.cacheddata.result.StringResult;
import net.luckperms.api.cacheddata.Result;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.WeightNode;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class IntegerResult<N extends Node>
implements Result<Integer, N> {
    private final int result;
    private final N node;
    private IntegerResult<N> overriddenResult;
    private static final IntegerResult<?> NULL_RESULT = new IntegerResult<Object>(0, null, null);

    public IntegerResult(int result, N node, IntegerResult<N> overriddenResult) {
        this.result = result;
        this.node = node;
        this.overriddenResult = overriddenResult;
    }

    @Override
    @Deprecated
    public @NonNull Integer result() {
        return this.result;
    }

    public int intResult() {
        return this.result;
    }

    public StringResult<N> asStringResult() {
        if (this.isNull()) {
            return StringResult.nullResult();
        }
        StringResult<N> result = StringResult.of(Integer.toString(this.result), this.node);
        if (this.overriddenResult != null) {
            result.setOverriddenResult(this.overriddenResult.asStringResult());
        }
        return result;
    }

    @Override
    public @Nullable N node() {
        return this.node;
    }

    public @Nullable IntegerResult<N> overriddenResult() {
        return this.overriddenResult;
    }

    public void setOverriddenResult(IntegerResult<N> overriddenResult) {
        this.overriddenResult = overriddenResult;
    }

    public boolean isNull() {
        return this == NULL_RESULT;
    }

    public IntegerResult<N> copy() {
        return new IntegerResult<N>(this.result, this.node, this.overriddenResult);
    }

    public String toString() {
        return "IntegerResult(result=" + this.result + ", node=" + this.node + ", overriddenResult=" + this.overriddenResult + ')';
    }

    public static <N extends Node> IntegerResult<N> nullResult() {
        return NULL_RESULT;
    }

    public static <N extends Node> IntegerResult<N> of(int result) {
        return new IntegerResult<Object>(result, null, null);
    }

    public static <N extends Node> IntegerResult<N> of(int result, N node) {
        return new IntegerResult<N>(result, node, null);
    }

    public static IntegerResult<WeightNode> of(WeightNode node) {
        return new IntegerResult<WeightNode>(node.getWeight(), node, null);
    }
}

