/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.cacheddata.result;

import net.luckperms.api.cacheddata.Result;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.ChatMetaNode;
import net.luckperms.api.node.types.MetaNode;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class StringResult<N extends Node>
implements Result<String, N> {
    private final String result;
    private final N node;
    private StringResult<N> overriddenResult;
    private static final StringResult<?> NULL_RESULT = new StringResult<Object>(null, null, null);

    public StringResult(String result, N node, StringResult<N> overriddenResult) {
        this.result = result;
        this.node = node;
        this.overriddenResult = overriddenResult;
    }

    @Override
    public @Nullable String result() {
        return this.result;
    }

    @Override
    public @Nullable N node() {
        return this.node;
    }

    public @Nullable StringResult<N> overriddenResult() {
        return this.overriddenResult;
    }

    public void setOverriddenResult(StringResult<N> overriddenResult) {
        this.overriddenResult = overriddenResult;
    }

    public StringResult<N> copy() {
        return new StringResult<N>(this.result, this.node, this.overriddenResult);
    }

    public String toString() {
        return "StringResult(result=" + this.result + ", node=" + this.node + ", overriddenResult=" + this.overriddenResult + ')';
    }

    public static <N extends Node> StringResult<N> nullResult() {
        return NULL_RESULT;
    }

    public static <N extends Node> StringResult<N> of(String result) {
        return new StringResult<Object>(result, null, null);
    }

    public static <N extends Node> StringResult<N> of(String result, N node) {
        return new StringResult<N>(result, node, null);
    }

    public static StringResult<MetaNode> of(MetaNode node) {
        return new StringResult<MetaNode>(node.getMetaValue(), node, null);
    }

    public static <N extends ChatMetaNode<?, ?>> StringResult<N> of(N node) {
        return new StringResult<N>(node.getMetaValue(), node, null);
    }
}

