/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.command;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.command.abstraction.Command;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.tabcomplete.CompletionSupplier;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.commands.group.CreateGroup;
import me.lucko.luckperms.common.commands.group.DeleteGroup;
import me.lucko.luckperms.common.commands.group.GroupParentCommand;
import me.lucko.luckperms.common.commands.group.ListGroups;
import me.lucko.luckperms.common.commands.log.LogParentCommand;
import me.lucko.luckperms.common.commands.misc.ApplyEditsCommand;
import me.lucko.luckperms.common.commands.misc.BulkUpdateCommand;
import me.lucko.luckperms.common.commands.misc.EditorCommand;
import me.lucko.luckperms.common.commands.misc.ExportCommand;
import me.lucko.luckperms.common.commands.misc.ImportCommand;
import me.lucko.luckperms.common.commands.misc.InfoCommand;
import me.lucko.luckperms.common.commands.misc.NetworkSyncCommand;
import me.lucko.luckperms.common.commands.misc.ReloadConfigCommand;
import me.lucko.luckperms.common.commands.misc.SearchCommand;
import me.lucko.luckperms.common.commands.misc.SyncCommand;
import me.lucko.luckperms.common.commands.misc.TranslationsCommand;
import me.lucko.luckperms.common.commands.misc.TreeCommand;
import me.lucko.luckperms.common.commands.misc.TrustEditorCommand;
import me.lucko.luckperms.common.commands.misc.VerboseCommand;
import me.lucko.luckperms.common.commands.track.CreateTrack;
import me.lucko.luckperms.common.commands.track.DeleteTrack;
import me.lucko.luckperms.common.commands.track.ListTracks;
import me.lucko.luckperms.common.commands.track.TrackParentCommand;
import me.lucko.luckperms.common.commands.user.UserParentCommand;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.plugin.AbstractLuckPermsPlugin;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.plugin.scheduler.SchedulerAdapter;
import me.lucko.luckperms.common.plugin.scheduler.SchedulerTask;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.ExpiringSet;
import me.lucko.luckperms.common.util.ImmutableCollectors;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.text.ComponentLike;
import me.lucko.luckperms.lib.adventure.text.TextComponent;
import me.lucko.luckperms.lib.adventure.text.event.ClickEvent;
import me.lucko.luckperms.lib.adventure.text.format.NamedTextColor;
import me.lucko.luckperms.lib.adventure.text.format.TextColor;

public class CommandManager {
    private final LuckPermsPlugin plugin;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("luckperms-command-executor").build());
    private final AtomicBoolean executingCommand = new AtomicBoolean(false);
    private final ExpiringSet<UUID> playerRateLimit = new ExpiringSet(500L, TimeUnit.MILLISECONDS);
    private final TabCompletions tabCompletions;
    private final Map<String, Command<?>> mainCommands;

    public CommandManager(LuckPermsPlugin plugin) {
        this.plugin = plugin;
        this.tabCompletions = new TabCompletions(plugin);
        this.mainCommands = (Map)ImmutableList.builder().add((Object)new UserParentCommand()).add((Object)new GroupParentCommand()).add((Object)new TrackParentCommand()).addAll(plugin.getExtraCommands()).add((Object)new LogParentCommand()).add((Object)new SyncCommand()).add((Object)new InfoCommand()).add((Object)new EditorCommand()).add((Object)new VerboseCommand()).add((Object)new TreeCommand()).add((Object)new SearchCommand()).add((Object)new NetworkSyncCommand()).add((Object)new ImportCommand()).add((Object)new ExportCommand()).add((Object)new ReloadConfigCommand()).add((Object)new BulkUpdateCommand()).add((Object)new TranslationsCommand()).add((Object)new ApplyEditsCommand()).add((Object)new TrustEditorCommand()).add((Object)new CreateGroup()).add((Object)new DeleteGroup()).add((Object)new ListGroups()).add((Object)new CreateTrack()).add((Object)new DeleteTrack()).add((Object)new ListTracks()).build().stream().collect(ImmutableCollectors.toMap(c -> c.getName().toLowerCase(Locale.ROOT), Function.identity()));
    }

    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }

    public TabCompletions getTabCompletions() {
        return this.tabCompletions;
    }

    @VisibleForTesting
    public Map<String, Command<?>> getMainCommands() {
        return this.mainCommands;
    }

    public CompletableFuture<Void> executeCommand(Sender sender, String label, List<String> args) {
        UUID uniqueId = sender.getUniqueId();
        if (this.plugin.getConfiguration().get(ConfigKeys.COMMANDS_RATE_LIMIT).booleanValue() && !sender.isConsole() && !this.playerRateLimit.add(uniqueId)) {
            this.plugin.getLogger().warn("Player '" + uniqueId + "' is spamming LuckPerms commands. Ignoring further inputs.");
            return CompletableFuture.completedFuture(null);
        }
        SchedulerAdapter scheduler = this.plugin.getBootstrap().getScheduler();
        ArrayList<String> argsCopy = new ArrayList<String>(args);
        if (this.executingCommand.get()) {
            Message.ALREADY_EXECUTING_COMMAND.send(sender);
        }
        AtomicReference executorThread = new AtomicReference();
        AtomicReference<SchedulerTask> timeoutTask = new AtomicReference<SchedulerTask>();
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
            executorThread.set(Thread.currentThread());
            this.executingCommand.set(true);
            try {
                this.execute(sender, label, args);
            }
            catch (Throwable e) {
                this.plugin.getLogger().severe("Exception whilst executing command: " + args, e);
            }
            finally {
                this.executingCommand.set(false);
                executorThread.set(null);
                SchedulerTask timeout = (SchedulerTask)timeoutTask.get();
                if (timeout != null) {
                    timeout.cancel();
                }
            }
        }, this.executor);
        timeoutTask.set(scheduler.asyncLater(() -> {
            if (!future.isDone()) {
                this.handleCommandTimeout(executorThread, argsCopy);
            }
        }, 10L, TimeUnit.SECONDS));
        return future;
    }

    private void handleCommandTimeout(AtomicReference<Thread> thread, List<String> args) {
        Thread executorThread = thread.get();
        if (executorThread == null) {
            this.plugin.getLogger().warn("Command execution " + args + " has not completed - is another command execution blocking it?");
        } else {
            String stackTrace = Arrays.stream(executorThread.getStackTrace()).map(el -> "  " + el.toString()).collect(Collectors.joining("\n"));
            this.plugin.getLogger().warn("Command execution " + args + " has not completed. Trace: \n" + stackTrace);
        }
    }

    public boolean hasPermissionForAny(Sender sender) {
        return this.mainCommands.values().stream().anyMatch(c -> c.shouldDisplay() && c.isAuthorized(sender));
    }

    private void execute(Sender sender, String label, List<String> arguments) {
        CommandManager.applyConvenienceAliases(arguments, true);
        if (arguments.isEmpty() || arguments.size() == 1 && arguments.get(0).trim().isEmpty()) {
            sender.sendMessage((Component)Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_GREEN)).append((Component)Component.text((String)"Running "))).append((Component)Component.text((String)AbstractLuckPermsPlugin.getPluginName(), (TextColor)NamedTextColor.AQUA))).append((Component)Component.space())).append((Component)Component.text((String)("v" + this.plugin.getBootstrap().getVersion()), (TextColor)NamedTextColor.AQUA))).append((Component)Message.FULL_STOP)));
            if (this.hasPermissionForAny(sender)) {
                Message.VIEW_AVAILABLE_COMMANDS_PROMPT.send(sender, label);
                return;
            }
            Collection groups = this.plugin.getGroupManager().getAll().values();
            if (groups.size() <= 1 && groups.stream().allMatch(g -> g.normalData().isEmpty())) {
                Message.FIRST_TIME_SETUP.send(sender, label, sender.getName());
            } else {
                Message.NO_PERMISSION_FOR_SUBCOMMANDS.send(sender);
            }
            return;
        }
        Command<?> main = this.mainCommands.get(arguments.get(0).toLowerCase(Locale.ROOT));
        if (main == null) {
            this.sendCommandUsage(sender, label);
            return;
        }
        if (!main.isAuthorized(sender)) {
            this.sendCommandUsage(sender, label);
            return;
        }
        arguments.remove(0);
        if (main.getArgumentCheck().test(arguments.size())) {
            main.sendDetailedUsage(sender, label);
            return;
        }
        try {
            main.execute(this.plugin, sender, null, new ArgumentList(arguments), label);
        }
        catch (CommandException e) {
            e.handle(sender, label, main);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public List<String> tabCompleteCommand(Sender sender, List<String> arguments) {
        CommandManager.applyConvenienceAliases(arguments, false);
        List mains = this.mainCommands.values().stream().filter(Command::shouldDisplay).filter(m -> m.isAuthorized(sender)).collect(Collectors.toList());
        return TabCompleter.create().at(0, CompletionSupplier.startsWith(() -> mains.stream().map(c -> c.getName().toLowerCase(Locale.ROOT)))).from(1, partial -> mains.stream().filter(m -> m.getName().equalsIgnoreCase((String)arguments.get(0))).findFirst().map(cmd -> cmd.tabComplete(this.plugin, sender, new ArgumentList(arguments.subList(1, arguments.size())))).orElse(Collections.emptyList())).complete(arguments);
    }

    private void sendCommandUsage(Sender sender, String label) {
        sender.sendMessage((Component)Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_GREEN)).append((Component)Component.text((String)"Running "))).append((Component)Component.text((String)AbstractLuckPermsPlugin.getPluginName(), (TextColor)NamedTextColor.AQUA))).append((Component)Component.space())).append((Component)Component.text((String)("v" + this.plugin.getBootstrap().getVersion()), (TextColor)NamedTextColor.AQUA))).append((Component)Message.FULL_STOP)));
        this.mainCommands.values().stream().filter(Command::shouldDisplay).filter(c -> c.isAuthorized(sender)).forEach(c -> sender.sendMessage((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'>', (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.space())).append((Component)Component.text((String)String.format(c.getUsage(), label), (TextColor)NamedTextColor.GREEN))).clickEvent(ClickEvent.suggestCommand((String)String.format(c.getUsage(), label)))).build()));
    }

    private static void applyConvenienceAliases(List<String> args, boolean rewriteLastArgument) {
        String arg0;
        if (args.size() >= 1 && (rewriteLastArgument || args.size() >= 2)) {
            CommandManager.replaceArgs(args, 0, arg -> {
                switch (arg) {
                    case "u": {
                        return "user";
                    }
                    case "g": {
                        return "group";
                    }
                    case "t": {
                        return "track";
                    }
                    case "i": {
                        return "info";
                    }
                }
                return null;
            });
        }
        if (args.size() >= 3 && (rewriteLastArgument || args.size() >= 4) && ((arg0 = args.get(0).toLowerCase(Locale.ROOT)).equals("user") || arg0.equals("group"))) {
            String arg2;
            CommandManager.replaceArgs(args, 2, arg -> {
                switch (arg) {
                    case "p": 
                    case "perm": {
                        return "permission";
                    }
                    case "g": 
                    case "group": {
                        return "parent";
                    }
                    case "m": {
                        return "meta";
                    }
                    case "i": {
                        return "info";
                    }
                    case "e": {
                        return "editor";
                    }
                }
                return null;
            });
            if (args.size() >= 4 && (rewriteLastArgument || args.size() >= 5) && ((arg2 = args.get(2).toLowerCase(Locale.ROOT)).equals("permission") || arg2.equals("parent") || arg2.equals("meta"))) {
                CommandManager.replaceArgs(args, 3, arg -> arg.equals("i") ? "info" : null);
            }
        }
    }

    private static void replaceArgs(List<String> args, int i, Function<String, String> rewrites) {
        String arg = args.get(i).toLowerCase(Locale.ROOT);
        String rewrite = rewrites.apply(arg);
        if (rewrite != null) {
            args.remove(i);
            args.add(i, rewrite);
        }
    }
}

