/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.generic.permission;

import java.time.Duration;
import java.util.List;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.abstraction.GenericChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.node.factory.NodeBuilders;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.MutableContextSet;
import net.luckperms.api.model.data.DataMutateResult;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.model.data.TemporaryNodeMergeStrategy;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.InheritanceNode;

public class PermissionSetTemp
extends GenericChildCommand {
    public PermissionSetTemp() {
        super(CommandSpec.PERMISSION_SETTEMP, "settemp", CommandPermission.USER_PERM_SET_TEMP, CommandPermission.GROUP_PERM_SET_TEMP, Predicates.inRange(0, 2));
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, PermissionHolder target, ArgumentList args, String label, CommandPermission permission) throws CommandException {
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, permission, target)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return;
        }
        String node = args.get(0);
        boolean value = args.getBooleanOrInsert(1, true);
        Duration duration = args.getDuration(2);
        TemporaryNodeMergeStrategy modifier = args.getTemporaryModifierAndRemove(3).orElseGet(() -> plugin.getConfiguration().get(ConfigKeys.TEMPORARY_ADD_BEHAVIOUR));
        MutableContextSet context = args.getContextOrDefault(3, plugin);
        if (node.isEmpty()) {
            Message.INVALID_PERMISSION_EMPTY.send(sender);
            return;
        }
        if (ArgumentPermissions.checkContext(plugin, sender, permission, context) || ArgumentPermissions.checkGroup(plugin, sender, target, (ContextSet)context) || ArgumentPermissions.checkArguments(plugin, sender, permission, node)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return;
        }
        Object builtNode = NodeBuilders.determineMostApplicable(node).value(value).withContext(context).expiry(duration).build();
        if (builtNode instanceof InheritanceNode && ArgumentPermissions.checkGroup(plugin, sender, ((InheritanceNode)builtNode).getGroupName(), (ContextSet)context)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return;
        }
        DataMutateResult.WithMergedNode result = target.setNode(DataType.NORMAL, (Node)builtNode, modifier);
        if (result.getResult().wasSuccessful()) {
            duration = result.getMergedNode().getExpiryDuration();
            Message.SETPERMISSION_TEMP_SUCCESS.send(sender, node, value, target, duration, context);
            LoggedAction.build().source(sender).target(target).description("permission", "settemp", node, value, duration, context).build().submit(plugin, sender);
            StorageAssistant.save(target, sender, plugin);
        } else {
            Message.ALREADY_HAS_TEMP_PERMISSION.send(sender, target, node, context);
        }
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, ArgumentList args) {
        return TabCompleter.create().at(0, TabCompletions.permissions(plugin)).at(1, TabCompletions.booleans()).from(3, TabCompletions.contexts(plugin)).complete((List<String>)((Object)args));
    }
}

