/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.group;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.cache.LoadingMap;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.comparator.NodeEntryComparator;
import me.lucko.luckperms.common.node.matcher.ConstraintNodeMatcher;
import me.lucko.luckperms.common.node.matcher.StandardNodeMatchers;
import me.lucko.luckperms.common.node.types.Inheritance;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.NodeEntry;
import me.lucko.luckperms.common.util.Iterators;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.node.types.InheritanceNode;

public class GroupListMembers
extends ChildCommand<Group> {
    public GroupListMembers() {
        super(CommandSpec.GROUP_LISTMEMBERS, "listmembers", CommandPermission.GROUP_LIST_MEMBERS, Predicates.notInRange(0, 1));
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, Group target, ArgumentList args, String label) {
        if (ArgumentPermissions.checkViewPerms(plugin, sender, this.getPermission().get(), target)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return;
        }
        Inheritance node = Inheritance.builder(target.getName()).build();
        ConstraintNodeMatcher<Inheritance> matcher = StandardNodeMatchers.key(node);
        int page = args.getIntOrDefault(0, 1);
        Message.SEARCH_SEARCHING_MEMBERS.send(sender, target.getName());
        List matchedUsers = plugin.getStorage().searchUserNodes(matcher).join().stream().filter(n -> ((InheritanceNode)n.getNode()).getValue()).collect(Collectors.toList());
        if (target.getName().equals("default")) {
            for (User user : plugin.getUserManager().getAll().values()) {
                if (plugin.getUserManager().isNonDefaultUser(user)) continue;
                matchedUsers.add(NodeEntry.of(user.getUniqueId(), node));
            }
            Message.SEARCH_RESULT_GROUP_DEFAULT.send(sender);
        }
        List matchedGroups = plugin.getStorage().searchGroupNodes(matcher).join().stream().filter(n -> ((InheritanceNode)n.getNode()).getValue()).collect(Collectors.toList());
        int users = matchedUsers.size();
        int groups = matchedGroups.size();
        Message.SEARCH_RESULT.send(sender, users + groups, users, groups);
        if (!matchedUsers.isEmpty()) {
            LoadingMap<UUID, String> uuidLookups = LoadingMap.of(u -> plugin.lookupUsername((UUID)u).orElseGet(u::toString));
            GroupListMembers.sendResult(sender, matchedUsers, uuidLookups::get, Message.SEARCH_SHOWING_USERS, HolderType.USER, label, page);
        }
        if (!matchedGroups.isEmpty()) {
            GroupListMembers.sendResult(sender, matchedGroups, Function.identity(), Message.SEARCH_SHOWING_GROUPS, HolderType.GROUP, label, page);
        }
    }

    private static <T extends Comparable<T>> void sendResult(Sender sender, List<NodeEntry<T, InheritanceNode>> results, Function<T, String> lookupFunction, Message.Args3<Integer, Integer, Integer> headerMessage, HolderType holderType, String label, int page) {
        results = new ArrayList<NodeEntry<T, InheritanceNode>>(results);
        results.sort(NodeEntryComparator.normal());
        int pageIndex = page - 1;
        List<List<NodeEntry<T, InheritanceNode>>> pages = Iterators.divideIterable(results, 15);
        if (pageIndex < 0 || pageIndex >= pages.size()) {
            page = 1;
            pageIndex = 0;
        }
        List<NodeEntry<T, InheritanceNode>> content = pages.get(pageIndex);
        List mappedContent = content.stream().map(hp -> Maps.immutableEntry((Object)((String)lookupFunction.apply(hp.getHolder())), (Object)hp)).collect(Collectors.toList());
        headerMessage.send(sender, page, pages.size(), results.size());
        for (Map.Entry ent : mappedContent) {
            Message.SEARCH_INHERITS_NODE_ENTRY.send(sender, (InheritanceNode)((NodeEntry)ent.getValue()).getNode(), (String)ent.getKey(), holderType, label, sender.getPlugin());
        }
    }
}

