/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.misc;

import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPInputStream;
import me.lucko.luckperms.common.backup.Importer;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.http.UnsuccessfulRequestException;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.common.util.gson.GsonProvider;

public class ImportCommand
extends SingleCommand {
    private final AtomicBoolean running = new AtomicBoolean(false);

    public ImportCommand() {
        super(CommandSpec.IMPORT, "Import", CommandPermission.IMPORT, Predicates.notInRange(1, 3));
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, ArgumentList args, String label) {
        JsonObject data;
        block19: {
            boolean fromFile;
            if (this.running.get()) {
                Message.IMPORT_ALREADY_RUNNING.send(sender);
                return;
            }
            boolean bl = fromFile = !args.remove("--upload");
            if (fromFile) {
                Path pathWithDefaultExtension;
                String fileName = args.get(0);
                Path dataDirectory = plugin.getBootstrap().getDataDirectory();
                Path path = dataDirectory.resolve(fileName);
                if (!path.getParent().equals(dataDirectory) || path.getFileName().toString().equals("config.yml")) {
                    Message.FILE_NOT_WITHIN_DIRECTORY.send(sender, path.toString());
                    return;
                }
                if (!Files.exists(path, new LinkOption[0]) && !fileName.contains(".") && Files.exists(pathWithDefaultExtension = path.resolveSibling(fileName + ".json.gz"), new LinkOption[0])) {
                    path = pathWithDefaultExtension;
                }
                if (!Files.exists(path, new LinkOption[0])) {
                    Message.IMPORT_FILE_DOESNT_EXIST.send(sender, path.toString());
                    return;
                }
                if (!Files.isReadable(path)) {
                    Message.IMPORT_FILE_NOT_READABLE.send(sender, path.toString());
                    return;
                }
                if (!this.running.compareAndSet(false, true)) {
                    Message.IMPORT_ALREADY_RUNNING.send(sender);
                    return;
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(Files.newInputStream(path, new OpenOption[0])), StandardCharsets.UTF_8));){
                    data = (JsonObject)GsonProvider.normal().fromJson((Reader)reader, JsonObject.class);
                    break block19;
                }
                catch (IOException e) {
                    plugin.getLogger().warn("Error whilst reading from the import file", e);
                    Message.IMPORT_FILE_READ_FAILURE.send(sender);
                    this.running.set(false);
                    return;
                }
            }
            String code = args.get(0);
            if (code.isEmpty()) {
                Message.IMPORT_WEB_INVALID_CODE.send(sender, code);
                return;
            }
            try {
                data = plugin.getBytebin().getJsonContent(code).getAsJsonObject();
            }
            catch (UnsuccessfulRequestException e) {
                Message.HTTP_REQUEST_FAILURE.send(sender, e.getResponse().code(), e.getResponse().message());
                return;
            }
            catch (IOException e) {
                plugin.getLogger().severe("Error reading data to bytebin", e);
                Message.HTTP_UNKNOWN_FAILURE.send(sender);
                return;
            }
            if (data == null) {
                Message.IMPORT_UNABLE_TO_READ.send(sender, code);
                return;
            }
        }
        Importer importer = new Importer(plugin, sender, data, !args.contains("--replace"));
        plugin.getBootstrap().getScheduler().executeAsync(() -> {
            try {
                importer.run();
            }
            finally {
                this.running.set(false);
            }
        });
    }

    public boolean isRunning() {
        return this.running.get();
    }
}

