/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.misc;

import java.util.Optional;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.messaging.InternalMessagingService;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;

public class NetworkSyncCommand
extends SingleCommand {
    public NetworkSyncCommand() {
        super(CommandSpec.NETWORK_SYNC, "NetworkSync", CommandPermission.SYNC, Predicates.alwaysFalse());
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, ArgumentList args, String label) {
        Message.UPDATE_TASK_REQUEST.send(sender);
        plugin.getSyncTaskBuffer().request().join();
        Message.UPDATE_TASK_COMPLETE_NETWORK.send(sender);
        Optional<InternalMessagingService> messagingService = plugin.getMessagingService();
        if (!messagingService.isPresent()) {
            Message.UPDATE_TASK_PUSH_FAILURE_NOT_SETUP.send(sender);
            return;
        }
        try {
            messagingService.get().pushUpdate();
            Message.UPDATE_TASK_PUSH_SUCCESS.send(sender, messagingService.get().getName());
        }
        catch (Exception e) {
            plugin.getLogger().warn("Error whilst pushing changes to other servers", e);
            Message.UPDATE_TASK_PUSH_FAILURE.send(sender);
        }
    }
}

