/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.track;

import java.util.List;
import java.util.Locale;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.lib.adventure.text.Component;
import net.luckperms.api.actionlog.Action;
import net.luckperms.api.event.cause.DeletionCause;

public class DeleteTrack
extends SingleCommand {
    public DeleteTrack() {
        super(CommandSpec.DELETE_TRACK, "DeleteTrack", CommandPermission.DELETE_TRACK, Predicates.not(1));
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, ArgumentList args, String label) {
        if (args.isEmpty()) {
            this.sendUsage(sender, label);
            return;
        }
        String trackName = args.get(0).toLowerCase(Locale.ROOT);
        Track track = plugin.getStorage().loadTrack(trackName).join().orElse(null);
        if (track == null) {
            Message.TRACK_LOAD_ERROR.send(sender);
            return;
        }
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, this.getPermission().get(), track)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return;
        }
        try {
            plugin.getStorage().deleteTrack(track, DeletionCause.COMMAND).get();
        }
        catch (Exception e) {
            plugin.getLogger().warn("Error whilst deleting track", e);
            Message.DELETE_ERROR.send(sender, (Component)Component.text((String)track.getName()));
            return;
        }
        Message.DELETE_SUCCESS.send(sender, (Component)Component.text((String)trackName));
        LoggedAction.build().source(sender).targetName(trackName).targetType(Action.Target.Type.TRACK).description("delete").build().submit(plugin, sender);
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, ArgumentList args) {
        return TabCompleter.create().at(0, TabCompletions.tracks(plugin)).complete((List<String>)((Object)args));
    }
}

