/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.context;

import java.util.Locale;
import java.util.Objects;
import net.luckperms.api.context.Context;
import net.luckperms.api.context.ContextSatisfyMode;
import net.luckperms.api.context.ContextSet;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractContextSet
implements ContextSet {
    @Override
    public boolean isSatisfiedBy(@NonNull ContextSet other, @NonNull ContextSatisfyMode mode) {
        if (this == other) {
            return true;
        }
        Objects.requireNonNull(other, "other");
        Objects.requireNonNull(mode, "mode");
        if (this.isEmpty()) {
            return true;
        }
        if (other.isEmpty()) {
            return false;
        }
        if (mode == ContextSatisfyMode.ALL_VALUES_PER_KEY && this.size() > other.size()) {
            return false;
        }
        return this.otherContainsAll(other, mode);
    }

    protected abstract boolean otherContainsAll(ContextSet var1, ContextSatisfyMode var2);

    static String sanitizeKey(String key) {
        Objects.requireNonNull(key, "key is null");
        if (!Context.isValidKey(key)) {
            throw new IllegalArgumentException("key is (effectively) empty");
        }
        return key.toLowerCase(Locale.ROOT);
    }

    static String sanitizeValue(String value) {
        Objects.requireNonNull(value, "value is null");
        if (!Context.isValidValue(value)) {
            throw new IllegalArgumentException("value is (effectively) empty");
        }
        return value.toLowerCase(Locale.ROOT);
    }

    public static boolean isGlobalServerWorldEntry(String key, String value) {
        return (key.equals("server") || key.equals("world")) && value.equals("global");
    }
}

