/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.context;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import me.lucko.luckperms.common.context.AbstractContextSet;
import me.lucko.luckperms.common.context.ContextImpl;
import me.lucko.luckperms.common.context.MutableContextSetImpl;
import me.lucko.luckperms.common.context.comparator.ContextComparator;
import net.luckperms.api.context.Context;
import net.luckperms.api.context.ContextSatisfyMode;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.context.MutableContextSet;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ImmutableContextSetImpl
extends AbstractContextSet
implements ImmutableContextSet,
ContextSet {
    public static final ImmutableContextSetImpl EMPTY = new ImmutableContextSetImpl(new Context[0]);
    private final Context[] array;
    private final int size;
    private final int hashCode;
    private ImmutableSetMultimap<String, String> cachedMap;

    public static ImmutableContextSet of(String key, String value) {
        if (ImmutableContextSetImpl.isGlobalServerWorldEntry(key = ImmutableContextSetImpl.sanitizeKey(key), value = ImmutableContextSetImpl.sanitizeValue(value))) {
            return EMPTY;
        }
        return new ImmutableContextSetImpl(new Context[]{new ContextImpl(key, value)});
    }

    ImmutableContextSetImpl(Context[] contexts) {
        this.array = contexts;
        this.size = this.array.length;
        this.hashCode = Arrays.hashCode(this.array);
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    @Deprecated
    public @NonNull ImmutableContextSetImpl immutableCopy() {
        return this;
    }

    public ImmutableSetMultimap<String, String> toMultimap() {
        if (this.cachedMap == null) {
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            for (Context entry : this.array) {
                builder.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            this.cachedMap = builder.build();
        }
        return this.cachedMap;
    }

    @Override
    public @NonNull MutableContextSet mutableCopy() {
        return new MutableContextSetImpl((SetMultimap<String, String>)this.toMultimap());
    }

    @Override
    public @NonNull Set<Context> toSet() {
        return ImmutableSet.copyOf((Object[])this.array);
    }

    @Override
    public @NonNull Map<String, Set<String>> toMap() {
        return Multimaps.asMap(this.toMultimap());
    }

    @Override
    @Deprecated
    public @NonNull Map<String, String> toFlattenedMap() {
        ImmutableMap.Builder m = ImmutableMap.builder();
        for (Context e : this.array) {
            m.put((Object)e.getKey(), (Object)e.getValue());
        }
        return m.build();
    }

    public Context[] toArray() {
        return this.array;
    }

    @Override
    protected boolean otherContainsAll(ContextSet other, ContextSatisfyMode mode) {
        switch (mode) {
            case ALL_VALUES_PER_KEY: {
                for (Context e : this.array) {
                    if (other.contains(e.getKey(), e.getValue())) continue;
                    return false;
                }
                return true;
            }
            case AT_LEAST_ONE_VALUE_PER_KEY: {
                Context[] array = this.array;
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    Context e = array[i];
                    boolean otherContains = other.contains(e.getKey(), e.getValue());
                    if (otherContains) {
                        while (i + 1 < len && array[i + 1].getKey().equals(e.getKey())) {
                            ++i;
                        }
                        continue;
                    }
                    int next = i + 1;
                    if (next < len && array[next].getKey().equals(e.getKey())) continue;
                    return false;
                }
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown mode: " + (Object)((Object)mode));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextSet)) {
            return false;
        }
        ContextSet that = (ContextSet)o;
        if (that instanceof ImmutableContextSetImpl) {
            ImmutableContextSetImpl immutableThat = (ImmutableContextSetImpl)that;
            if (this.hashCode != immutableThat.hashCode) {
                return false;
            }
            return Arrays.equals(this.array, immutableThat.array);
        }
        return this.size() == that.size() && this.otherContainsAll(that, ContextSatisfyMode.ALL_VALUES_PER_KEY);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "ImmutableContextSet(" + Arrays.toString(this.array) + ")";
    }

    @Override
    public boolean containsKey(@NonNull String key) {
        Objects.requireNonNull(key, "key");
        return Arrays.binarySearch(this.array, new ContextImpl(key, null), ContextComparator.ONLY_KEY) >= 0;
    }

    @Override
    public @NonNull Set<String> getValues(@NonNull String key) {
        Collection values = this.toMap().get(ImmutableContextSetImpl.sanitizeKey(key));
        return values != null ? ImmutableSet.copyOf((Collection)values) : ImmutableSet.of();
    }

    @Override
    public boolean contains(@NonNull Context entry) {
        Objects.requireNonNull(entry, "entry");
        return Arrays.binarySearch(this.array, entry) >= 0;
    }

    @Override
    public boolean contains(@NonNull String key, @NonNull String value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        return this.contains(new ContextImpl(key, value));
    }

    @Override
    public @NonNull Iterator<Context> iterator() {
        return Iterators.forArray((Object[])this.array);
    }

    @Override
    public Spliterator<Context> spliterator() {
        return Arrays.spliterator(this.array);
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    static /* synthetic */ Context[] access$000(ImmutableContextSetImpl x0) {
        return x0.array;
    }

    public static final class BuilderImpl
    implements ImmutableContextSet.Builder {
        private static final int INITIAL_SIZE = 16;
        private Context[] builder = ImmutableContextSetImpl.access$000(EMPTY);
        private int size = 0;

        private void put(String key, String value) {
            Context[] dest;
            ContextImpl context = new ContextImpl(key, value);
            int pos = Arrays.binarySearch(this.builder, 0, this.size, context);
            if (pos >= 0) {
                return;
            }
            int insertPos = -pos - 1;
            if (this.builder.length == this.size) {
                dest = new Context[Math.max(this.builder.length * 2, 16)];
                System.arraycopy(this.builder, 0, dest, 0, insertPos);
            } else {
                dest = this.builder;
            }
            System.arraycopy(this.builder, insertPos, dest, insertPos + 1, this.size - insertPos);
            dest[insertPos] = context;
            ++this.size;
            this.builder = dest;
        }

        @Override
        public @NonNull BuilderImpl add(@NonNull String key, @NonNull String value) {
            if (AbstractContextSet.isGlobalServerWorldEntry(key = AbstractContextSet.sanitizeKey(key), value = AbstractContextSet.sanitizeValue(value))) {
                return this;
            }
            this.put(key, value);
            return this;
        }

        @Override
        public @NonNull BuilderImpl addAll(@NonNull ContextSet contextSet) {
            Objects.requireNonNull(contextSet, "contextSet");
            this.addAll(contextSet.toSet());
            return this;
        }

        @Override
        public @NonNull ImmutableContextSet build() {
            if (this.builder.length == 0) {
                return EMPTY;
            }
            return new ImmutableContextSetImpl(Arrays.copyOf(this.builder, this.size));
        }
    }
}

