/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.context.calculator;

import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import net.luckperms.api.context.Context;
import net.luckperms.api.context.ContextConsumer;

public interface WorldNameRewriter {
    public static WorldNameRewriter of(Map<String, String> rewrites) {
        if (rewrites.isEmpty()) {
            return new Empty();
        }
        return new NonEmpty(rewrites);
    }

    public void rewriteAndSubmit(String var1, ContextConsumer var2);

    public static class Empty
    implements WorldNameRewriter {
        @Override
        public void rewriteAndSubmit(String worldName, ContextConsumer consumer) {
            if (Context.isValidValue(worldName)) {
                consumer.accept("world", worldName);
            }
        }
    }

    public static class NonEmpty
    implements WorldNameRewriter {
        private final Map<String, String> rewrites;

        public NonEmpty(Map<String, String> rewrites) {
            this.rewrites = rewrites;
        }

        @Override
        public void rewriteAndSubmit(String worldName, ContextConsumer consumer) {
            HashSet<String> seen = new HashSet<String>();
            worldName = worldName.toLowerCase(Locale.ROOT);
            while (Context.isValidValue(worldName) && seen.add(worldName)) {
                consumer.accept("world", worldName);
                if ((worldName = this.rewrites.get(worldName)) != null) continue;
                break;
            }
        }
    }
}

