/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.messaging.rabbitmq;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.plugin.scheduler.SchedulerTask;
import me.lucko.luckperms.lib.rabbitmq.client.AMQP;
import me.lucko.luckperms.lib.rabbitmq.client.BuiltinExchangeType;
import me.lucko.luckperms.lib.rabbitmq.client.Channel;
import me.lucko.luckperms.lib.rabbitmq.client.Connection;
import me.lucko.luckperms.lib.rabbitmq.client.ConnectionFactory;
import me.lucko.luckperms.lib.rabbitmq.client.DeliverCallback;
import me.lucko.luckperms.lib.rabbitmq.client.Delivery;
import net.luckperms.api.messenger.IncomingMessageConsumer;
import net.luckperms.api.messenger.Messenger;
import net.luckperms.api.messenger.message.OutgoingMessage;
import org.checkerframework.checker.nullness.qual.NonNull;

public class RabbitMQMessenger
implements Messenger {
    private static final int DEFAULT_PORT = 5672;
    private static final String EXCHANGE = "luckperms";
    private static final String ROUTING_KEY = "luckperms:update";
    private static final boolean CHANNEL_PROP_DURABLE = false;
    private static final boolean CHANNEL_PROP_EXCLUSIVE = true;
    private static final boolean CHANNEL_PROP_AUTO_DELETE = true;
    private final LuckPermsPlugin plugin;
    private final IncomingMessageConsumer consumer;
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private Channel channel;
    private Subscription sub;
    private SchedulerTask checkConnectionTask;

    public RabbitMQMessenger(LuckPermsPlugin plugin, IncomingMessageConsumer consumer) {
        this.plugin = plugin;
        this.consumer = consumer;
    }

    public void init(String address, String virtualHost, String username, String password) {
        String[] addressSplit = address.split(":");
        String host = addressSplit[0];
        int port = addressSplit.length > 1 ? Integer.parseInt(addressSplit[1]) : 5672;
        this.connectionFactory = new ConnectionFactory();
        this.connectionFactory.setHost(host);
        this.connectionFactory.setPort(port);
        this.connectionFactory.setVirtualHost(virtualHost);
        this.connectionFactory.setUsername(username);
        this.connectionFactory.setPassword(password);
        this.sub = new Subscription();
        this.checkAndReopenConnection(true);
        this.checkConnectionTask = this.plugin.getBootstrap().getScheduler().asyncRepeating(() -> this.checkAndReopenConnection(false), 5L, TimeUnit.SECONDS);
    }

    @Override
    public void sendOutgoingMessage(@NonNull OutgoingMessage outgoingMessage) {
        try {
            ByteArrayDataOutput output = ByteStreams.newDataOutput();
            output.writeUTF(outgoingMessage.asEncodedString());
            this.channel.basicPublish(EXCHANGE, ROUTING_KEY, new AMQP.BasicProperties.Builder().build(), output.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        try {
            this.channel.close();
            this.connection.close();
            this.checkConnectionTask.cancel();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean checkAndReopenConnection(boolean firstStartup) {
        boolean channelAlive;
        boolean connectionAlive = this.connection != null && this.connection.isOpen();
        boolean bl = channelAlive = this.channel != null && this.channel.isOpen();
        if (connectionAlive && channelAlive) {
            return true;
        }
        if (this.channel != null && this.channel.isOpen()) {
            try {
                this.channel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.connection != null && this.connection.isOpen()) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!firstStartup) {
            this.plugin.getLogger().warn("RabbitMQ pubsub connection dropped, trying to re-open the connection");
        }
        try {
            this.connection = this.connectionFactory.newConnection();
            this.channel = this.connection.createChannel();
            String queue = this.channel.queueDeclare("", false, true, true, null).getQueue();
            this.channel.exchangeDeclare(EXCHANGE, BuiltinExchangeType.TOPIC, false, true, null);
            this.channel.queueBind(queue, EXCHANGE, ROUTING_KEY);
            this.channel.basicConsume(queue, true, (DeliverCallback)this.sub, tag -> {});
            if (!firstStartup) {
                this.plugin.getLogger().info("RabbitMQ pubsub connection re-established");
            }
            return true;
        }
        catch (Exception e) {
            if (firstStartup) {
                this.plugin.getLogger().warn("Unable to connect to RabbitMQ, waiting for 5 seconds then retrying...", e);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                return this.checkAndReopenConnection(false);
            }
            this.plugin.getLogger().severe("Unable to connect to RabbitMQ", e);
            return false;
        }
    }

    private class Subscription
    implements DeliverCallback {
        private Subscription() {
        }

        public void handle(String consumerTag, Delivery message) {
            try {
                byte[] data = message.getBody();
                ByteArrayDataInput input = ByteStreams.newDataInput((byte[])data);
                String msg = input.readUTF();
                RabbitMQMessenger.this.consumer.consumeIncomingMessageAsString(msg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

