/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.query;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import me.lucko.luckperms.common.context.ImmutableContextSetImpl;
import me.lucko.luckperms.common.query.FlagUtils;
import me.lucko.luckperms.common.query.QueryOptionsBuilderImpl;
import net.luckperms.api.context.ContextSatisfyMode;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.query.Flag;
import net.luckperms.api.query.OptionKey;
import net.luckperms.api.query.QueryMode;
import net.luckperms.api.query.QueryOptions;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class QueryOptionsImpl
implements QueryOptions {
    public static final QueryOptions DEFAULT_CONTEXTUAL = new QueryOptionsImpl(QueryMode.CONTEXTUAL, ImmutableContextSetImpl.EMPTY, FlagUtils.ALL_FLAGS, null);
    public static final QueryOptions DEFAULT_NON_CONTEXTUAL = new QueryOptionsImpl(QueryMode.NON_CONTEXTUAL, null, FlagUtils.ALL_FLAGS, null);
    private final QueryMode mode;
    private final ImmutableContextSet context;
    private final byte flags;
    private final ImmutableMap<OptionKey<?>, Object> options;
    private final int hashCode;
    private Set<Flag> flagsSet = null;
    private final ContextSatisfyMode contextSatisfyMode;

    QueryOptionsImpl(QueryMode mode, @Nullable ImmutableContextSet context, byte flags, @Nullable Map<OptionKey<?>, Object> options) {
        this.mode = mode;
        this.context = context;
        this.flags = flags;
        this.options = options == null ? null : ImmutableMap.copyOf(options);
        this.hashCode = this.calculateHashCode();
        this.contextSatisfyMode = options == null ? null : (ContextSatisfyMode)((Object)options.get(ContextSatisfyMode.KEY));
    }

    @Override
    public @NonNull QueryMode mode() {
        return this.mode;
    }

    @Override
    public @NonNull ImmutableContextSet context() {
        if (this.mode != QueryMode.CONTEXTUAL) {
            throw new IllegalStateException("Mode is not CONTEXTUAL");
        }
        return this.context;
    }

    @Override
    public boolean flag(@NonNull Flag flag) {
        Objects.requireNonNull(flag, "flag");
        return FlagUtils.read(this.flags, flag);
    }

    @Override
    public @NonNull Set<Flag> flags() {
        ImmutableSet set;
        if (this.flagsSet != null) {
            return this.flagsSet;
        }
        this.flagsSet = set = ImmutableSet.copyOf(FlagUtils.toSet(this.flags));
        return set;
    }

    @Override
    public <O> @NonNull Optional<O> option(@NonNull OptionKey<O> key) {
        if (this.options == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.options.get(key));
    }

    @Override
    public @NonNull Map<OptionKey<?>, Object> options() {
        if (this.options == null) {
            return ImmutableMap.of();
        }
        return this.options;
    }

    @Override
    public boolean satisfies(@NonNull ContextSet contextSet, @NonNull ContextSatisfyMode defaultContextSatisfyMode) {
        switch (this.mode) {
            case CONTEXTUAL: {
                return contextSet.isSatisfiedBy(this.context, this.contextSatisfyMode == null ? defaultContextSatisfyMode : this.contextSatisfyMode);
            }
            case NON_CONTEXTUAL: {
                return true;
            }
        }
        throw new AssertionError();
    }

    @Override
    public @NonNull QueryOptions.Builder toBuilder() {
        return new QueryOptionsBuilderImpl(this.mode, this.context, this.flags, (Map<OptionKey<?>, Object>)this.options);
    }

    public String toString() {
        return "QueryOptions(mode=" + (Object)((Object)this.mode) + ", context=" + this.context + ", flags=" + this.flags() + ", options=" + this.options + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryOptionsImpl that = (QueryOptionsImpl)o;
        return this.flags == that.flags && this.mode == that.mode && Objects.equals(this.context, that.context) && Objects.equals(this.options, that.options);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int calculateHashCode() {
        int result = this.mode.hashCode();
        result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
        result = 31 * result + this.flags;
        result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
        return result;
    }
}

