/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.file;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.bulkupdate.BulkUpdate;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.node.matcher.ConstraintNodeMatcher;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.implementation.file.AbstractConfigurateStorage;
import me.lucko.luckperms.common.storage.implementation.file.StorageLocation;
import me.lucko.luckperms.common.storage.implementation.file.loader.ConfigurateLoader;
import me.lucko.luckperms.common.storage.implementation.file.watcher.FileWatcher;
import me.lucko.luckperms.common.storage.misc.NodeEntry;
import me.lucko.luckperms.common.util.Iterators;
import me.lucko.luckperms.common.util.Uuids;
import me.lucko.luckperms.lib.configurate.ConfigurationNode;
import me.lucko.luckperms.lib.configurate.loader.ConfigurationLoader;
import net.luckperms.api.node.Node;

public class CombinedConfigurateStorage
extends AbstractConfigurateStorage {
    private final String fileExtension;
    private CachedLoader users;
    private CachedLoader groups;
    private CachedLoader tracks;
    private FileWatcher.WatchedLocation watcher = null;

    public CombinedConfigurateStorage(LuckPermsPlugin plugin, String implementationName, ConfigurateLoader loader, String fileExtension, String dataFolderName) {
        super(plugin, implementationName, loader, dataFolderName);
        this.fileExtension = fileExtension;
    }

    @Override
    protected ConfigurationNode readFile(StorageLocation location, String name) throws IOException {
        ConfigurationNode root = this.getLoader(location).getNode();
        ConfigurationNode node = root.getNode(new Object[]{name});
        return node.isVirtual() ? null : node;
    }

    @Override
    protected void saveFile(StorageLocation location, String name, ConfigurationNode node) throws IOException {
        this.getLoader(location).apply(true, false, root -> root.getNode(new Object[]{name}).setValue((Object)node));
    }

    private CachedLoader getLoader(StorageLocation location) {
        switch (location) {
            case USERS: {
                return this.users;
            }
            case GROUPS: {
                return this.groups;
            }
            case TRACKS: {
                return this.tracks;
            }
        }
        throw new RuntimeException();
    }

    @Override
    public void init() throws IOException {
        super.init();
        this.users = new CachedLoader(this.dataDirectory.resolve("users" + this.fileExtension));
        this.groups = new CachedLoader(this.dataDirectory.resolve("groups" + this.fileExtension));
        this.tracks = new CachedLoader(this.dataDirectory.resolve("tracks" + this.fileExtension));
        FileWatcher watcher = this.plugin.getFileWatcher().orElse(null);
        if (watcher != null) {
            this.watcher = watcher.getWatcher(this.dataDirectory);
            this.watcher.addListener(path -> {
                if (path.getFileName().equals(this.users.file.getFileName())) {
                    this.plugin.getLogger().info("[FileWatcher] Detected change in users file - reloading...");
                    this.users.reload();
                    this.plugin.getSyncTaskBuffer().request();
                } else if (path.getFileName().equals(this.groups.file.getFileName())) {
                    this.plugin.getLogger().info("[FileWatcher] Detected change in groups file - reloading...");
                    this.groups.reload();
                    this.plugin.getSyncTaskBuffer().request();
                } else if (path.getFileName().equals(this.tracks.file.getFileName())) {
                    this.plugin.getLogger().info("[FileWatcher] Detected change in tracks file - reloading...");
                    this.tracks.reload();
                    this.plugin.getStorage().loadAllTracks();
                }
            });
        }
    }

    @Override
    public void shutdown() {
        try {
            this.users.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.groups.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.tracks.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        super.shutdown();
    }

    @Override
    public void applyBulkUpdate(BulkUpdate bulkUpdate) throws Exception {
        if (bulkUpdate.getDataType().isIncludingUsers()) {
            this.users.apply(true, true, root -> {
                for (Map.Entry entry : root.getChildrenMap().entrySet()) {
                    this.processBulkUpdate(bulkUpdate, (ConfigurationNode)entry.getValue(), HolderType.USER);
                }
            });
        }
        if (bulkUpdate.getDataType().isIncludingGroups()) {
            this.groups.apply(true, true, root -> {
                for (Map.Entry entry : root.getChildrenMap().entrySet()) {
                    this.processBulkUpdate(bulkUpdate, (ConfigurationNode)entry.getValue(), HolderType.GROUP);
                }
            });
        }
    }

    @Override
    public Set<UUID> getUniqueUsers() throws IOException {
        return this.users.getNode().getChildrenMap().keySet().stream().map(Object::toString).map(Uuids::fromString).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public <N extends Node> List<NodeEntry<UUID, N>> searchUserNodes(ConstraintNodeMatcher<N> constraint) throws Exception {
        ArrayList held = new ArrayList();
        this.users.apply(false, true, root -> {
            for (Map.Entry entry : root.getChildrenMap().entrySet()) {
                try {
                    UUID holder = UUID.fromString(entry.getKey().toString());
                    ConfigurationNode object = (ConfigurationNode)entry.getValue();
                    Set<Node> nodes = CombinedConfigurateStorage.readNodes(object);
                    for (Node e : nodes) {
                        Object match = constraint.match(e);
                        if (match == null) continue;
                        held.add(NodeEntry.of(holder, match));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return held;
    }

    @Override
    public void loadAllGroups() throws IOException {
        ArrayList groups = new ArrayList();
        this.groups.apply(false, true, root -> groups.addAll(root.getChildrenMap().keySet().stream().map(Object::toString).collect(Collectors.toList())));
        if (!Iterators.tryIterate(groups, this::loadGroup)) {
            throw new RuntimeException("Exception occurred whilst loading a group");
        }
        this.plugin.getGroupManager().retainAll(groups);
    }

    @Override
    public <N extends Node> List<NodeEntry<String, N>> searchGroupNodes(ConstraintNodeMatcher<N> constraint) throws Exception {
        ArrayList held = new ArrayList();
        this.groups.apply(false, true, root -> {
            for (Map.Entry entry : root.getChildrenMap().entrySet()) {
                try {
                    String holder = entry.getKey().toString();
                    ConfigurationNode object = (ConfigurationNode)entry.getValue();
                    Set<Node> nodes = CombinedConfigurateStorage.readNodes(object);
                    for (Node e : nodes) {
                        Object match = constraint.match(e);
                        if (match == null) continue;
                        held.add(NodeEntry.of(holder, match));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return held;
    }

    @Override
    public void loadAllTracks() throws IOException {
        ArrayList tracks = new ArrayList();
        this.tracks.apply(false, true, root -> tracks.addAll(root.getChildrenMap().keySet().stream().map(Object::toString).collect(Collectors.toList())));
        if (!Iterators.tryIterate(tracks, this::loadTrack)) {
            throw new RuntimeException("Exception occurred whilst loading a track");
        }
        this.plugin.getTrackManager().retainAll(tracks);
    }

    private final class CachedLoader {
        private final Path file;
        private final ConfigurationLoader<? extends ConfigurationNode> loader;
        private final ReentrantLock lock = new ReentrantLock();
        private ConfigurationNode node = null;

        private CachedLoader(Path file) {
            this.file = file;
            this.loader = CombinedConfigurateStorage.this.loader.loader(file);
            this.reload();
        }

        private void recordChange() {
            if (CombinedConfigurateStorage.this.watcher != null) {
                CombinedConfigurateStorage.this.watcher.recordChange(this.file.getFileName().toString());
            }
        }

        public ConfigurationNode getNode() throws IOException {
            this.lock.lock();
            try {
                if (this.node == null) {
                    this.node = this.loader.load();
                }
                ConfigurationNode configurationNode = this.node;
                return configurationNode;
            }
            finally {
                this.lock.unlock();
            }
        }

        public void apply(Consumer<ConfigurationNode> action) throws IOException {
            this.apply(false, false, action);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void apply(boolean save, boolean reload, Consumer<ConfigurationNode> action) throws IOException {
            this.lock.lock();
            try {
                if (this.node == null || reload) {
                    this.reload();
                }
                action.accept(this.node);
                if (save) {
                    this.save();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public void save() throws IOException {
            this.lock.lock();
            try {
                this.recordChange();
                this.loader.save(this.node);
            }
            finally {
                this.lock.unlock();
            }
        }

        public void reload() {
            this.lock.lock();
            try {
                this.node = null;
                try {
                    this.recordChange();
                    this.node = this.loader.load();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

