/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.file;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.lucko.luckperms.common.storage.misc.PlayerSaveResultImpl;
import me.lucko.luckperms.common.util.Uuids;
import net.luckperms.api.model.PlayerSaveResult;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FileUuidCache {
    private static final Splitter KV_SPLIT = Splitter.on((char)':').omitEmptyStrings();
    private static final Splitter LEGACY_KV_SPLIT = Splitter.on((char)'=').omitEmptyStrings();
    private static final Splitter LEGACY_TIME_SPLIT = Splitter.on((char)'|').omitEmptyStrings();
    private final LookupMap lookupMap = new LookupMap();

    public PlayerSaveResult addMapping(UUID uuid, String username) {
        String oldUsername = this.lookupMap.put(uuid, username);
        PlayerSaveResultImpl result = PlayerSaveResultImpl.determineBaseResult(username, oldUsername);
        HashSet<UUID> conflicting = new HashSet<UUID>(this.lookupMap.lookupUuid(username));
        conflicting.remove(uuid);
        if (!conflicting.isEmpty()) {
            for (UUID conflict : conflicting) {
                this.lookupMap.remove(conflict);
            }
            result = result.withOtherUuidsPresent(conflicting);
        }
        return result;
    }

    public void removeMapping(UUID uuid) {
        this.lookupMap.remove(uuid);
    }

    public @Nullable UUID lookupUuid(String username) {
        Set<UUID> uuids = this.lookupMap.lookupUuid(username);
        return (UUID)Iterables.getFirst(uuids, null);
    }

    public String lookupUsername(UUID uuid) {
        return this.lookupMap.lookupUsername(uuid);
    }

    public void load(Path file) {
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            String entry;
            while ((entry = reader.readLine()) != null) {
                if ((entry = entry.trim()).isEmpty() || entry.startsWith("#")) continue;
                this.loadEntry(entry);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save(Path file) {
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write("# LuckPerms UUID lookup cache");
            writer.newLine();
            for (Map.Entry ent : this.lookupMap.entrySet()) {
                String out = ent.getKey() + ":" + (String)ent.getValue();
                writer.write(out);
                writer.newLine();
            }
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadEntry(String entry) {
        if (entry.contains(":")) {
            Iterator parts = KV_SPLIT.split((CharSequence)entry).iterator();
            if (!parts.hasNext()) {
                return;
            }
            String uuidPart = (String)parts.next();
            if (!parts.hasNext()) {
                return;
            }
            String usernamePart = (String)parts.next();
            UUID uuid = Uuids.fromString(uuidPart);
            if (uuid == null) {
                return;
            }
            this.lookupMap.put(uuid, usernamePart);
        } else if (entry.contains("=")) {
            UUID uuid;
            Iterator parts = LEGACY_KV_SPLIT.split((CharSequence)entry).iterator();
            if (!parts.hasNext()) {
                return;
            }
            String usernamePart = (String)parts.next();
            if (!parts.hasNext()) {
                return;
            }
            String uuidPart = (String)parts.next();
            if (uuidPart.contains("|")) {
                Iterator valueParts = LEGACY_TIME_SPLIT.split((CharSequence)uuidPart).iterator();
                if (!valueParts.hasNext()) {
                    return;
                }
                uuidPart = (String)valueParts.next();
            }
            if ((uuid = Uuids.fromString(uuidPart)) == null) {
                return;
            }
            this.lookupMap.put(uuid, usernamePart);
        }
    }

    private static final class LookupMap
    extends ConcurrentHashMap<UUID, String> {
        private final SetMultimap<String, UUID> reverse = Multimaps.newSetMultimap(new ConcurrentHashMap(), ConcurrentHashMap::newKeySet);

        private LookupMap() {
        }

        @Override
        public String put(@NonNull UUID key, @NonNull String value) {
            String existing = super.put(key, value);
            if (!value.equalsIgnoreCase(existing) && existing != null) {
                this.reverse.remove((Object)existing.toLowerCase(Locale.ROOT), (Object)key);
            }
            this.reverse.put((Object)value.toLowerCase(Locale.ROOT), (Object)key);
            return existing;
        }

        @Override
        public String remove(@NonNull Object k) {
            UUID key = (UUID)k;
            String username = (String)super.remove(key);
            if (username != null) {
                this.reverse.remove((Object)username.toLowerCase(Locale.ROOT), (Object)key);
            }
            return username;
        }

        public String lookupUsername(UUID uuid) {
            return (String)super.get(uuid);
        }

        public Set<UUID> lookupUuid(String name) {
            return this.reverse.get((Object)name.toLowerCase(Locale.ROOT));
        }
    }
}

