/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.webeditor;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import me.lucko.luckperms.common.context.ImmutableContextSetImpl;
import me.lucko.luckperms.common.context.serializer.ContextSetJsonSerializer;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.PermissionHolderIdentifier;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.matcher.ConstraintNodeMatcher;
import me.lucko.luckperms.common.node.utils.NodeJsonSerializer;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.NodeEntry;
import me.lucko.luckperms.common.util.ImmutableCollectors;
import me.lucko.luckperms.common.util.gson.GsonProvider;
import me.lucko.luckperms.common.util.gson.JArray;
import me.lucko.luckperms.common.util.gson.JObject;
import me.lucko.luckperms.common.verbose.event.CheckOrigin;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.node.Node;
import net.luckperms.api.query.QueryOptions;

public class WebEditorRequest {
    public static final int MAX_USERS = 500;
    private final JsonObject payload;
    private final Map<PermissionHolderIdentifier, List<Node>> holders;
    private final Map<String, List<String>> tracks;

    private WebEditorRequest(JsonObject payload, Map<PermissionHolder, List<Node>> holders, Map<Track, List<String>> tracks) {
        this.payload = payload;
        this.holders = (Map)holders.entrySet().stream().collect(ImmutableCollectors.toMap(e -> ((PermissionHolder)e.getKey()).getIdentifier(), Map.Entry::getValue));
        this.tracks = (Map)tracks.entrySet().stream().collect(ImmutableCollectors.toMap(e -> ((Track)e.getKey()).getName(), Map.Entry::getValue));
    }

    public JsonObject getPayload() {
        return this.payload;
    }

    public byte[] encode() {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new GZIPOutputStream(bytesOut), StandardCharsets.UTF_8);){
            GsonProvider.normal().toJson((JsonElement)this.payload, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytesOut.toByteArray();
    }

    public Map<PermissionHolderIdentifier, List<Node>> getHolders() {
        return this.holders;
    }

    public Map<String, List<String>> getTracks() {
        return this.tracks;
    }

    public static WebEditorRequest generate(List<PermissionHolder> holders, List<Track> tracks, Sender sender, String cmdLabel, LuckPermsPlugin plugin) {
        Preconditions.checkArgument((!holders.isEmpty() ? 1 : 0) != 0, (Object)"holders is empty");
        ImmutableContextSetImpl.BuilderImpl potentialContexts = new ImmutableContextSetImpl.BuilderImpl();
        potentialContexts.addAll(plugin.getContextManager().getPotentialContexts());
        for (PermissionHolder holder2 : holders) {
            holder2.normalData().forEach(node -> potentialContexts.addAll(node.getContexts()));
        }
        Map holdersMap = (Map)holders.stream().collect(ImmutableCollectors.toMap(Function.identity(), holder -> holder.normalData().asList()));
        Map tracksMap = (Map)tracks.stream().collect(ImmutableCollectors.toMap(Function.identity(), Track::getGroups));
        JsonObject json = WebEditorRequest.createJsonPayload(holdersMap, tracksMap, sender, cmdLabel, potentialContexts.build(), plugin).toJson();
        return new WebEditorRequest(json, holdersMap, tracksMap);
    }

    private static JObject createJsonPayload(Map<PermissionHolder, List<Node>> holders, Map<Track, List<String>> tracks, Sender sender, String cmdLabel, ImmutableContextSet potentialContexts, LuckPermsPlugin plugin) {
        return new JObject().add("metadata", WebEditorRequest.formMetadata(sender, cmdLabel, plugin.getBootstrap().getVersion())).add("permissionHolders", new JArray().consume(arr -> holders.forEach((holder, data) -> arr.add(WebEditorRequest.formPermissionHolder(holder, data))))).add("tracks", new JArray().consume(arr -> tracks.forEach((track, data) -> arr.add(WebEditorRequest.formTrack(track, data))))).add("knownPermissions", new JArray().addAll(plugin.getPermissionRegistry().rootAsList())).add("potentialContexts", (JsonElement)ContextSetJsonSerializer.serialize(potentialContexts));
    }

    private static JObject formMetadata(Sender sender, String cmdLabel, String pluginVersion) {
        return new JObject().add("commandAlias", cmdLabel).add("uploader", new JObject().add("name", sender.getNameWithLocation()).add("uuid", sender.getUniqueId().toString())).add("time", System.currentTimeMillis()).add("pluginVersion", pluginVersion);
    }

    private static JObject formPermissionHolder(PermissionHolder holder, List<Node> data) {
        return new JObject().add("type", holder.getType().toString()).add("id", holder.getIdentifier().getName()).add("displayName", holder.getPlainDisplayName()).add("nodes", (JsonElement)NodeJsonSerializer.serializeNodes(data));
    }

    private static JObject formTrack(Track track, List<String> data) {
        return new JObject().add("type", "track").add("id", track.getName()).add("groups", new JArray().addAll(data));
    }

    public static void includeMatchingGroups(List<? super Group> holders, Predicate<? super Group> filter, LuckPermsPlugin plugin) {
        plugin.getGroupManager().getAll().values().stream().filter(filter).sorted(Comparator.comparingInt(g -> g.getWeight().orElse(0)).reversed().thenComparing(Group::getName, String.CASE_INSENSITIVE_ORDER)).forEach(holders::add);
    }

    public static void includeMatchingUsers(List<? super User> holders, ConstraintNodeMatcher<Node> matcher, boolean includeOffline, LuckPermsPlugin plugin) {
        WebEditorRequest.includeMatchingUsers(holders, matcher == null ? Collections.emptyList() : Collections.singleton(matcher), includeOffline, plugin);
    }

    public static void includeMatchingUsers(List<? super User> holders, Collection<ConstraintNodeMatcher<Node>> matchers, boolean includeOffline, LuckPermsPlugin plugin) {
        LinkedHashMap<UUID, User> users = new LinkedHashMap<UUID, User>(plugin.getUserManager().getAll());
        if (!matchers.isEmpty()) {
            users.values().removeIf(user -> {
                for (ConstraintNodeMatcher matcher : matchers) {
                    if (!user.normalData().asList().stream().anyMatch(matcher)) continue;
                    return false;
                }
                return true;
            });
        }
        if (includeOffline && users.size() < 500) {
            if (matchers.isEmpty()) {
                WebEditorRequest.findMatchingOfflineUsers(users, null, plugin);
            } else {
                for (ConstraintNodeMatcher<Node> matcher : matchers) {
                    if (users.size() >= 500) break;
                    WebEditorRequest.findMatchingOfflineUsers(users, matcher, plugin);
                }
            }
        }
        users.values().stream().sorted(Comparator.comparingInt(u -> u.getCachedData().getMetaData(QueryOptions.nonContextual()).getWeight(CheckOrigin.INTERNAL).intResult()).reversed().thenComparing(u -> u.getUsername().isPresent(), ((Comparator)Boolean::compare).reversed()).thenComparing(User::getPlainDisplayName, String.CASE_INSENSITIVE_ORDER)).forEach(holders::add);
    }

    private static void findMatchingOfflineUsers(Map<UUID, User> users, ConstraintNodeMatcher<Node> matcher, LuckPermsPlugin plugin) {
        Stream<Object> stream = matcher == null ? plugin.getStorage().getUniqueUsers().join().stream() : plugin.getStorage().searchUserNodes(matcher).join().stream().map(NodeEntry::getHolder).distinct();
        Set<UUID> uuids = stream.filter(uuid -> !users.containsKey(uuid)).sorted().limit(500 - users.size()).collect(Collectors.toSet());
        if (uuids.isEmpty()) {
            return;
        }
        Map<UUID, User> loadedUsers = plugin.getStorage().loadUsers(uuids).join();
        users.putAll(loadedUsers);
        for (UUID uniqueId : loadedUsers.keySet()) {
            plugin.getUserManager().getHouseKeeper().cleanup(uniqueId);
        }
    }
}

