/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.webeditor.socket;

import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

public final class CryptographyUtils {
    private CryptographyUtils() {
    }

    public static PublicKey parsePublicKey(String base64String) throws IllegalArgumentException {
        try {
            byte[] bytes = Base64.getDecoder().decode(base64String);
            X509EncodedKeySpec spec = new X509EncodedKeySpec(bytes);
            KeyFactory rsa = KeyFactory.getInstance("RSA");
            return rsa.generatePublic(spec);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Exception parsing public key", e);
        }
    }

    public static KeyPair generateKeyPair() {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(4096);
            return generator.generateKeyPair();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception generating keypair", e);
        }
    }

    public static String sign(PrivateKey privateKey, String msg) {
        try {
            Signature sign = Signature.getInstance("SHA256withRSA");
            sign.initSign(privateKey);
            sign.update(msg.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(sign.sign());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean verify(PublicKey publicKey, String msg, String signatureBase64) {
        try {
            Signature sign = Signature.getInstance("SHA256withRSA");
            sign.initVerify(publicKey);
            sign.update(msg.getBytes(StandardCharsets.UTF_8));
            byte[] signatureBytes = Base64.getDecoder().decode(signatureBase64);
            return sign.verify(signatureBytes);
        }
        catch (Exception e) {
            return false;
        }
    }
}

