/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.webeditor.socket.listener;

import com.google.gson.JsonObject;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.webeditor.socket.CryptographyUtils;
import me.lucko.luckperms.common.webeditor.socket.SocketMessageType;
import me.lucko.luckperms.common.webeditor.socket.WebEditorSocket;
import me.lucko.luckperms.common.webeditor.socket.listener.Handler;
import me.lucko.luckperms.common.webeditor.store.RemoteSession;

public class HandlerHello
implements Handler {
    private static final String STATE_ACCEPTED = "accepted";
    private static final String STATE_UNTRUSTED = "untrusted";
    private static final String STATE_REJECTED = "rejected";
    private static final String STATE_INVALID = "invalid";
    private final WebEditorSocket socket;
    private final Map<String, PublicKey> attemptedConnections = new HashMap<String, PublicKey>();

    public HandlerHello(WebEditorSocket socket) {
        this.socket = socket;
    }

    public PublicKey getAttemptedConnection(String nonce) {
        return this.attemptedConnections.get(nonce);
    }

    public boolean hasAttemptedConnection() {
        return !this.attemptedConnections.isEmpty();
    }

    @Override
    public void handle(JsonObject msg) {
        String nonce = HandlerHello.getStringOrThrow(msg, "nonce");
        String sessionId = HandlerHello.getStringOrThrow(msg, "sessionId");
        String browser = msg.get("browser").getAsString();
        PublicKey remotePublicKey = CryptographyUtils.parsePublicKey(msg.get("publicKey").getAsString());
        if (this.socket.getRemotePublicKey() != null && !this.socket.getRemotePublicKey().equals(remotePublicKey)) {
            this.sendReply(nonce, STATE_REJECTED);
            return;
        }
        RemoteSession session = this.socket.getPlugin().getWebEditorStore().sessions().getSession(sessionId);
        if (session == null || session.isCompleted()) {
            this.sendReply(nonce, STATE_INVALID);
            return;
        }
        if (!this.socket.getPlugin().getWebEditorStore().keystore().isTrusted(this.socket.getSender(), remotePublicKey.getEncoded())) {
            this.sendReply(nonce, STATE_UNTRUSTED);
            Message.EDITOR_SOCKET_UNTRUSTED.send(this.socket.getSender(), nonce, browser, this.socket.getSession().getCommandLabel(), this.socket.getSender().isConsole());
            this.attemptedConnections.put(nonce, remotePublicKey);
            return;
        }
        boolean reconnected = this.socket.getRemotePublicKey() != null;
        this.socket.setRemotePublicKey(remotePublicKey);
        this.sendReply(nonce, STATE_ACCEPTED);
        if (reconnected) {
            Message.EDITOR_SOCKET_RECONNECTED.send(this.socket.getSender());
        } else {
            Message.EDITOR_SOCKET_CONNECTED.send(this.socket.getSender());
        }
    }

    private void sendReply(String nonce, String state) {
        this.socket.send(SocketMessageType.HELLO_REPLY.builder().add("nonce", nonce).add("state", state).toJson());
    }

    private static String getStringOrThrow(JsonObject msg, String key) {
        String val = msg.get(key).getAsString();
        if (val == null || val.isEmpty()) {
            throw new IllegalStateException("missing " + key);
        }
        return val;
    }
}

