/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.webeditor.store;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.security.KeyPair;
import java.util.concurrent.CompletableFuture;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.webeditor.socket.CryptographyUtils;
import me.lucko.luckperms.common.webeditor.store.WebEditorKeystore;
import me.lucko.luckperms.common.webeditor.store.WebEditorSessionMap;
import me.lucko.luckperms.common.webeditor.store.WebEditorSocketMap;

public class WebEditorStore {
    private final WebEditorSessionMap sessions = new WebEditorSessionMap();
    private final WebEditorSocketMap sockets = new WebEditorSocketMap();
    private final WebEditorKeystore keystore;
    private final Supplier<CompletableFuture<KeyPair>> keyPair;

    public WebEditorStore(LuckPermsPlugin plugin) {
        this.keystore = new WebEditorKeystore(plugin.getBootstrap().getConfigDirectory().resolve("editor-keystore.json"));
        Supplier keyPair = () -> CompletableFuture.supplyAsync(CryptographyUtils::generateKeyPair, plugin.getBootstrap().getScheduler().async());
        if (plugin.getConfiguration().get(ConfigKeys.EDITOR_LAZILY_GENERATE_KEY).booleanValue()) {
            this.keyPair = Suppliers.memoize((Supplier)keyPair);
        } else {
            CompletableFuture future = (CompletableFuture)keyPair.get();
            this.keyPair = () -> future;
        }
    }

    public WebEditorSessionMap sessions() {
        return this.sessions;
    }

    public WebEditorSocketMap sockets() {
        return this.sockets;
    }

    public WebEditorKeystore keystore() {
        return this.keystore;
    }

    public KeyPair keyPair() {
        return (KeyPair)((CompletableFuture)this.keyPair.get()).join();
    }
}

