/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.fabric.mixin;

import java.util.Locale;
import me.lucko.luckperms.common.cacheddata.type.MonitoredMetaCache;
import me.lucko.luckperms.common.cacheddata.type.PermissionCache;
import me.lucko.luckperms.common.context.manager.QueryOptionsCache;
import me.lucko.luckperms.common.locale.TranslationManager;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.verbose.event.CheckOrigin;
import me.lucko.luckperms.fabric.context.FabricContextManager;
import me.lucko.luckperms.fabric.event.PlayerChangeWorldCallback;
import me.lucko.luckperms.fabric.model.MixinUser;
import net.luckperms.api.query.QueryOptions;
import net.luckperms.api.util.Tristate;
import net.minecraft.class_2803;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
implements MixinUser {
    private User luckperms$user;
    private QueryOptionsCache<class_3222> luckperms$queryOptions;
    private Locale luckperms$locale;

    @Shadow
    public abstract class_3218 method_51469();

    @Override
    public User getLuckPermsUser() {
        return this.luckperms$user;
    }

    @Override
    public QueryOptionsCache<class_3222> getQueryOptionsCache() {
        return this.luckperms$queryOptions;
    }

    @Override
    public QueryOptionsCache<class_3222> getQueryOptionsCache(FabricContextManager contextManager) {
        if (this.luckperms$queryOptions == null) {
            this.luckperms$queryOptions = contextManager.newQueryOptionsCache((class_3222)this);
        }
        return this.luckperms$queryOptions;
    }

    @Override
    public Locale getCachedLocale() {
        return this.luckperms$locale;
    }

    @Override
    public void initializePermissions(User user) {
        this.luckperms$user = user;
        if (this.luckperms$queryOptions == null) {
            this.getQueryOptionsCache((FabricContextManager)user.getPlugin().getContextManager());
        }
    }

    @Override
    public Tristate hasPermission(String permission) {
        if (permission == null) {
            throw new NullPointerException("permission");
        }
        if (this.luckperms$user == null || this.luckperms$queryOptions == null) {
            return Tristate.UNDEFINED;
        }
        return this.hasPermission(permission, this.luckperms$queryOptions.getQueryOptions());
    }

    @Override
    public Tristate hasPermission(String permission, QueryOptions queryOptions) {
        if (permission == null) {
            throw new NullPointerException("permission");
        }
        if (queryOptions == null) {
            throw new NullPointerException("queryOptions");
        }
        User user = this.luckperms$user;
        if (user == null || this.luckperms$queryOptions == null) {
            return Tristate.UNDEFINED;
        }
        PermissionCache data = user.getCachedData().getPermissionData(queryOptions);
        return data.checkPermission(permission, CheckOrigin.PLATFORM_API_HAS_PERMISSION).result();
    }

    @Override
    public String getOption(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (this.luckperms$user == null || this.luckperms$queryOptions == null) {
            return null;
        }
        return this.getOption(key, this.luckperms$queryOptions.getQueryOptions());
    }

    @Override
    public String getOption(String key, QueryOptions queryOptions) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (queryOptions == null) {
            throw new NullPointerException("queryOptions");
        }
        User user = this.luckperms$user;
        if (user == null || this.luckperms$queryOptions == null) {
            return null;
        }
        MonitoredMetaCache cache = user.getCachedData().getMetaData(queryOptions);
        return cache.getMetaOrChatMetaValue(key, CheckOrigin.PLATFORM_API);
    }

    @Inject(at={@At(value="TAIL")}, method={"copyFrom"})
    private void luckperms_copyFrom(class_3222 oldPlayer, boolean alive, CallbackInfo ci) {
        MixinUser oldMixin = (MixinUser)oldPlayer;
        this.luckperms$user = oldMixin.getLuckPermsUser();
        this.luckperms$queryOptions = oldMixin.getQueryOptionsCache();
        this.luckperms$queryOptions.invalidate();
        this.luckperms$locale = oldMixin.getCachedLocale();
    }

    @Inject(at={@At(value="HEAD")}, method={"setClientSettings"})
    private void luckperms_setClientSettings(class_2803 information, CallbackInfo ci) {
        String language = information.comp_266();
        this.luckperms$locale = TranslationManager.parseLocale(language);
    }

    @Inject(at={@At(value="TAIL")}, method={"worldChanged"})
    private void luckperms_onChangeDimension(class_3218 targetWorld, CallbackInfo ci) {
        ((PlayerChangeWorldCallback)PlayerChangeWorldCallback.EVENT.invoker()).onChangeWorld(this.method_51469(), targetWorld, (class_3222)this);
    }
}

