/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.capability.v2.initializer;

import com.google.common.collect.Maps;
import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentInitializer;
import dev.onyxstudios.cca.api.v3.entity.RespawnCopyStrategy;
import fuzs.puzzleslib.api.capability.v2.data.PlayerRespawnCopyStrategy;
import fuzs.puzzleslib.impl.capability.ComponentFactoryRegistry;
import fuzs.puzzleslib.impl.capability.FabricCapabilityController;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class EntityComponentInitializerImpl
implements EntityComponentInitializer {
    private static final Map<PlayerRespawnCopyStrategy, RespawnCopyStrategy<Component>> COPY_STRATEGY_CONVERSIONS = Maps.immutableEnumMap(Map.of(PlayerRespawnCopyStrategy.ALWAYS, RespawnCopyStrategy.ALWAYS_COPY, PlayerRespawnCopyStrategy.KEEP_INVENTORY, RespawnCopyStrategy.INVENTORY, PlayerRespawnCopyStrategy.RETURNING_FROM_END, RespawnCopyStrategy.LOSSLESS_ONLY, PlayerRespawnCopyStrategy.NEVER, RespawnCopyStrategy.NEVER_COPY));

    public void registerEntityComponentFactories(EntityComponentFactoryRegistry registry) {
        FabricCapabilityController.registerComponentFactories(class_1297.class, registry);
    }

    public static <T extends class_1297> ComponentFactoryRegistry<T> getEntityFactory(Class<T> entityType) {
        Objects.requireNonNull(entityType, "entity type is null");
        return (o, componentKey, factory) -> ((EntityComponentFactoryRegistry)o).registerFor(entityType, componentKey, factory::apply);
    }

    public static ComponentFactoryRegistry<class_1657> getPlayerFactory(PlayerRespawnCopyStrategy playerRespawnCopyStrategy) {
        Objects.requireNonNull(playerRespawnCopyStrategy, "player respawn copy strategy is null");
        return (o, componentKey, factory) -> {
            RespawnCopyStrategy<Component> respawnCopyStrategy = COPY_STRATEGY_CONVERSIONS.get((Object)playerRespawnCopyStrategy);
            Objects.requireNonNull(respawnCopyStrategy, "respawn copy strategy is null");
            ((EntityComponentFactoryRegistry)o).registerForPlayers(componentKey, factory::apply, respawnCopyStrategy);
        };
    }
}

