/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui;

import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.CustomTabProvider;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.PlaceholderCategory;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.api.utils.MutableDimension;
import dev.isxander.yacl3.api.utils.OptionUtils;
import dev.isxander.yacl3.gui.DescriptionWithName;
import dev.isxander.yacl3.gui.OptionDescriptionWidget;
import dev.isxander.yacl3.gui.OptionListWidget;
import dev.isxander.yacl3.gui.SearchFieldWidget;
import dev.isxander.yacl3.gui.YACLTooltip;
import dev.isxander.yacl3.gui.controllers.ControllerPopupWidget;
import dev.isxander.yacl3.gui.controllers.PopupControllerScreen;
import dev.isxander.yacl3.gui.tab.ListHolderWidget;
import dev.isxander.yacl3.gui.tab.ScrollableNavigationBar;
import dev.isxander.yacl3.gui.tab.TabExt;
import dev.isxander.yacl3.gui.utils.GuiUtils;
import dev.isxander.yacl3.impl.utils.YACLConstants;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5489;
import net.minecraft.class_7919;
import net.minecraft.class_8002;
import net.minecraft.class_8030;
import net.minecraft.class_8087;
import net.minecraft.class_8088;
import org.jetbrains.annotations.Nullable;

public class YACLScreen
extends class_437 {
    public final YetAnotherConfigLib config;
    private final class_437 parent;
    public final class_8088 tabManager = new class_8088(x$0 -> {
        class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
    }, x$0 -> this.method_37066((class_364)x$0));
    public ScrollableNavigationBar tabNavigationBar;
    public class_8030 tabArea;
    public class_2561 saveButtonMessage;
    public class_7919 saveButtonTooltipMessage;
    private int saveButtonMessageTime;
    private boolean pendingChanges;
    public ControllerPopupWidget<?> currentPopupController = null;
    public boolean popupControllerVisible = false;

    public YACLScreen(YetAnotherConfigLib config, class_437 parent) {
        super(config.title());
        this.config = config;
        this.parent = parent;
        OptionUtils.forEachOptions(config, option -> option.addListener((opt, val) -> this.onOptionChanged((Option<?>)opt)));
    }

    protected void method_25426() {
        int currentTab;
        this.tabArea = new class_8030(0, 23, this.field_22789, this.field_22790 - 24 + 1);
        int n = currentTab = this.tabNavigationBar != null ? this.tabNavigationBar.getTabs().indexOf((Object)this.tabManager.method_48614()) : 0;
        if (currentTab == -1) {
            currentTab = 0;
        }
        this.tabNavigationBar = new ScrollableNavigationBar(this.field_22789, this.tabManager, this.config.categories().stream().map(category -> {
            if (category instanceof CustomTabProvider) {
                CustomTabProvider tabProvider = (CustomTabProvider)((Object)category);
                return tabProvider.createTab(this, this.tabArea);
            }
            if (category instanceof PlaceholderCategory) {
                PlaceholderCategory placeholder = (PlaceholderCategory)category;
                return new PlaceholderTab(placeholder, this);
            }
            return new CategoryTab(this, (ConfigCategory)category, this.tabArea);
        }).toList());
        this.tabNavigationBar.method_48987(currentTab, false);
        this.tabNavigationBar.method_49613();
        this.tabManager.method_48616(this.tabArea);
        this.method_37063((class_364)this.tabNavigationBar);
        this.config.initConsumer().accept(this);
    }

    public void addPopupControllerWidget(ControllerPopupWidget<?> controllerPopupWidget) {
        if (this.currentPopupController != null) {
            this.clearPopupControllerWidget();
        }
        this.currentPopupController = controllerPopupWidget;
        this.popupControllerVisible = true;
        OptionListWidget optionListWidget = null;
        class_8087 class_80872 = this.tabNavigationBar.getTabManager().method_48614();
        if (class_80872 instanceof CategoryTab) {
            CategoryTab categoryTab = (CategoryTab)class_80872;
            optionListWidget = categoryTab.optionList.getList();
        }
        if (optionListWidget != null) {
            this.field_22787.method_1507((class_437)new PopupControllerScreen(this, controllerPopupWidget));
        }
    }

    public void clearPopupControllerWidget() {
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof PopupControllerScreen) {
            PopupControllerScreen popupControllerScreen = (PopupControllerScreen)class_4372;
            popupControllerScreen.method_25419();
        }
        this.popupControllerVisible = false;
        this.currentPopupController = null;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.method_25434(graphics);
        super.method_25394(graphics, mouseX, mouseY, delta);
    }

    public void method_25420(class_332 guiGraphics) {
        super.method_25420(guiGraphics);
        class_8087 class_80872 = this.tabManager.method_48614();
        if (class_80872 instanceof TabExt) {
            TabExt tab = (TabExt)class_80872;
            tab.renderBackground(guiGraphics);
        }
    }

    public void finishOrSave() {
        this.saveButtonMessage = null;
        if (this.pendingChanges()) {
            HashSet flags = new HashSet();
            OptionUtils.forEachOptions(this.config, option -> {
                if (option.applyValue()) {
                    flags.addAll(option.flags());
                }
            });
            OptionUtils.forEachOptions(this.config, option -> {
                if (option.changed()) {
                    option.forgetPendingValue();
                    YACLConstants.LOGGER.error("Option '{}' value mismatch after applying! Reset to binding's getter.", (Object)option.name().getString());
                }
            });
            this.config.saveFunction().run();
            flags.forEach(flag -> flag.accept(this.field_22787));
            this.pendingChanges = false;
            class_8087 class_80872 = this.tabManager.method_48614();
            if (class_80872 instanceof CategoryTab) {
                CategoryTab categoryTab = (CategoryTab)class_80872;
                categoryTab.updateButtons();
            }
        } else {
            this.method_25419();
        }
    }

    public void cancelOrReset() {
        if (this.pendingChanges()) {
            OptionUtils.forEachOptions(this.config, Option::forgetPendingValue);
            this.method_25419();
        } else {
            OptionUtils.forEachOptions(this.config, Option::requestSetDefault);
        }
    }

    public void undo() {
        OptionUtils.forEachOptions(this.config, Option::forgetPendingValue);
    }

    public void method_25393() {
        class_8087 class_80872 = this.tabManager.method_48614();
        if (class_80872 instanceof TabExt) {
            TabExt tabExt = (TabExt)class_80872;
            tabExt.method_48613();
        }
        if ((class_80872 = this.tabManager.method_48614()) instanceof CategoryTab) {
            CategoryTab categoryTab = (CategoryTab)class_80872;
            if (this.saveButtonMessage != null) {
                if (this.saveButtonMessageTime > 140) {
                    this.saveButtonMessage = null;
                    this.saveButtonTooltipMessage = null;
                    this.saveButtonMessageTime = 0;
                } else {
                    ++this.saveButtonMessageTime;
                    categoryTab.saveFinishedButton.method_25355(this.saveButtonMessage);
                    if (this.saveButtonTooltipMessage != null) {
                        categoryTab.saveFinishedButton.method_47400(this.saveButtonTooltipMessage);
                    }
                }
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            this.method_25398(true);
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.method_25399() != null && this.method_25397() && (button == 0 || button == 1) && this.method_25399().method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void setSaveButtonMessage(class_2561 message, class_2561 tooltip2) {
        this.saveButtonMessage = message;
        this.saveButtonTooltipMessage = class_7919.method_47407((class_2561)tooltip2);
        this.saveButtonMessageTime = 0;
    }

    public boolean pendingChanges() {
        return this.pendingChanges;
    }

    private void onOptionChanged(Option<?> option) {
        this.pendingChanges = false;
        OptionUtils.consumeOptions(this.config, opt -> {
            this.pendingChanges |= opt.changed();
            return this.pendingChanges;
        });
        class_8087 class_80872 = this.tabManager.method_48614();
        if (class_80872 instanceof CategoryTab) {
            CategoryTab categoryTab = (CategoryTab)class_80872;
            categoryTab.updateButtons();
        }
    }

    public boolean method_25422() {
        if (this.pendingChanges()) {
            this.setSaveButtonMessage((class_2561)class_2561.method_43471((String)"yacl.gui.save_before_exit").method_27692(class_124.field_1061), (class_2561)class_2561.method_43471((String)"yacl.gui.save_before_exit.tooltip"));
            return false;
        }
        return true;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public static void renderMultilineTooltip(class_332 graphics, class_327 font, class_5489 text, int centerX, int yAbove, int yBelow, int screenWidth, int screenHeight) {
        if (text.method_30887() > 0) {
            int maxWidth = text.method_44048();
            Objects.requireNonNull(font);
            int lineHeight = 9 + 1;
            int height = text.method_30887() * lineHeight - 1;
            int belowY = yBelow + 12;
            int aboveY = yAbove - height + 12;
            int maxBelow = screenHeight - (belowY + height);
            int minAbove = aboveY - height;
            int y = aboveY;
            if (minAbove < 8) {
                y = maxBelow > minAbove ? belowY : aboveY;
            }
            int x = Math.max(centerX - text.method_44048() / 2 - 12, -6);
            int drawX = x + 12;
            int drawY = y - 12;
            graphics.method_51448().method_22903();
            class_8002.method_47946((class_332)graphics, (int)drawX, (int)drawY, (int)maxWidth, (int)height, (int)400);
            graphics.method_51448().method_22904(0.0, 0.0, 400.0);
            text.method_30893(graphics, drawX, drawY, lineHeight, -1);
            graphics.method_51448().method_22909();
        }
    }

    public static class CategoryTab
    implements TabExt {
        private final YACLScreen screen;
        private final ConfigCategory category;
        private final class_7919 tooltip;
        private ListHolderWidget<OptionListWidget> optionList;
        public final class_4185 saveFinishedButton;
        public final class_4185 cancelResetButton;
        public final class_4185 undoButton;
        private final SearchFieldWidget searchField;
        private OptionDescriptionWidget descriptionWidget;
        private final class_8030 rightPaneDim;

        public CategoryTab(YACLScreen screen, ConfigCategory category, class_8030 tabArea) {
            this.screen = screen;
            this.category = category;
            this.tooltip = class_7919.method_47407((class_2561)category.tooltip());
            int columnWidth = screen.field_22789 / 3;
            int padding = columnWidth / 20;
            columnWidth = Math.min(columnWidth, 400);
            int paddedWidth = columnWidth - padding * 2;
            this.rightPaneDim = new class_8030(screen.field_22789 / 3 * 2, tabArea.method_49618() + 1, screen.field_22789 / 3, tabArea.comp_1197());
            MutableDimension<Integer> actionDim = Dimension.ofInt(screen.field_22789 / 3 * 2 + screen.field_22789 / 6, screen.field_22790 - padding - 20, paddedWidth, 20);
            this.saveFinishedButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), btn -> screen.finishOrSave()).method_46433((Integer)actionDim.x() - (Integer)actionDim.width() / 2, ((Integer)actionDim.y()).intValue()).method_46437(((Integer)actionDim.width()).intValue(), ((Integer)actionDim.height()).intValue()).method_46431();
            actionDim.expand(-((Integer)actionDim.width()).intValue() / 2 - 2, 0).move(-((Integer)actionDim.width()).intValue() / 2 - 2, -22);
            this.cancelResetButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), btn -> screen.cancelOrReset()).method_46433((Integer)actionDim.x() - (Integer)actionDim.width() / 2, ((Integer)actionDim.y()).intValue()).method_46437(((Integer)actionDim.width()).intValue(), ((Integer)actionDim.height()).intValue()).method_46431();
            actionDim.move((Integer)actionDim.width() + 4, 0);
            this.undoButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"yacl.gui.undo"), btn -> screen.undo()).method_46433((Integer)actionDim.x() - (Integer)actionDim.width() / 2, ((Integer)actionDim.y()).intValue()).method_46437(((Integer)actionDim.width()).intValue(), ((Integer)actionDim.height()).intValue()).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"yacl.gui.undo.tooltip"))).method_46431();
            this.searchField = new SearchFieldWidget(screen, screen.field_22793, screen.field_22789 / 3 * 2 + screen.field_22789 / 6 - paddedWidth / 2 + 1, this.undoButton.method_46427() - 22, paddedWidth - 2, 18, (class_2561)class_2561.method_43471((String)"gui.recipebook.search_hint"), (class_2561)class_2561.method_43471((String)"gui.recipebook.search_hint"), searchQuery -> this.optionList.getList().updateSearchQuery((String)searchQuery));
            this.optionList = new ListHolderWidget<OptionListWidget>(() -> new class_8030(tabArea.comp_1195(), tabArea.comp_1196() / 3 * 2, tabArea.comp_1197()), new OptionListWidget(screen, category, screen.field_22787, 0, 0, screen.field_22789 / 3 * 2 + 1, screen.field_22790, desc -> this.descriptionWidget.setOptionDescription((DescriptionWithName)desc)));
            this.descriptionWidget = new OptionDescriptionWidget(() -> new class_8030(screen.field_22789 / 3 * 2 + padding, tabArea.method_49618() + padding, paddedWidth, this.searchField.method_46427() - 1 - tabArea.method_49618() - padding * 2), null);
            this.updateButtons();
        }

        public class_2561 method_48610() {
            return this.category.name();
        }

        public void method_48612(Consumer<class_339> consumer) {
            consumer.accept(this.optionList);
            consumer.accept((class_339)this.saveFinishedButton);
            consumer.accept((class_339)this.cancelResetButton);
            consumer.accept((class_339)this.undoButton);
            consumer.accept((class_339)this.searchField);
            consumer.accept(this.descriptionWidget);
        }

        public void method_48611(class_8030 screenRectangle) {
        }

        @Override
        public void method_48613() {
            this.descriptionWidget.tick();
        }

        @Override
        @Nullable
        public class_7919 getTooltip() {
            return this.tooltip;
        }

        public void updateButtons() {
            boolean pendingChanges;
            this.undoButton.field_22763 = pendingChanges = this.screen.pendingChanges();
            this.saveFinishedButton.method_25355((class_2561)(pendingChanges ? class_2561.method_43471((String)"yacl.gui.save") : GuiUtils.translatableFallback("yacl.gui.done", class_5244.field_24334)));
            this.saveFinishedButton.method_47400((class_7919)new YACLTooltip((class_2561)(pendingChanges ? class_2561.method_43471((String)"yacl.gui.save.tooltip") : class_2561.method_43471((String)"yacl.gui.finished.tooltip")), (class_339)this.saveFinishedButton));
            this.cancelResetButton.method_25355((class_2561)(pendingChanges ? GuiUtils.translatableFallback("yacl.gui.cancel", class_5244.field_24335) : class_2561.method_43471((String)"controls.reset")));
            this.cancelResetButton.method_47400((class_7919)new YACLTooltip((class_2561)(pendingChanges ? class_2561.method_43471((String)"yacl.gui.cancel.tooltip") : class_2561.method_43471((String)"yacl.gui.reset.tooltip")), (class_339)this.cancelResetButton));
        }
    }

    public static class PlaceholderTab
    implements TabExt {
        private final YACLScreen screen;
        private final PlaceholderCategory category;
        private final class_7919 tooltip;

        public PlaceholderTab(PlaceholderCategory category, YACLScreen screen) {
            this.screen = screen;
            this.category = category;
            this.tooltip = class_7919.method_47407((class_2561)category.tooltip());
        }

        public class_2561 method_48610() {
            return this.category.name();
        }

        public void method_48612(Consumer<class_339> consumer) {
        }

        public void method_48611(class_8030 screenRectangle) {
            this.screen.field_22787.method_1507(this.category.screen().apply(this.screen.field_22787, this.screen));
        }

        @Override
        @Nullable
        public class_7919 getTooltip() {
            return this.tooltip;
        }
    }
}

