/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.controllers;

import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5489;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jetbrains.annotations.Nullable;

public class LabelController
implements Controller<class_2561> {
    private final Option<class_2561> option;

    public LabelController(Option<class_2561> option) {
        this.option = option;
    }

    @Override
    public Option<class_2561> option() {
        return this.option;
    }

    @Override
    public class_2561 formatValue() {
        return this.option().pendingValue();
    }

    @Override
    public AbstractWidget provideWidget(YACLScreen screen, Dimension<Integer> widgetDimension) {
        return new LabelControllerElement(screen, widgetDimension);
    }

    public class LabelControllerElement
    extends AbstractWidget {
        private List<class_5481> wrappedText;
        protected class_5489 wrappedTooltip;
        protected boolean focused;
        protected final YACLScreen screen;

        public LabelControllerElement(YACLScreen screen, Dimension<Integer> dim) {
            super(dim);
            this.screen = screen;
            LabelController.this.option().addListener((opt, pending) -> this.updateTooltip());
            this.updateTooltip();
            this.updateText();
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            this.updateText();
            int y = this.getDimension().y();
            for (class_5481 text : this.wrappedText) {
                graphics.method_51430(this.textRenderer, text, this.getDimension().x() + this.getXPadding(), y + this.getYPadding(), LabelController.this.option().available() ? -1 : -6250336, true);
                Objects.requireNonNull(this.textRenderer);
                y += 9;
            }
            if (this.method_25370()) {
                graphics.method_25294(this.getDimension().x() - 1, this.getDimension().y() - 1, this.getDimension().xLimit() + 1, this.getDimension().y().intValue(), -1);
                graphics.method_25294(this.getDimension().x() - 1, this.getDimension().y() - 1, this.getDimension().x().intValue(), this.getDimension().yLimit() + 1, -1);
                graphics.method_25294(this.getDimension().x() - 1, this.getDimension().yLimit().intValue(), this.getDimension().xLimit() + 1, this.getDimension().yLimit() + 1, -1);
                graphics.method_25294(this.getDimension().xLimit().intValue(), this.getDimension().y() - 1, this.getDimension().xLimit() + 1, this.getDimension().yLimit() + 1, -1);
            }
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
            if (this.method_25405(mouseX, mouseY)) {
                YACLScreen.renderMultilineTooltip(graphics, this.textRenderer, this.wrappedTooltip, this.getDimension().centerX(), this.getDimension().y() - 5, this.getDimension().yLimit() + 5, this.screen.field_22789, this.screen.field_22790);
                class_2583 style = this.getStyle(mouseX, mouseY);
                if (style != null && style.method_10969() != null) {
                    class_2568 hoverEvent = style.method_10969();
                    class_2568.class_5249 itemStackContent = (class_2568.class_5249)hoverEvent.method_10891(class_2568.class_5247.field_24343);
                    if (itemStackContent != null) {
                        class_1799 stack = itemStackContent.method_27683();
                        graphics.method_51437(this.textRenderer, class_437.method_25408((class_310)this.client, (class_1799)stack), stack.method_32347(), mouseX, mouseY);
                    } else {
                        class_2568.class_5248 entityContent = (class_2568.class_5248)hoverEvent.method_10891(class_2568.class_5247.field_24344);
                        if (entityContent != null) {
                            if (this.client.field_1690.field_1827) {
                                graphics.method_51434(this.textRenderer, entityContent.method_27682(), mouseX, mouseY);
                            }
                        } else {
                            class_2561 text = (class_2561)hoverEvent.method_10891(class_2568.class_5247.field_24342);
                            if (text != null) {
                                class_5489 multilineText = class_5489.method_30890((class_327)this.textRenderer, (class_5348)text, (int)this.getDimension().width());
                                YACLScreen.renderMultilineTooltip(graphics, this.textRenderer, multilineText, this.getDimension().centerX(), this.getDimension().y(), this.getDimension().yLimit(), this.screen.field_22789, this.screen.field_22790);
                            }
                        }
                    }
                }
            }
            graphics.method_51448().method_22909();
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (!this.method_25405(mouseX, mouseY)) {
                return false;
            }
            class_2583 style = this.getStyle((int)mouseX, (int)mouseY);
            return this.screen.method_25430(style);
        }

        protected class_2583 getStyle(int mouseX, int mouseY) {
            if (!this.getDimension().isPointInside(mouseX, mouseY)) {
                return null;
            }
            int x = mouseX - this.getDimension().x();
            int y = mouseY - this.getDimension().y() - this.getYPadding();
            Objects.requireNonNull(this.textRenderer);
            int line = y / 9;
            if (x < 0 || x > this.getDimension().xLimit()) {
                return null;
            }
            if (y < 0 || y > this.getDimension().yLimit()) {
                return null;
            }
            if (line < 0 || line >= this.wrappedText.size()) {
                return null;
            }
            return this.textRenderer.method_27527().method_30876(this.wrappedText.get(line), x);
        }

        private int getXPadding() {
            return 4;
        }

        private int getYPadding() {
            return 3;
        }

        private void updateText() {
            this.wrappedText = this.textRenderer.method_1728((class_5348)LabelController.this.formatValue(), this.getDimension().width() - this.getXPadding() * 2);
            Dimension<Integer> dimension = this.getDimension();
            int n = this.wrappedText.size();
            Objects.requireNonNull(this.textRenderer);
            this.setDimension(dimension.withHeight(n * 9 + this.getYPadding() * 2));
        }

        private void updateTooltip() {
            this.wrappedTooltip = class_5489.method_30890((class_327)this.textRenderer, (class_5348)LabelController.this.option().tooltip(), (int)(this.screen.field_22789 / 3 * 2 - 10));
        }

        @Override
        public boolean matchesSearch(String query) {
            return LabelController.this.formatValue().getString().toLowerCase().contains(query.toLowerCase());
        }

        @Nullable
        public class_8016 method_48205(class_8023 focusNavigationEvent) {
            if (!LabelController.this.option().available()) {
                return null;
            }
            return !this.method_25370() ? class_8016.method_48193((class_364)this) : null;
        }

        public boolean method_25370() {
            return this.focused;
        }

        public void method_25365(boolean focused) {
            this.focused = focused;
        }

        @Override
        public void method_37020(class_6382 builder2) {
            builder2.method_37034(class_6381.field_33788, LabelController.this.formatValue());
        }

        @Override
        public class_6379.class_6380 method_37018() {
            return class_6379.class_6380.field_33786;
        }
    }
}

