/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.content.contraptions.fluids;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import plus.dragons.createenchantmentindustry.foundation.mixin.TankSegmentAccessor;

public class FilteringFluidTankBehaviour
extends SmartFluidTankBehaviour {
    protected final Predicate<FluidVariant> filter;

    public FilteringFluidTankBehaviour(BehaviourType<SmartFluidTankBehaviour> type, Predicate<FluidVariant> filter, SmartBlockEntity be, int tanks, int tankCapacity, boolean enforceVariety) {
        super(type, be, tanks, (long)tankCapacity, enforceVariety);
        this.filter = filter;
        SmartFluidTank[] handlers = new SmartFluidTank[tanks];
        for (int i = 0; i < tanks; ++i) {
            SmartFluidTankBehaviour.TankSegment tankSegment;
            this.tanks[i] = tankSegment = new SmartFluidTankBehaviour.TankSegment((SmartFluidTankBehaviour)this, (long)tankCapacity);
            handlers[i] = ((TankSegmentAccessor)tankSegment).getTank();
        }
        this.capability = new InternalFluidHandler(handlers, enforceVariety);
    }

    public static FilteringFluidTankBehaviour single(Predicate<FluidVariant> filter, SmartBlockEntity be, int capacity) {
        return new FilteringFluidTankBehaviour((BehaviourType<SmartFluidTankBehaviour>)TYPE, filter, be, 1, capacity, false);
    }

    public class InternalFluidHandler
    extends SmartFluidTankBehaviour.InternalFluidHandler {
        public InternalFluidHandler(SmartFluidTank[] handlers, boolean enforceVariety) {
            super((SmartFluidTankBehaviour)FilteringFluidTankBehaviour.this, (Storage[])handlers, enforceVariety);
        }

        public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            if (!FilteringFluidTankBehaviour.this.filter.test(resource)) {
                return 0L;
            }
            return super.insert(resource, maxAmount, transaction);
        }
    }
}

