/*
 * Decompiled with CFR 0.152.
 */
package xyz.nikitacartes.easyauth.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.util.Locale;
import java.util.UUID;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2262;
import net.minecraft.class_2270;
import net.minecraft.class_2960;
import net.minecraft.class_4844;
import xyz.nikitacartes.easyauth.EasyAuth;
import xyz.nikitacartes.easyauth.storage.AuthConfig;
import xyz.nikitacartes.easyauth.storage.PlayerCache;
import xyz.nikitacartes.easyauth.storage.database.DBApiException;
import xyz.nikitacartes.easyauth.utils.AuthHelper;
import xyz.nikitacartes.easyauth.utils.EasyLogger;
import xyz.nikitacartes.easyauth.utils.TranslationHelper;

public class AuthCommand {
    public static void registerCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"auth").requires(Permissions.require((String)"easyauth.commands.auth.root", (int)3))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(Permissions.require((String)"easyauth.commands.auth.reload", (int)3))).executes(ctx -> AuthCommand.reloadConfig(((class_2168)ctx.getSource()).method_9228())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"setGlobalPassword").requires(Permissions.require((String)"easyauth.commands.auth.setGlobalPassword", (int)4))).then(class_2170.method_9244((String)"password", (ArgumentType)StringArgumentType.string()).executes(ctx -> AuthCommand.setGlobalPassword((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"password")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"setSpawn").requires(Permissions.require((String)"easyauth.commands.auth.setSpawn", (int)3))).executes(ctx -> AuthCommand.setSpawn((class_2168)ctx.getSource(), ((class_2168)ctx.getSource()).method_9229().method_5770().method_27983().method_29177(), ((class_2168)ctx.getSource()).method_9229().method_23317(), ((class_2168)ctx.getSource()).method_9229().method_23318(), ((class_2168)ctx.getSource()).method_9229().method_23321(), ((class_2168)ctx.getSource()).method_9229().method_36454(), ((class_2168)ctx.getSource()).method_9229().method_36455()))).then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)"position", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"angle", (ArgumentType)class_2270.method_9717()).executes(ctx -> AuthCommand.setSpawn((class_2168)ctx.getSource(), class_2181.method_9289((CommandContext)ctx, (String)"dimension").method_27983().method_29177(), class_2262.method_9696((CommandContext)ctx, (String)"position").method_10263(), class_2262.method_9696((CommandContext)ctx, (String)"position").method_10264() + 1, class_2262.method_9696((CommandContext)ctx, (String)"position").method_10260(), class_2270.method_9716((CommandContext)ctx, (String)"angle").method_9709((class_2168)((class_2168)ctx.getSource())).field_1342, class_2270.method_9716((CommandContext)ctx, (String)"angle").method_9709((class_2168)((class_2168)ctx.getSource())).field_1343))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(Permissions.require((String)"easyauth.commands.auth.remove", (int)3))).then(class_2170.method_9244((String)"uuid", (ArgumentType)StringArgumentType.word()).executes(ctx -> AuthCommand.removeAccount((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"uuid")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"register").requires(Permissions.require((String)"easyauth.commands.auth.register", (int)3))).then(class_2170.method_9244((String)"uuid", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"password", (ArgumentType)StringArgumentType.string()).executes(ctx -> AuthCommand.registerUser((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"uuid"), StringArgumentType.getString((CommandContext)ctx, (String)"password"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"update").requires(Permissions.require((String)"easyauth.commands.auth.update", (int)3))).then(class_2170.method_9244((String)"uuid", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"password", (ArgumentType)StringArgumentType.string()).executes(ctx -> AuthCommand.updatePassword((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"uuid"), StringArgumentType.getString((CommandContext)ctx, (String)"password"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"uuid").requires(Permissions.require((String)"easyauth.commands.auth.uuid", (int)3))).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> AuthCommand.getOfflineUuid((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(Permissions.require((String)"easyauth.commands.auth.list", (int)3))).executes(ctx -> AuthCommand.getRegisteredPlayers((class_2168)ctx.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"addToForcedOffline").requires(Permissions.require((String)"easyauth.commands.auth.addToForcedOffline", (int)3))).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> AuthCommand.addPlayerToForcedOffline((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player"))))));
    }

    public static int reloadConfig(class_1297 sender) {
        EasyAuth.config = AuthConfig.load(new File("./mods/EasyAuth/config.json"));
        try {
            EasyAuth.DB.connect();
        }
        catch (DBApiException e) {
            EasyLogger.LogError("onInitialize error: ", e);
        }
        if (sender != null) {
            ((class_1657)sender).method_7353(TranslationHelper.getConfigurationReloaded(), false);
        } else {
            EasyLogger.LogInfo(EasyAuth.config.lang.configurationReloaded);
        }
        return 1;
    }

    private static int setGlobalPassword(class_2168 source, String password) {
        class_1297 sender = source.method_9228();
        EasyAuth.THREADPOOL.submit(() -> {
            EasyAuth.config.main.globalPassword = AuthHelper.hashPassword(password.toCharArray());
            EasyAuth.config.main.enableGlobalPassword = true;
            EasyAuth.config.save(new File("./mods/EasyAuth/config.json"));
        });
        if (sender != null) {
            ((class_1657)sender).method_7353(TranslationHelper.getGlobalPasswordSet(), false);
        } else {
            EasyLogger.LogInfo(EasyAuth.config.lang.globalPasswordSet);
        }
        return 1;
    }

    private static int setSpawn(class_2168 source, class_2960 world, double x, double y, double z, float yaw, float pitch) {
        EasyAuth.THREADPOOL.submit(() -> {
            EasyAuth.config.worldSpawn.dimension = String.valueOf(world);
            EasyAuth.config.worldSpawn.x = x;
            EasyAuth.config.worldSpawn.y = y;
            EasyAuth.config.worldSpawn.z = z;
            EasyAuth.config.worldSpawn.yaw = yaw;
            EasyAuth.config.worldSpawn.pitch = pitch;
            EasyAuth.config.main.spawnOnJoin = true;
            EasyAuth.config.save(new File("./mods/EasyAuth/config.json"));
        });
        class_1297 sender = source.method_9228();
        if (sender != null) {
            ((class_1657)sender).method_7353(TranslationHelper.getWorldSpawnSet(), false);
        } else {
            EasyLogger.LogInfo(EasyAuth.config.lang.worldSpawnSet);
        }
        return 1;
    }

    private static int removeAccount(class_2168 source, String uuid) {
        class_1297 sender = source.method_9228();
        EasyAuth.THREADPOOL.submit(() -> {
            EasyAuth.DB.deleteUserData(uuid);
            EasyAuth.playerCacheMap.remove(uuid);
        });
        if (sender != null) {
            ((class_1657)sender).method_7353(TranslationHelper.getUserdataDeleted(), false);
        } else {
            EasyLogger.LogInfo(EasyAuth.config.lang.userdataDeleted);
        }
        return 1;
    }

    private static int registerUser(class_2168 source, String uuid, String password) {
        class_1297 sender = source.method_9228();
        EasyAuth.THREADPOOL.submit(() -> {
            PlayerCache playerCache = EasyAuth.playerCacheMap.containsKey(uuid) ? EasyAuth.playerCacheMap.get(uuid) : PlayerCache.fromJson(null, uuid);
            EasyAuth.playerCacheMap.put(uuid, playerCache);
            EasyAuth.playerCacheMap.get((Object)uuid).password = AuthHelper.hashPassword(password.toCharArray());
            if (sender != null) {
                ((class_1657)sender).method_7353(TranslationHelper.getUserdataUpdated(), false);
            } else {
                EasyLogger.LogInfo(EasyAuth.config.lang.userdataUpdated);
            }
        });
        return 0;
    }

    private static int updatePassword(class_2168 source, String uuid, String password) {
        class_1297 sender = source.method_9228();
        EasyAuth.THREADPOOL.submit(() -> {
            PlayerCache playerCache = EasyAuth.playerCacheMap.containsKey(uuid) ? EasyAuth.playerCacheMap.get(uuid) : PlayerCache.fromJson(null, uuid);
            EasyAuth.playerCacheMap.put(uuid, playerCache);
            if (EasyAuth.playerCacheMap.get((Object)uuid).password.isEmpty()) {
                if (sender != null) {
                    ((class_1657)sender).method_7353(TranslationHelper.getUserNotRegistered(), false);
                } else {
                    EasyLogger.LogInfo(EasyAuth.config.lang.userNotRegistered);
                }
                return;
            }
            EasyAuth.playerCacheMap.get((Object)uuid).password = AuthHelper.hashPassword(password.toCharArray());
            if (sender != null) {
                ((class_1657)sender).method_7353(TranslationHelper.getUserdataUpdated(), false);
            } else {
                EasyLogger.LogInfo(EasyAuth.config.lang.userdataUpdated);
            }
        });
        return 0;
    }

    private static int getOfflineUuid(class_2168 source, String player) {
        class_1297 sender = source.method_9228();
        UUID uuid = class_4844.method_43344((String)player.toLowerCase(Locale.ROOT));
        if (sender != null) {
            ((class_1657)sender).method_7353(TranslationHelper.getOfflineUuid(player, uuid), false);
        } else {
            EasyLogger.LogInfo(String.format(EasyAuth.config.lang.offlineUuid, player, uuid));
        }
        return 1;
    }

    public static int getRegisteredPlayers(class_2168 source) {
        class_1297 sender = source.method_9228();
        EasyAuth.THREADPOOL.submit(() -> {
            if (sender != null) {
                ((class_1657)sender).method_7353(TranslationHelper.getRegisteredPlayers(false), false);
            } else {
                EasyLogger.LogInfo(TranslationHelper.getRegisteredPlayers(true).method_10851().toString());
            }
        });
        return 1;
    }

    private static int addPlayerToForcedOffline(class_2168 source, String player) {
        class_1297 sender = source.method_9228();
        EasyAuth.THREADPOOL.submit(() -> {
            EasyAuth.config.main.forcedOfflinePlayers.add(player.toLowerCase(Locale.ROOT));
            EasyAuth.config.experimental.verifiedOnlinePlayer.remove(player.toLowerCase(Locale.ROOT));
            EasyAuth.config.save(new File("./mods/EasyAuth/config.json"));
        });
        if (sender != null) {
            ((class_1657)sender).method_7353(TranslationHelper.getAddToForcedOffline(), false);
        } else {
            EasyLogger.LogInfo(EasyAuth.config.lang.addToForcedOffline);
        }
        return 1;
    }
}

