/*
 * Decompiled with CFR 0.152.
 */
package xyz.nikitacartes.easyauth.mixin;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.net.SocketAddress;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3442;
import net.minecraft.class_4844;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import xyz.nikitacartes.easyauth.EasyAuth;
import xyz.nikitacartes.easyauth.event.AuthEventHandler;
import xyz.nikitacartes.easyauth.mixin.accessor.ServerStatHandlerAccessor;
import xyz.nikitacartes.easyauth.utils.PlayerAuth;

@Mixin(value={class_3324.class})
public abstract class PlayerManagerMixin {
    @Final
    @Shadow
    private MinecraftServer field_14360;

    @Inject(method={"onPlayerConnect(Lnet/minecraft/network/ClientConnection;Lnet/minecraft/server/network/ServerPlayerEntity;)V"}, at={@At(value="RETURN")})
    private void onPlayerConnect(class_2535 clientConnection, class_3222 serverPlayerEntity, CallbackInfo ci) {
        AuthEventHandler.onPlayerJoin(serverPlayerEntity);
    }

    @Inject(method={"remove(Lnet/minecraft/server/network/ServerPlayerEntity;)V"}, at={@At(value="HEAD")})
    private void onPlayerLeave(class_3222 serverPlayerEntity, CallbackInfo ci) {
        AuthEventHandler.onPlayerLeave(serverPlayerEntity);
    }

    @Inject(method={"checkCanJoin(Ljava/net/SocketAddress;Lcom/mojang/authlib/GameProfile;)Lnet/minecraft/text/Text;"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkCanJoin(SocketAddress socketAddress, GameProfile profile, CallbackInfoReturnable<class_2561> cir) {
        class_3324 manager = (class_3324)this;
        class_2561 returnText = AuthEventHandler.checkCanPlayerJoinServer(profile, manager);
        if (returnText != null) {
            cir.setReturnValue((Object)returnText);
        }
    }

    @Inject(method={"createStatHandler(Lnet/minecraft/entity/player/PlayerEntity;)Lnet/minecraft/stat/ServerStatHandler;"}, at={@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void migrateOfflineStats(class_1657 player, CallbackInfoReturnable<class_3442> cir, UUID uUID, class_3442 serverStatHandler, File serverStatsDir, File playerStatFile) {
        File onlineFile = new File(serverStatsDir, uUID + ".json");
        if (this.field_14360.method_3828() && !EasyAuth.config.experimental.forcedOfflineUuids && ((PlayerAuth)player).isUsingMojangAccount() && !onlineFile.exists()) {
            String playername = player.method_7334().getName();
            File offlineFile = new File(onlineFile.getParent(), class_4844.method_43344((String)playername) + ".json");
            offlineFile.renameTo(onlineFile);
            ((ServerStatHandlerAccessor)serverStatHandler).setFile(onlineFile);
        }
    }
}

