/*
 * Decompiled with CFR 0.152.
 */
package xyz.nikitacartes.easyauth.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.regex.Pattern;
import net.fabricmc.loader.api.FabricLoader;
import xyz.nikitacartes.easyauth.EasyAuth;
import xyz.nikitacartes.easyauth.event.AuthEventHandler;
import xyz.nikitacartes.easyauth.storage.database.LevelDB;
import xyz.nikitacartes.easyauth.storage.database.MongoDB;
import xyz.nikitacartes.easyauth.storage.database.MySQL;
import xyz.nikitacartes.easyauth.utils.EasyLogger;

public class AuthConfig {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    public MainConfig main = new MainConfig();
    public MainConfig.WorldSpawn worldSpawn = new MainConfig.WorldSpawn();
    public LangConfig lang = new LangConfig();
    public ExperimentalConfig experimental = new ExperimentalConfig();

    public static AuthConfig load(File file) {
        AuthConfig config;
        block14: {
            if (file.exists()) {
                try (BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                    config = (AuthConfig)gson.fromJson((Reader)fileReader, AuthConfig.class);
                    if (!Boolean.parseBoolean(EasyAuth.serverProp.getProperty("online-mode"))) {
                        if (config.experimental.forcedOfflineUuids) {
                            EasyLogger.LogInfo("Server is in offline mode, forcedOfflineUuids option is irrelevant. Setting it to false.");
                            config.experimental.forcedOfflineUuids = false;
                        }
                        if (config.main.premiumAutologin) {
                            EasyLogger.LogInfo("You have premiumAutologin enabled. Enable online-mode so that online player can not register.");
                        }
                    }
                    if (config.experimental.enableServerSideTranslation && !FabricLoader.getInstance().isModLoaded("server_translations_api")) {
                        config.experimental.enableServerSideTranslation = false;
                    }
                    AuthEventHandler.usernamePattern = Pattern.compile(config.main.usernameRegex);
                    break block14;
                }
                catch (IOException e) {
                    throw new RuntimeException("[EasyAuth] Problem occurred when trying to load config: ", e);
                }
            }
            config = new AuthConfig();
        }
        if (FabricLoader.getInstance().isModLoaded("floodgate")) {
            config.experimental.floodgateLoaded = true;
        }
        config.save(file);
        if (EasyAuth.DB != null && !EasyAuth.DB.isClosed()) {
            EasyAuth.DB.close();
        }
        EasyAuth.DB = config.main.databaseType.equalsIgnoreCase("mysql") ? new MySQL(config) : (config.main.databaseType.equalsIgnoreCase("mongodb") ? new MongoDB(config) : new LevelDB(config));
        return config;
    }

    public void save(File file) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            EasyLogger.LogError("Problem occurred when saving config", e);
        }
    }

    public static class MainConfig {
        public boolean allowEntityInteract = false;
        public int maxLoginTries = 1;
        public int kickTime = 60;
        public boolean enableGlobalPassword = false;
        public String globalPassword;
        public boolean tryPortalRescue = true;
        public int minPasswordChars = 4;
        public int maxPasswordChars = -1;
        public String usernameRegex = "^[a-zA-Z0-9_]{3,16}$";
        public int sessionTimeoutTime = 3600;
        public boolean spawnOnJoin = false;
        public String databaseType = "";
        public String MySQLHost = "localhost";
        public String MySQLUser = "root";
        public String MySQLPassword = "";
        public String MySQLDatabase = "easyauth";
        public String MySQLTableName = "easyauth";
        public String MongoDBConnectionString = "mongodb://username:password@host:port/?options";
        public String MongoDBDatabase = "easyauth";
        public boolean premiumAutologin = true;
        public boolean floodgateAutologin = false;
        public ArrayList<String> forcedOfflinePlayers = new ArrayList();
        public boolean hideUnauthenticatedPLayersFromPlayerList = false;

        public static class WorldSpawn {
            public String dimension = "minecraft:overworld";
            public double x = 0.0;
            public double y = 64.0;
            public double z = 0.0;
            public float yaw;
            public float pitch;
        }
    }

    public static class LangConfig {
        public String enterPassword = "\u00a76You need to enter your password!";
        public String enterNewPassword = "\u00a74You need to enter new password!";
        public String wrongPassword = "\u00a74Wrong password!";
        public String matchPassword = "\u00a76Passwords must match!";
        public String passwordUpdated = "\u00a7aYour password was updated successfully!";
        public String loginRequired = "\u00a7cYou are not authenticated!\n\u00a76Use /login, /l to authenticate!";
        public String loginTriesExceeded = "\u00a74Too many login tries. Please wait a few minutes and try again.";
        public String globalPasswordSet = "\u00a7aGlobal password was successfully set!";
        public String cannotChangePassword = "\u00a7cYou cannot change password!";
        public String cannotUnregister = "\u00a7cYou cannot unregister this account!";
        public String notAuthenticated = "\u00a7cYou are not authenticated!\n\u00a76Try with /login, /l or /register.";
        public String alreadyAuthenticated = "\u00a76You are already authenticated.";
        public String successfullyAuthenticated = "\u00a7aYou are now authenticated.";
        public String successfulLogout = "\u00a7aLogged out successfully.";
        public String timeExpired = "\u00a7cTime for authentication has expired.";
        public String registerRequired = "\u00a76Type /register <password> <password> to claim this account.";
        public String alreadyRegistered = "\u00a76This account name is already registered!";
        public String registerSuccess = "\u00a7aYou are now authenticated.";
        public String userdataDeleted = "\u00a7aUserdata deleted.";
        public String userdataUpdated = "\u00a7aUserdata updated.";
        public String accountDeleted = "\u00a7aYour account was successfully deleted!";
        public String configurationReloaded = "\u00a7aConfiguration file was reloaded successfully.";
        public String maxPasswordChars = "\u00a76Password can be at most %d characters long!";
        public String minPasswordChars = "\u00a76Password needs to be at least %d characters long!";
        public String disallowedUsername = "\u00a76Invalid username characters! Allowed character regex: %s";
        public String playerAlreadyOnline = "\u00a7cPlayer %s is already online!";
        public String worldSpawnSet = "\u00a7aSpawn for logging in was set successfully.";
        public String corruptedPlayerData = "\u00a7cYour data is probably corrupted. Please contact admin.";
        public String userNotRegistered = "\u00a7cThis player is not registered!";
        public String cannotLogout = "\u00a7cYou cannot logout!";
        public String offlineUuid = "Offline UUID for %s is %s";
        public String registeredPlayers = "List of registered players:";
        public String addToForcedOffline = "Player successfully added into forcedOfflinePlayers list";
    }

    public static class ExperimentalConfig {
        public boolean preventAnotherLocationKick = true;
        public boolean playerInvulnerable = true;
        public boolean playerInvisible = true;
        public boolean allowChat = false;
        public boolean allowCommands = false;
        public ArrayList<String> allowedCommands = new ArrayList();
        public boolean allowMovement = false;
        public boolean allowBlockUse = false;
        public boolean allowBlockPunch = false;
        public boolean allowItemDrop = false;
        public boolean allowItemMoving = false;
        public boolean allowItemUse = false;
        public boolean allowEntityPunch = false;
        public boolean debugMode = false;
        public boolean useBCryptLibrary = false;
        public boolean forcedOfflineUuids = false;
        public boolean useSimpleAuthDatabase = false;
        public long teleportationTimeoutInMs = 5L;
        public boolean enableAliases = true;
        public boolean enableServerSideTranslation = true;
        public long resetLoginAttemptsTime = 120L;
        public boolean floodgateLoaded = false;
        public boolean floodgateBypassUsernameRegex = false;
        public ArrayList<String> verifiedOnlinePlayer = new ArrayList();
        public boolean skipAllAuthChecks = false;
    }
}

