/*
 * Decompiled with CFR 0.152.
 */
package xyz.nikitacartes.easyauth.utils;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Strings;
import xyz.nikitacartes.easyauth.EasyAuth;

public class EasyLogger {
    private static final Logger logger = LogManager.getLogger((String)"EasyAuth");

    static void log(Level level, String message) {
        logger.atLevel(level).log(Strings.concat((String)"[EasyAuth]: ", (String)message));
    }

    static void log(Level level, String message, Throwable e) {
        logger.atLevel(level).log("[EasyAuth]: " + message + "\n" + ExceptionUtils.getStackTrace((Throwable)e));
    }

    public static void LogInfo(String message) {
        EasyLogger.log(Level.INFO, message);
    }

    public static void LogInfo(String message, Throwable e) {
        EasyLogger.log(Level.INFO, message, e);
    }

    public static void LogWarn(String message) {
        EasyLogger.log(Level.WARN, message);
    }

    public static void LogWarn(String message, Throwable e) {
        EasyLogger.log(Level.WARN, message, e);
    }

    public static void LogDebug(String message) {
        if (EasyAuth.config != null && EasyAuth.config.experimental.debugMode) {
            EasyLogger.log(Level.INFO, "[DEBUG]: " + message);
        }
    }

    public static void LogDebug(String message, Throwable e) {
        if (EasyAuth.config != null && EasyAuth.config.experimental.debugMode) {
            EasyLogger.log(Level.INFO, "[DEBUG]: " + message, e);
        }
    }

    public static void LogError(String message) {
        EasyLogger.log(Level.ERROR, message);
    }

    public static void LogError(String message, Throwable e) {
        EasyLogger.log(Level.ERROR, message, e);
    }
}

