/*
 * Decompiled with CFR 0.152.
 */
package xyz.nikitacartes.easyauth.utils.hashing;

import at.favre.lib.crypto.bcrypt.BCrypt;
import xyz.nikitacartes.easyauth.utils.EasyLogger;

public class HasherBCrypt {
    public static boolean verify(char[] password, String hashed) {
        try {
            return BCrypt.verifyer().verify((char[])password, (CharSequence)hashed).verified;
        }
        catch (Error e) {
            EasyLogger.LogError("password verification error", e);
            return false;
        }
    }

    public static String hash(char[] password) {
        try {
            return BCrypt.withDefaults().hashToString(12, password);
        }
        catch (Error e) {
            EasyLogger.LogError("password hashing error", e);
            return null;
        }
    }
}

