/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.inventorymanagement.roundalib.client.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import me.roundaround.inventorymanagement.roundalib.client.gui.GuiUtil;
import me.roundaround.inventorymanagement.roundalib.client.gui.widget.config.ConfigListWidget;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8027;
import net.minecraft.class_8028;
import net.minecraft.class_8030;
import org.joml.Matrix4f;

public abstract class VariableHeightListWidget<E extends Entry<E>>
extends class_362
implements class_4068,
class_6379 {
    protected final class_310 client;
    protected final PositionalLinkedList<E> entries;
    protected final int contentPadding;
    protected final int rowPadding;
    protected int left;
    protected int top;
    protected int right;
    protected int bottom;
    protected int width;
    protected int height;
    protected E hoveredEntry;
    protected double scrollUnit;
    protected boolean autoCalculateScrollUnit = true;
    private double scrollAmount;
    private boolean scrolling;

    public VariableHeightListWidget(class_310 client, int left, int top, int width, int height) {
        this(client, left, top, width, height, GuiUtil.PADDING, GuiUtil.PADDING);
    }

    public VariableHeightListWidget(class_310 client, int left, int top, int width, int height, int contentPadding, int rowPadding) {
        this.client = client;
        this.left = left;
        this.right = left + width;
        this.top = top;
        this.bottom = top + height;
        this.width = width;
        this.height = height;
        this.contentPadding = contentPadding;
        this.rowPadding = rowPadding;
        this.entries = new PositionalLinkedList(this.rowPadding);
    }

    public <T extends E> T addEntry(T entry) {
        this.entries.add(entry);
        return entry;
    }

    public void clearEntries() {
        this.entries.clear();
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        this.hoveredEntry = this.method_25405(mouseX, mouseY) ? this.getEntryAtPosition(mouseX, mouseY) : null;
        this.renderBackground(drawContext, delta);
        drawContext.method_44379(this.left, this.top, this.right, this.bottom);
        this.renderList(drawContext, mouseX, mouseY, delta);
        this.renderScrollBar(drawContext, mouseX, mouseY, delta);
        drawContext.method_44380();
    }

    protected void renderList(class_332 drawContext, int mouseX, int mouseY, float delta) {
        for (int i = 0; i < this.entries.size(); ++i) {
            this.renderEntry(drawContext, i, mouseX, mouseY, delta);
        }
    }

    protected void renderEntry(class_332 drawContext, int index, int mouseX, int mouseY, float delta) {
        E entry = this.entries.get(index);
        double scrollAmount = this.getScrollAmount();
        double scrolledTop = (double)((Entry)((Object)entry)).getTop() - scrollAmount;
        double scrolledBottom = (double)(((Entry)((Object)entry)).getTop() + ((Entry)((Object)entry)).getHeight()) - scrollAmount;
        if (scrolledBottom < (double)this.top || scrolledTop > (double)this.bottom) {
            return;
        }
        ((Entry)((Object)entry)).render(drawContext, index, scrollAmount, mouseX, mouseY, delta);
    }

    protected void renderScrollBar(class_332 drawContext, int mouseX, int mouseY, float delta) {
        int maxScroll = this.getMaxScroll();
        if (maxScroll <= 0) {
            return;
        }
        int scrollbarLeft = this.getScrollbarPositionX();
        int scrollbarRight = scrollbarLeft + GuiUtil.SCROLLBAR_WIDTH;
        RenderSystem.setShader(class_757::method_34540);
        int handleHeight = (int)((float)this.height * (float)this.height / (float)this.getContentHeight());
        handleHeight = class_3532.method_15340((int)handleHeight, (int)32, (int)(this.height - 8));
        int handleTop = (int)this.scrollAmount * (this.height - handleHeight) / maxScroll + this.top;
        if (handleTop < this.top) {
            handleTop = this.top;
        }
        drawContext.method_25294(scrollbarLeft, this.top, scrollbarRight, this.bottom, GuiUtil.genColorInt(0.0f, 0.0f, 0.0f));
        drawContext.method_25294(scrollbarLeft, handleTop, scrollbarRight, handleTop + handleHeight, GuiUtil.genColorInt(0.5f, 0.5f, 0.5f));
        drawContext.method_25294(scrollbarLeft, handleTop, scrollbarRight - 1, handleTop + handleHeight - 2, GuiUtil.genColorInt(0.75f, 0.75f, 0.75f));
    }

    protected void renderBackground(class_332 drawContext, float delta) {
        class_437 parent = this.client.field_1755;
        int screenWidth = parent != null ? parent.field_22789 : this.width;
        GuiUtil.renderBackgroundInRegion(32, this.top, this.bottom, 0, screenWidth, 0.0, (int)this.scrollAmount);
        this.renderHorizontalShadows(drawContext, delta);
    }

    protected void renderHorizontalShadows(class_332 drawContext, float delta) {
        class_437 parent = this.client.field_1755;
        int screenWidth = parent != null ? parent.field_22789 : this.width;
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ZERO, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22912(0.0, (double)(this.top + this.contentPadding), 0.0).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22912((double)screenWidth, (double)(this.top + this.contentPadding), 0.0).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22912((double)screenWidth, (double)this.top, 0.0).method_1336(0, 0, 0, 255).method_1344();
        bufferBuilder.method_22912(0.0, (double)this.top, 0.0).method_1336(0, 0, 0, 255).method_1344();
        bufferBuilder.method_22912(0.0, (double)this.bottom, 0.0).method_1336(0, 0, 0, 255).method_1344();
        bufferBuilder.method_22912((double)screenWidth, (double)this.bottom, 0.0).method_1336(0, 0, 0, 255).method_1344();
        bufferBuilder.method_22912((double)screenWidth, (double)(this.bottom - this.contentPadding), 0.0).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22912(0.0, (double)(this.bottom - this.contentPadding), 0.0).method_1336(0, 0, 0, 0).method_1344();
        tessellator.method_1350();
        RenderSystem.disableBlend();
    }

    public class_8030 method_48202() {
        return new class_8030(this.left, this.top, this.width, this.height);
    }

    public E getFocused() {
        return (E)((Object)((Entry)super.method_25399()));
    }

    public void method_25395(class_364 focused) {
        super.method_25395(focused);
        E entry = this.getFocused();
        if (entry == null) {
            return;
        }
        if (this.client.method_48186().method_48183()) {
            this.ensureVisible(entry);
        }
    }

    public class_8016 method_48205(class_8023 navigation) {
        class_8016 path;
        if (this.entries.isEmpty()) {
            return null;
        }
        if (!(navigation instanceof class_8023.class_8024)) {
            return super.method_48205(navigation);
        }
        class_8023.class_8024 arrow = (class_8023.class_8024)navigation;
        Object entry = this.getFocused();
        if (arrow.comp_1191().method_48237() == class_8027.field_41822 && entry != null) {
            return class_8016.method_48192((class_4069)this, (class_8016)((Entry)((Object)entry)).method_48205(navigation));
        }
        int index = -1;
        class_8028 direction = arrow.comp_1191();
        if (entry != null) {
            index = entry.method_25396().indexOf(((Entry)((Object)entry)).method_25399());
        }
        if (index == -1) {
            switch (direction) {
                case field_41828: {
                    index = Integer.MAX_VALUE;
                    direction = class_8028.field_41827;
                    break;
                }
                case field_41829: {
                    index = 0;
                    direction = class_8028.field_41827;
                    break;
                }
                default: {
                    index = 0;
                }
            }
        }
        do {
            if ((entry = this.getNeighboringEntry(direction, element -> !element.method_25396().isEmpty())) != null) continue;
            return null;
        } while ((path = ((Entry)((Object)entry)).getNavigationPath((class_8023)arrow, index)) == null);
        return class_8016.method_48192((class_4069)this, (class_8016)path);
    }

    protected E getNeighboringEntry(class_8028 direction) {
        return (E)((Object)this.getNeighboringEntry(direction, entry -> true));
    }

    protected E getNeighboringEntry(class_8028 direction, Predicate<E> predicate) {
        return this.getNeighboringEntry(direction, predicate, this.getFocused());
    }

    protected E getNeighboringEntry(class_8028 direction, Predicate<E> predicate, E focused) {
        int delta;
        if (this.entries.isEmpty()) {
            return null;
        }
        switch (direction) {
            case field_41826: {
                int n = -1;
                break;
            }
            case field_41827: {
                int n = 1;
                break;
            }
            default: {
                int n = delta = 0;
            }
        }
        if (delta == 0) {
            return null;
        }
        int index = focused == null ? (delta > 0 ? 0 : this.entries.size() - 1) : this.entries.indexOf(focused) + delta;
        for (int i = index; i >= 0 && i < this.entries.size(); i += delta) {
            E entry = this.entries.get(i);
            if (!predicate.test(entry)) continue;
            return entry;
        }
        return null;
    }

    public List<? extends class_364> method_25396() {
        return this.entries.asList();
    }

    public class_6379.class_6380 method_37018() {
        if (this.method_25370()) {
            return class_6379.class_6380.field_33786;
        }
        return this.hoveredEntry != null ? class_6379.class_6380.field_33785 : class_6379.class_6380.field_33784;
    }

    protected E getHoveredEntry() {
        return this.hoveredEntry;
    }

    protected void appendNarrations(class_6382 builder, E entry) {
        int i;
        List<E> list = this.entries.asList();
        if (list.size() > 1 && (i = list.indexOf(entry)) != -1) {
            builder.method_37034(class_6381.field_33789, (class_2561)class_2561.method_43469((String)"narrator.position.list", (Object[])new Object[]{i + 1, list.size()}));
        }
    }

    public void method_37020(class_6382 builder) {
        E hovered = this.getHoveredEntry();
        if (hovered != null) {
            ((Entry)((Object)hovered)).appendNarrations(builder.method_37031());
            this.appendNarrations(builder, hovered);
        } else {
            E focused = this.getFocused();
            if (focused != null) {
                ((Entry)((Object)focused)).appendNarrations(builder.method_37031());
                this.appendNarrations(builder, focused);
            }
        }
        builder.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.component_list.usage"));
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)this.left && mouseX <= (double)this.right && mouseY >= (double)this.top && mouseY <= (double)this.bottom;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.updateScrollingState(mouseX, mouseY, button);
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        E entry = this.getEntryAtPosition(mouseX, mouseY);
        if (entry != null && entry.method_25402(mouseX, mouseY, button)) {
            E focused = this.getFocused();
            if (focused != entry && focused != null) {
                ((Entry)((Object)focused)).method_25395(null);
            }
            this.method_25395((class_364)entry);
            this.method_25398(true);
            return true;
        }
        return this.scrolling;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.getFocused() != null) {
            this.getFocused().method_25406(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.top) {
                this.setScrollAmount(0.0);
            } else if (mouseY > (double)this.bottom) {
                this.setScrollAmount(this.getMaxScroll());
            } else {
                double d = Math.max(1, this.getMaxScroll());
                int i = this.height;
                int j = class_3532.method_15340((int)((int)((float)(i * i) / (float)this.entries.totalHeight)), (int)32, (int)(i - 8));
                double e = Math.max(1.0, d / (double)(i - j));
                this.setScrollAmount(this.getScrollAmount() + deltaY * e);
            }
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        this.setScrollAmount(this.getScrollAmount() - amount * this.getScrollUnit());
        return true;
    }

    protected E getEntryAtPosition(double x, double y) {
        if (x < (double)this.getContentLeft() || x > (double)this.getContentRight()) {
            return null;
        }
        if (y < (double)this.top || y > (double)this.bottom) {
            return null;
        }
        return this.entries.getEntryAtPosition(y + this.scrollAmount);
    }

    protected void ensureVisible(E entry) {
        int scrolledTop = ((Entry)((Object)entry)).getTop() - (int)this.scrollAmount;
        if (scrolledTop < this.top + this.contentPadding) {
            this.scroll(scrolledTop - this.top - this.contentPadding);
            return;
        }
        int scrolledBottom = ((Entry)((Object)entry)).getTop() + ((Entry)((Object)entry)).getHeight() - (int)this.scrollAmount;
        if (scrolledBottom > this.bottom - this.contentPadding) {
            this.scroll(scrolledBottom - this.bottom + this.contentPadding);
        }
    }

    protected int getContentHeight() {
        return this.entries.totalHeight + this.contentPadding * 2;
    }

    protected int getContentWidth() {
        return this.width - (GuiUtil.SCROLLBAR_WIDTH + this.contentPadding) * 2;
    }

    protected int getContentLeft() {
        return this.left + GuiUtil.SCROLLBAR_WIDTH + this.contentPadding;
    }

    protected int getContentRight() {
        return this.right - GuiUtil.SCROLLBAR_WIDTH - this.contentPadding;
    }

    protected int getScrollbarPositionX() {
        return this.right - GuiUtil.SCROLLBAR_WIDTH;
    }

    private void scroll(int amount) {
        this.setScrollAmount(this.getScrollAmount() + (double)amount);
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(double amount) {
        this.scrollAmount = class_3532.method_15350((double)amount, (double)0.0, (double)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getContentHeight() - this.height);
    }

    protected void updateScrollingState(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && mouseX >= (double)this.getScrollbarPositionX() && mouseX < (double)(this.getScrollbarPositionX() + GuiUtil.SCROLLBAR_WIDTH);
    }

    protected double getScrollUnit() {
        return this.autoCalculateScrollUnit ? this.entries.averageItemHeight / 2.0 : this.scrollUnit;
    }

    public int nextTop() {
        return this.top + this.contentPadding + this.entries.nextTop();
    }

    protected static class PositionalLinkedList<E extends Entry<E>>
    implements Iterable<E> {
        private final LinkedList<E> entries = new LinkedList();
        private final int rowPadding;
        private int totalHeight;
        private double averageItemHeight;

        protected PositionalLinkedList(int rowPadding) {
            this.rowPadding = rowPadding;
        }

        public List<E> asList() {
            return List.copyOf(this.entries);
        }

        public void add(E entry) {
            boolean first = this.entries.isEmpty();
            this.entries.add(entry);
            this.totalHeight += ((Entry)((Object)entry)).getHeight() + (first ? 0 : this.rowPadding);
            this.averageItemHeight = (double)this.totalHeight / (double)this.entries.size();
        }

        public E get(int index) {
            return (E)((Object)((Entry)((Object)this.entries.get(index))));
        }

        public int size() {
            return this.entries.size();
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        public void clear() {
            this.entries.clear();
            this.totalHeight = 0;
            this.averageItemHeight = 0.0;
        }

        public int nextTop() {
            if (this.entries.isEmpty()) {
                return 0;
            }
            return this.totalHeight + this.rowPadding;
        }

        public E getEntryAtPosition(double y) {
            for (Entry entry : this.entries) {
                if (!(y >= (double)entry.getTop()) || !(y <= (double)entry.getBottom())) continue;
                return (E)((Object)entry);
            }
            return null;
        }

        public int indexOf(E entry) {
            return this.entries.indexOf(entry);
        }

        @Override
        public Iterator<E> iterator() {
            return this.entries.iterator();
        }
    }

    public static abstract class Entry<E extends Entry<E>>
    extends class_362 {
        protected static final int ROW_SHADE_STRENGTH = 85;
        protected static final int ROW_SHADE_FADE_WIDTH = 10;
        protected static final int ROW_SHADE_FADE_OVERFLOW = 10;
        protected final class_310 client;
        protected final VariableHeightListWidget<E> parent;
        private final int left;
        private final int top;
        private final int width;
        private final int height;
        private class_364 focused;
        private class_6379 focusedSelectable;

        public Entry(class_310 client, VariableHeightListWidget<E> parent, int height) {
            this.client = client;
            this.parent = parent;
            this.left = parent.getContentLeft();
            this.width = parent.getContentWidth();
            this.top = parent.nextTop();
            this.height = height;
        }

        public ConfigListWidget getParent() {
            return (ConfigListWidget)this.parent;
        }

        public class_310 getClient() {
            return this.client;
        }

        public class_327 getTextRenderer() {
            return this.client.field_1772;
        }

        public int getTop() {
            return this.top;
        }

        public int getBottom() {
            return this.top + this.height;
        }

        public int getLeft() {
            return this.left;
        }

        public int getRight() {
            return this.left + this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public void render(class_332 drawContext, int index, double scrollAmount, int mouseX, int mouseY, float delta) {
            this.renderBackground(drawContext, index, scrollAmount, mouseX, mouseY, delta);
            this.renderContent(drawContext, index, scrollAmount, mouseX, mouseY, delta);
            this.renderDecorations(drawContext, index, scrollAmount, mouseX, mouseY, delta);
        }

        public void renderBackground(class_332 drawContext, int index, double scrollAmount, int mouseX, int mouseY, float delta) {
            if (index % 2 == 0) {
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShader(class_757::method_34540);
                class_289 tessellator = class_289.method_1348();
                class_287 bufferBuilder = tessellator.method_1349();
                Matrix4f matrix4f = drawContext.method_51448().method_23760().method_23761();
                int left = this.left - 10 - this.parent.contentPadding / 2;
                int right = this.left + this.width + 10 + this.parent.contentPadding / 2 + 1;
                int top = this.top - (int)scrollAmount - this.parent.rowPadding / 2;
                int bottom = this.top + this.height - (int)scrollAmount + this.parent.rowPadding / 2 + 1;
                bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
                bufferBuilder.method_22918(matrix4f, (float)(left + 10), (float)top, 0.0f).method_1336(0, 0, 0, 85).method_1344();
                bufferBuilder.method_22918(matrix4f, (float)left, (float)top, 0.0f).method_1336(0, 0, 0, 0).method_1344();
                bufferBuilder.method_22918(matrix4f, (float)left, (float)bottom, 0.0f).method_1336(0, 0, 0, 0).method_1344();
                bufferBuilder.method_22918(matrix4f, (float)(left + 10), (float)bottom, 0.0f).method_1336(0, 0, 0, 85).method_1344();
                bufferBuilder.method_22918(matrix4f, (float)(right - 10), (float)top, 0.0f).method_1336(0, 0, 0, 85).method_1344();
                bufferBuilder.method_22918(matrix4f, (float)(left + 10), (float)top, 0.0f).method_1336(0, 0, 0, 85).method_1344();
                bufferBuilder.method_22918(matrix4f, (float)(left + 10), (float)bottom, 0.0f).method_1336(0, 0, 0, 85).method_1344();
                bufferBuilder.method_22918(matrix4f, (float)(right - 10), (float)bottom, 0.0f).method_1336(0, 0, 0, 85).method_1344();
                bufferBuilder.method_22918(matrix4f, (float)right, (float)top, 0.0f).method_1336(0, 0, 0, 0).method_1344();
                bufferBuilder.method_22918(matrix4f, (float)(right - 10), (float)top, 0.0f).method_1336(0, 0, 0, 85).method_1344();
                bufferBuilder.method_22918(matrix4f, (float)(right - 10), (float)bottom, 0.0f).method_1336(0, 0, 0, 85).method_1344();
                bufferBuilder.method_22918(matrix4f, (float)right, (float)bottom, 0.0f).method_1336(0, 0, 0, 0).method_1344();
                tessellator.method_1350();
                RenderSystem.disableBlend();
            }
        }

        public void renderContent(class_332 drawContext, int index, double scrollAmount, int mouseX, int mouseY, float delta) {
        }

        public void renderDecorations(class_332 drawContext, int index, double scrollAmount, int mouseX, int mouseY, float delta) {
        }

        public List<? extends class_6379> selectableChildren() {
            return this.method_25396().stream().filter(class_6379.class::isInstance).map(class_6379.class::cast).toList();
        }

        public boolean method_25405(double mouseX, double mouseY) {
            if (!this.parent.method_25405(mouseX, mouseY)) {
                return false;
            }
            return mouseX >= (double)this.getLeft() && mouseX <= (double)this.getRight() && mouseY >= (double)this.getTop() && mouseY <= (double)this.getBottom();
        }

        public void method_25395(class_364 focused) {
            if (this.focused != null) {
                this.focused.method_25365(false);
            }
            if (focused != null) {
                focused.method_25365(true);
            }
            this.focused = focused;
        }

        public class_364 method_25399() {
            return this.focused;
        }

        public class_8016 getNavigationPath(class_8023 navigation, int index) {
            if (this.method_25396().isEmpty()) {
                return null;
            }
            class_364 child = (class_364)this.method_25396().get(Math.min(index, this.method_25396().size() - 1));
            class_8016 path = child.method_48205(navigation);
            return class_8016.method_48192((class_4069)this, (class_8016)path);
        }

        public class_8016 method_48205(class_8023 navigation) {
            int index;
            int delta;
            if (!(navigation instanceof class_8023.class_8024)) {
                return super.method_48205(navigation);
            }
            class_8023.class_8024 arrow = (class_8023.class_8024)navigation;
            switch (arrow.comp_1191()) {
                case field_41828: {
                    int n = -1;
                    break;
                }
                case field_41829: {
                    int n = 1;
                    break;
                }
                default: {
                    int n = delta = 0;
                }
            }
            if (delta == 0) {
                return null;
            }
            for (int i = index = class_3532.method_15340((int)(delta + this.method_25396().indexOf(this.method_25399())), (int)0, (int)(this.method_25396().size() - 1)); i >= 0 && i < this.method_25396().size(); i += delta) {
                class_8016 path = ((class_364)this.method_25396().get(i)).method_48205(navigation);
                if (path == null) continue;
                return class_8016.method_48192((class_4069)this, (class_8016)path);
            }
            return super.method_48205(navigation);
        }

        void appendNarrations(class_6382 builder) {
            List<class_6379> list = this.selectableChildren();
            class_437.class_6390 data = class_437.method_37061(list, (class_6379)this.focusedSelectable);
            if (data != null) {
                if (data.field_33827.method_37028()) {
                    this.focusedSelectable = data.field_33825;
                }
                if (list.size() > 1) {
                    builder.method_37034(class_6381.field_33789, (class_2561)class_2561.method_43469((String)"narrator.position.object_list", (Object[])new Object[]{data.field_33826 + 1, list.size()}));
                    if (data.field_33827 == class_6379.class_6380.field_33786) {
                        builder.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.component_list.usage"));
                    }
                }
                data.field_33825.method_37020(builder.method_37031());
            }
        }
    }
}

