/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.concurrent.TimeUnit;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IJeiClientConfigs;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.class_124;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public final class SafeIngredientUtil {
    private static final Cache<ITypedIngredient<?>, Boolean> CRASHING_INGREDIENT_RENDER_CACHE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build();
    private static final Cache<ITypedIngredient<?>, Boolean> CRASHING_INGREDIENT_TOOLTIP_CACHE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build();

    private SafeIngredientUtil() {
    }

    public static <T> void getTooltip(ITooltipBuilder tooltip, IIngredientManager ingredientManager, IIngredientRenderer<T> ingredientRenderer, ITypedIngredient<T> typedIngredient) {
        class_310 minecraft = class_310.method_1551();
        class_1836.class_1837 tooltipFlag = minecraft.field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070;
        tooltipFlag = tooltipFlag.method_47371();
        SafeIngredientUtil.getTooltip(tooltip, ingredientManager, ingredientRenderer, typedIngredient, tooltipFlag);
    }

    public static <T> void getTooltip(ITooltipBuilder tooltip, IIngredientManager ingredientManager, IIngredientRenderer<T> ingredientRenderer, ITypedIngredient<T> typedIngredient, class_1836.class_1837 tooltipFlag) {
        if (CRASHING_INGREDIENT_TOOLTIP_CACHE.getIfPresent(typedIngredient) == Boolean.TRUE) {
            SafeIngredientUtil.getTooltipErrorTooltip(tooltip);
            return;
        }
        tooltip.setIngredient(typedIngredient);
        T ingredient = typedIngredient.getIngredient();
        try {
            ingredientRenderer.getTooltip(tooltip, ingredient, (class_1836)tooltipFlag);
            if (CRASHING_INGREDIENT_RENDER_CACHE.getIfPresent(typedIngredient) == Boolean.TRUE) {
                SafeIngredientUtil.getRenderErrorTooltip(tooltip);
            }
        }
        catch (LinkageError | RuntimeException e) {
            CRASHING_INGREDIENT_TOOLTIP_CACHE.put(typedIngredient, (Object)Boolean.TRUE);
            ErrorUtil.logIngredientCrash(e, "Caught an error getting an Ingredient's tooltip", ingredientManager, typedIngredient);
            SafeIngredientUtil.getTooltipErrorTooltip(tooltip);
        }
    }

    private static void getTooltipErrorTooltip(ITooltipBuilder tooltip) {
        class_5250 crash = class_2561.method_43471((String)"jei.tooltip.error.crash");
        tooltip.add((class_5348)crash.method_27692(class_124.field_1061));
    }

    private static void getRenderErrorTooltip(ITooltipBuilder tooltip) {
        class_5250 crash = class_2561.method_43471((String)"jei.tooltip.error.render.crash");
        tooltip.add((class_5348)crash.method_27692(class_124.field_1061));
    }

    public static <T> void render(class_332 guiGraphics, IIngredientRenderer<T> ingredientRenderer, ITypedIngredient<T> typedIngredient, int x, int y) {
        if (CRASHING_INGREDIENT_RENDER_CACHE.getIfPresent(typedIngredient) == Boolean.TRUE) {
            SafeIngredientUtil.renderError(guiGraphics);
            return;
        }
        T ingredient = typedIngredient.getIngredient();
        try {
            ingredientRenderer.render(guiGraphics, ingredient, x, y);
        }
        catch (LinkageError | RuntimeException e) {
            CRASHING_INGREDIENT_RENDER_CACHE.put(typedIngredient, (Object)Boolean.TRUE);
            IIngredientManager ingredientManager = Internal.getJeiRuntime().getIngredientManager();
            if (SafeIngredientUtil.shouldCatchRenderErrors()) {
                ErrorUtil.logIngredientCrash(e, "Caught an error rendering an Ingredient", ingredientManager, typedIngredient);
                SafeIngredientUtil.renderError(guiGraphics);
            }
            class_128 crashReport = ErrorUtil.createIngredientCrashReport(e, "Rendering ingredient", ingredientManager, typedIngredient);
            throw new class_148(crashReport);
        }
    }

    private static boolean shouldCatchRenderErrors() {
        return Internal.getOptionalJeiClientConfigs().map(IJeiClientConfigs::getClientConfig).map(IClientConfig::isCatchRenderErrorsEnabled).orElse(false);
    }

    private static void renderError(class_332 guiGraphics) {
        class_310 minecraft = class_310.method_1551();
        class_327 font = minecraft.field_1772;
        guiGraphics.method_51433(font, "ERR", 0, 0, -65536, false);
        guiGraphics.method_51433(font, "OR", 0, 8, -65536, false);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

