/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.fabric.platform;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.fabric.constants.FabricTypes;
import mezz.jei.api.fabric.ingredients.fluids.IJeiFluidIngredient;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.fabric.ingredients.fluid.JeiFluidIngredient;
import mezz.jei.library.render.FluidTankRenderer;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1058;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;

public class FluidHelper
implements IPlatformFluidHelperInternal<IJeiFluidIngredient> {
    @Override
    public IIngredientTypeWithSubtypes<class_3611, IJeiFluidIngredient> getFluidIngredientType() {
        return FabricTypes.FLUID_STACK;
    }

    @Override
    public IIngredientSubtypeInterpreter<IJeiFluidIngredient> getAllNbtSubtypeInterpreter() {
        return AllFluidNbt.INSTANCE;
    }

    @Override
    public IIngredientRenderer<IJeiFluidIngredient> createRenderer(long capacity, boolean showCapacity, int width, int height) {
        return new FluidTankRenderer<IJeiFluidIngredient>(this, capacity, showCapacity, width, height);
    }

    @Override
    public Optional<class_1058> getStillFluidSprite(IJeiFluidIngredient ingredient) {
        FluidVariant fluidVariant = this.getFluidVariant(ingredient);
        class_1058 sprite = FluidVariantRendering.getSprite((FluidVariant)fluidVariant);
        return Optional.ofNullable(sprite);
    }

    @Override
    public class_2561 getDisplayName(IJeiFluidIngredient ingredient) {
        FluidVariant fluidVariant = this.getFluidVariant(ingredient);
        return FluidVariantAttributes.getName((FluidVariant)fluidVariant);
    }

    @Override
    public int getColorTint(IJeiFluidIngredient ingredient) {
        FluidVariant fluidVariant = this.getFluidVariant(ingredient);
        int fluidColor = FluidVariantRendering.getColor((FluidVariant)fluidVariant);
        return fluidColor | 0xFF000000;
    }

    @Override
    public void getTooltip(ITooltipBuilder tooltip, IJeiFluidIngredient ingredient, class_1836 tooltipFlag) {
        FluidVariant fluidVariant = this.getFluidVariant(ingredient);
        List components = FluidVariantRendering.getTooltip((FluidVariant)fluidVariant, (class_1836)tooltipFlag);
        tooltip.addAll(components);
    }

    private FluidVariant getFluidVariant(IJeiFluidIngredient ingredient) {
        class_3611 fluid = ingredient.getFluid();
        class_2487 tag = ingredient.getTag().orElse(null);
        return FluidVariant.of((class_3611)fluid, (class_2487)tag);
    }

    @Override
    public long getAmount(IJeiFluidIngredient ingredient) {
        return ingredient.getAmount();
    }

    @Override
    public Optional<class_2487> getTag(IJeiFluidIngredient ingredient) {
        return ingredient.getTag();
    }

    @Override
    public long bucketVolume() {
        return 81000L;
    }

    @Override
    public IJeiFluidIngredient create(class_3611 fluid, long amount, @Nullable class_2487 tag) {
        return new JeiFluidIngredient(fluid, amount, tag);
    }

    @Override
    public IJeiFluidIngredient create(class_3611 fluid, long amount) {
        return new JeiFluidIngredient(fluid, amount);
    }

    @Override
    public IJeiFluidIngredient copy(IJeiFluidIngredient ingredient) {
        class_2487 tag = ingredient.getTag().orElse(null);
        return new JeiFluidIngredient(ingredient.getFluid(), ingredient.getAmount(), tag);
    }

    @Override
    public IJeiFluidIngredient normalize(IJeiFluidIngredient ingredient) {
        if (ingredient.getAmount() == this.bucketVolume()) {
            return ingredient;
        }
        class_2487 tag = ingredient.getTag().orElse(null);
        return new JeiFluidIngredient(ingredient.getFluid(), this.bucketVolume(), tag);
    }

    @Override
    public Optional<IJeiFluidIngredient> getContainedFluid(ITypedIngredient<?> ingredient) {
        return ingredient.getItemStack().map(ContainerItemContext::withConstant).map(c -> (Storage)c.find(FluidStorage.ITEM)).map(Storage::iterator).filter(Iterator::hasNext).map(Iterator::next).map(view -> {
            FluidVariant resource = (FluidVariant)view.getResource();
            return new JeiFluidIngredient(resource.getFluid(), this.bucketVolume(), resource.copyNbt());
        });
    }

    @Override
    public IJeiFluidIngredient copyWithAmount(IJeiFluidIngredient ingredient, long amount) {
        class_2487 tag = ingredient.getTag().orElse(null);
        return new JeiFluidIngredient(ingredient.getFluid(), amount, tag);
    }

    private static class AllFluidNbt
    implements IIngredientSubtypeInterpreter<IJeiFluidIngredient> {
        public static final AllFluidNbt INSTANCE = new AllFluidNbt();

        private AllFluidNbt() {
        }

        @Override
        public String apply(IJeiFluidIngredient storage, UidContext context) {
            return storage.getTag().filter(tag -> !tag.method_33133()).map(class_2487::toString).orElse("");
        }
    }
}

