/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.common.util.SafeIngredientUtil;
import mezz.jei.gui.ingredients.DisplayNameUtil;
import mezz.jei.gui.ingredients.IListElement;
import mezz.jei.gui.ingredients.IListElementInfo;
import mezz.jei.gui.ingredients.ListElementInfoTooltip;
import net.minecraft.class_1836;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class ListElementInfo<V>
implements IListElementInfo<V> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IListElement<V> element;
    private final String displayNameLowercase;
    private final List<String> modIds;
    private final List<String> modNames;
    private final class_2960 resourceLocation;
    private int sortedIndex = Integer.MAX_VALUE;

    @Nullable
    public static <V> IListElementInfo<V> create(IListElement<V> element, IIngredientManager ingredientManager, IModIdHelper modIdHelper) {
        ITypedIngredient<V> value = element.getTypedIngredient();
        IIngredientHelper<V> ingredientHelper = ingredientManager.getIngredientHelper(value.getType());
        try {
            return new ListElementInfo<V>(element, ingredientHelper, modIdHelper);
        }
        catch (RuntimeException e) {
            try {
                String ingredientInfo = ingredientHelper.getErrorInfo(value.getIngredient());
                LOGGER.warn("Found a broken ingredient {}", (Object)ingredientInfo, (Object)e);
            }
            catch (RuntimeException e2) {
                LOGGER.warn("Found a broken ingredient.", (Throwable)e2);
            }
            return null;
        }
    }

    protected ListElementInfo(IListElement<V> element, IIngredientHelper<V> ingredientHelper, IModIdHelper modIdHelper) {
        this.element = element;
        ITypedIngredient<V> value = element.getTypedIngredient();
        V ingredient = value.getIngredient();
        this.resourceLocation = ingredientHelper.getResourceLocation(ingredient);
        String displayModId = ingredientHelper.getDisplayModId(ingredient);
        String modId = this.resourceLocation.method_12836();
        if (modId.equals(displayModId)) {
            this.modIds = List.of(modId);
            this.modNames = List.of(modIdHelper.getModNameForModId(modId));
        } else {
            this.modIds = List.of(modId, displayModId);
            this.modNames = List.of(modIdHelper.getModNameForModId(modId), modIdHelper.getModNameForModId(displayModId));
        }
        this.displayNameLowercase = DisplayNameUtil.getLowercaseDisplayNameForSearch(ingredient, ingredientHelper);
    }

    @Override
    public String getName() {
        return this.displayNameLowercase;
    }

    @Override
    public String getModNameForSorting() {
        return this.modNames.get(0);
    }

    @Override
    public List<String> getModNames() {
        return this.modNames;
    }

    @Override
    public List<String> getModIds() {
        return this.modIds;
    }

    @Override
    public final @Unmodifiable Set<String> getTooltipStrings(IIngredientFilterConfig config, IIngredientManager ingredientManager) {
        String modName = this.modNames.get(0);
        String modId = this.modIds.get(0);
        String modNameLowercase = modName.toLowerCase(Locale.ENGLISH);
        ITypedIngredient<V> value = this.element.getTypedIngredient();
        IIngredientRenderer<V> ingredientRenderer = ingredientManager.getIngredientRenderer(value.getType());
        ImmutableSet toRemove = ImmutableSet.of((Object)modId, (Object)modNameLowercase, (Object)this.displayNameLowercase, (Object)this.resourceLocation.method_12832());
        class_1836.class_1837 tooltipFlag = config.getSearchAdvancedTooltips() ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070;
        tooltipFlag = tooltipFlag.method_47371();
        ListElementInfoTooltip tooltip = new ListElementInfoTooltip();
        SafeIngredientUtil.getTooltip(tooltip, ingredientManager, ingredientRenderer, value, tooltipFlag);
        Set<String> strings = tooltip.getStrings();
        strings.removeAll((Collection<?>)toRemove);
        return strings;
    }

    @Override
    public Collection<String> getTagStrings(IIngredientManager ingredientManager) {
        ITypedIngredient<V> value = this.element.getTypedIngredient();
        IIngredientHelper<V> ingredientHelper = ingredientManager.getIngredientHelper(value.getType());
        return ingredientHelper.getTagStream(value.getIngredient()).map(class_2960::method_12832).toList();
    }

    @Override
    public Stream<class_2960> getTagIds(IIngredientManager ingredientManager) {
        ITypedIngredient<V> value = this.element.getTypedIngredient();
        IIngredientHelper<V> ingredientHelper = ingredientManager.getIngredientHelper(value.getType());
        return ingredientHelper.getTagStream(value.getIngredient());
    }

    @Override
    public Iterable<Integer> getColors(IIngredientManager ingredientManager) {
        ITypedIngredient<V> value = this.element.getTypedIngredient();
        IIngredientHelper<V> ingredientHelper = ingredientManager.getIngredientHelper(value.getType());
        V ingredient = value.getIngredient();
        return ingredientHelper.getColors(ingredient);
    }

    @Override
    public class_2960 getResourceLocation() {
        return this.resourceLocation;
    }

    @Override
    public IListElement<V> getElement() {
        return this.element;
    }

    @Override
    public ITypedIngredient<V> getTypedIngredient() {
        return this.element.getTypedIngredient();
    }

    @Override
    public void setSortedIndex(int sortIndex) {
        this.sortedIndex = sortIndex;
    }

    @Override
    public int getSortedIndex() {
        return this.sortedIndex;
    }
}

