/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.recipes;

import java.util.Collections;
import java.util.List;
import mezz.jei.api.gui.inputs.IJeiGuiEventListener;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.util.MathUtil;
import mezz.jei.library.gui.recipes.RecipeLayout;
import net.minecraft.class_3675;
import net.minecraft.class_768;
import net.minecraft.class_8029;
import net.minecraft.class_8030;

public class RecipeLayoutInputHandler<T>
implements IJeiInputHandler {
    private final RecipeLayout<T> recipeLayout;
    private final List<IJeiInputHandler> inputHandlers;
    private final List<IJeiGuiEventListener> guiEventListeners;

    public RecipeLayoutInputHandler(RecipeLayout<T> recipeLayout, List<IJeiInputHandler> inputHandlers, List<IJeiGuiEventListener> guiEventListeners) {
        this.recipeLayout = recipeLayout;
        this.inputHandlers = Collections.unmodifiableList(inputHandlers);
        this.guiEventListeners = Collections.unmodifiableList(guiEventListeners);
    }

    @Override
    public class_8030 getArea() {
        class_768 area = this.recipeLayout.getRect();
        return new class_8030(area.method_3321(), area.method_3322(), area.method_3319(), area.method_3320());
    }

    @Override
    public boolean handleInput(double mouseX, double mouseY, IJeiUserInput userInput) {
        double relativeMouseY;
        class_8029 position;
        double relativeMouseX;
        class_8030 widgetArea;
        if (!this.recipeLayout.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        class_768 area = this.recipeLayout.getRect();
        double recipeMouseX = mouseX - (double)area.method_3321();
        double recipeMouseY = mouseY - (double)area.method_3322();
        for (IJeiInputHandler inputHandler : this.inputHandlers) {
            widgetArea = inputHandler.getArea();
            if (!MathUtil.contains(widgetArea, recipeMouseX, recipeMouseY) || !inputHandler.handleInput(relativeMouseX = recipeMouseX - (double)(position = widgetArea.comp_1195()).comp_1193(), relativeMouseY = recipeMouseY - (double)position.comp_1194(), userInput)) continue;
            return true;
        }
        for (IJeiGuiEventListener guiEventListener : this.guiEventListeners) {
            widgetArea = guiEventListener.getArea();
            if (!MathUtil.contains(widgetArea, recipeMouseX, recipeMouseY) || !RecipeLayoutInputHandler.handleInput(guiEventListener, relativeMouseX = recipeMouseX - (double)(position = widgetArea.comp_1195()).comp_1193(), relativeMouseY = recipeMouseY - (double)position.comp_1194(), userInput)) continue;
            return true;
        }
        if (userInput.isSimulate()) {
            return true;
        }
        IRecipeCategory<T> recipeCategory = this.recipeLayout.getRecipeCategory();
        T recipe = this.recipeLayout.getRecipe();
        boolean legacyResult = recipeCategory.handleInput(recipe, recipeMouseX, recipeMouseY, userInput.getKey());
        return legacyResult;
    }

    private static boolean handleInput(IJeiGuiEventListener guiEventListener, double relativeMouseX, double relativeMouseY, IJeiUserInput userInput) {
        class_3675.class_306 key = userInput.getKey();
        switch (key.method_1442()) {
            case field_1672: {
                if (userInput.isSimulate()) {
                    return guiEventListener.mouseClicked(relativeMouseX, relativeMouseY, key.method_1444());
                }
                return guiEventListener.mouseReleased(relativeMouseX, relativeMouseY, key.method_1444());
            }
            case field_1668: {
                if (userInput.isSimulate()) break;
                return guiEventListener.keyPressed(relativeMouseX, relativeMouseY, key.method_1444(), 0, userInput.getModifiers());
            }
            default: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean handleMouseDragged(double mouseX, double mouseY, class_3675.class_306 mouseKey, double dragX, double dragY) {
        double relativeMouseY;
        class_8029 position;
        double relativeMouseX;
        class_8030 widgetArea;
        if (!this.recipeLayout.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        class_768 area = this.recipeLayout.getRect();
        double recipeMouseX = mouseX - (double)area.method_3321();
        double recipeMouseY = mouseY - (double)area.method_3322();
        for (IJeiInputHandler inputHandler : this.inputHandlers) {
            widgetArea = inputHandler.getArea();
            if (!MathUtil.contains(widgetArea, recipeMouseX, recipeMouseY) || !inputHandler.handleMouseDragged(relativeMouseX = recipeMouseX - (double)(position = widgetArea.comp_1195()).comp_1193(), relativeMouseY = recipeMouseY - (double)position.comp_1194(), mouseKey, dragX, dragY)) continue;
            return true;
        }
        for (IJeiGuiEventListener guiEventListener : this.guiEventListeners) {
            widgetArea = guiEventListener.getArea();
            if (!MathUtil.contains(widgetArea, recipeMouseX, recipeMouseY) || !guiEventListener.mouseDragged(relativeMouseX = recipeMouseX - (double)(position = widgetArea.comp_1195()).comp_1193(), relativeMouseY = recipeMouseY - (double)position.comp_1194(), mouseKey.method_1444(), dragX, dragY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollDelta) {
        double relativeMouseY;
        class_8029 position;
        double relativeMouseX;
        class_8030 widgetArea;
        if (!this.recipeLayout.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        class_768 area = this.recipeLayout.getRect();
        double recipeMouseX = mouseX - (double)area.method_3321();
        double recipeMouseY = mouseY - (double)area.method_3322();
        for (IJeiInputHandler inputHandler : this.inputHandlers) {
            widgetArea = inputHandler.getArea();
            if (!MathUtil.contains(widgetArea, recipeMouseX, recipeMouseY) || !inputHandler.handleMouseScrolled(relativeMouseX = recipeMouseX - (double)(position = widgetArea.comp_1195()).comp_1193(), relativeMouseY = recipeMouseY - (double)position.comp_1194(), scrollDelta)) continue;
            return true;
        }
        for (IJeiGuiEventListener guiEventListener : this.guiEventListeners) {
            widgetArea = guiEventListener.getArea();
            if (!MathUtil.contains(widgetArea, recipeMouseX, recipeMouseY) || !guiEventListener.mouseScrolled(relativeMouseX = recipeMouseX - (double)(position = widgetArea.comp_1195()).comp_1193(), relativeMouseY = recipeMouseY - (double)position.comp_1194(), scrollDelta)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void handleMouseMoved(double mouseX, double mouseY) {
        double relativeMouseY;
        double relativeMouseX;
        class_8029 position;
        class_8030 widgetArea;
        if (!this.recipeLayout.isMouseOver(mouseX, mouseY)) {
            return;
        }
        class_768 area = this.recipeLayout.getRect();
        double recipeMouseX = mouseX - (double)area.method_3321();
        double recipeMouseY = mouseY - (double)area.method_3322();
        for (IJeiInputHandler inputHandler : this.inputHandlers) {
            widgetArea = inputHandler.getArea();
            if (!MathUtil.contains(widgetArea, recipeMouseX, recipeMouseY)) continue;
            position = widgetArea.comp_1195();
            relativeMouseX = recipeMouseX - (double)position.comp_1193();
            relativeMouseY = recipeMouseY - (double)position.comp_1194();
            inputHandler.handleMouseMoved(relativeMouseX, relativeMouseY);
        }
        for (IJeiGuiEventListener guiEventListener : this.guiEventListeners) {
            widgetArea = guiEventListener.getArea();
            if (!MathUtil.contains(widgetArea, recipeMouseX, recipeMouseY)) continue;
            position = widgetArea.comp_1195();
            relativeMouseX = recipeMouseX - (double)position.comp_1193();
            relativeMouseY = recipeMouseY - (double)position.comp_1194();
            guiEventListener.mouseMoved(relativeMouseX, relativeMouseY);
        }
    }
}

