/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IJeiClientConfigs;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.util.RegistryUtil;
import mezz.jei.library.plugins.jei.info.IngredientInfoRecipeCategory;
import mezz.jei.library.plugins.jei.tags.ITagInfoRecipe;
import mezz.jei.library.plugins.jei.tags.TagInfoRecipeCategory;
import mezz.jei.library.plugins.jei.tags.TagInfoRecipeMaker;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

@JeiPlugin
public class JeiInternalPlugin
implements IModPlugin {
    private final List<TagInfoRecipeMaker<?, ?>> tagInfoRecipeMakers = new ArrayList();

    @Override
    public class_2960 getPluginUid() {
        return new class_2960("jei", "internal");
    }

    @Override
    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IIngredientManager ingredientManager = jeiHelpers.getIngredientManager();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        Textures textures = Internal.getTextures();
        registration.addRecipeCategories(new IngredientInfoRecipeCategory(guiHelper, textures));
        this.tagInfoRecipeMakers.clear();
        IJeiClientConfigs jeiClientConfigs = Internal.getJeiClientConfigs();
        IClientConfig clientConfig = jeiClientConfigs.getClientConfig();
        if (clientConfig.isShowTagRecipesEnabled()) {
            RegistryUtil.getRegistryAccess().method_40311().forEach(entry -> {
                class_2378 registry = entry.comp_351();
                JeiInternalPlugin.createAndRegisterTagCategory(registration, this.tagInfoRecipeMakers, ingredientManager, registry);
            });
        }
    }

    @Override
    public void registerRecipes(IRecipeRegistration registration) {
        IJeiClientConfigs jeiClientConfigs = Internal.getJeiClientConfigs();
        IClientConfig clientConfig = jeiClientConfigs.getClientConfig();
        if (clientConfig.isShowTagRecipesEnabled()) {
            for (TagInfoRecipeMaker<?, ?> data : this.tagInfoRecipeMakers) {
                data.addRecipes(registration);
            }
        }
        this.tagInfoRecipeMakers.clear();
    }

    private static <B> void createAndRegisterTagCategory(IRecipeCategoryRegistration registration, List<TagInfoRecipeMaker<?, ?>> tagInfoRecipeMakers, IIngredientManager ingredientManager, class_2378<B> registry) {
        registry.method_40270().findAny().ifPresent(holder -> {
            class_2378 itemLikeRegistry;
            IJeiHelpers jeiHelpers = registration.getJeiHelpers();
            IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
            Object ingredient = holder.comp_349();
            IIngredientType type = ingredientManager.getIngredientTypeChecked(ingredient).orElse(null);
            if (type != null) {
                class_2960 registryLocation = registry.method_30517().method_29177();
                RecipeType<ITagInfoRecipe> recipeType = JeiInternalPlugin.createTagInfoRecipeType(registryLocation);
                registration.addRecipeCategories(new TagInfoRecipeCategory(guiHelper, recipeType, registryLocation));
                tagInfoRecipeMakers.add(new TagInfoRecipeMaker(type, recipeType, Function.identity(), registry.method_30517()));
                return;
            }
            IIngredientTypeWithSubtypes typeWithSubtypes = ingredientManager.getIngredientTypeWithSubtypesFromBase(ingredient).orElse(null);
            if (typeWithSubtypes != null && JeiInternalPlugin.createAndRegisterTagCategory(registration, tagInfoRecipeMakers, registry, ingredient, typeWithSubtypes)) {
                return;
            }
            if (ingredient instanceof class_1935 && JeiInternalPlugin.createAndRegisterItemLikeTagCategory(registration, tagInfoRecipeMakers, itemLikeRegistry = registry)) {
                return;
            }
        });
    }

    private static RecipeType<ITagInfoRecipe> createTagInfoRecipeType(class_2960 registryLocation) {
        return RecipeType.create(registryLocation.method_12836(), "tag_recipes/" + registryLocation.method_12832(), ITagInfoRecipe.class);
    }

    private static <B, I> boolean createAndRegisterTagCategory(IRecipeCategoryRegistration registration, List<TagInfoRecipeMaker<?, ?>> tagInfoRecipeMakers, class_2378<B> registry, B baseIngredient, IIngredientTypeWithSubtypes<B, I> knownType) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        try {
            knownType.getDefaultIngredient(baseIngredient);
        }
        catch (UnsupportedOperationException ignored) {
            return false;
        }
        class_2960 registryLocation = registry.method_30517().method_29177();
        RecipeType<ITagInfoRecipe> recipeType = JeiInternalPlugin.createTagInfoRecipeType(registryLocation);
        registration.addRecipeCategories(new TagInfoRecipeCategory(guiHelper, recipeType, registryLocation));
        tagInfoRecipeMakers.add(new TagInfoRecipeMaker<Object, Object>(knownType, recipeType, knownType::getDefaultIngredient, registry.method_30517()));
        return true;
    }

    private static <B extends class_1935> boolean createAndRegisterItemLikeTagCategory(IRecipeCategoryRegistration registration, List<TagInfoRecipeMaker<?, ?>> tagInfoRecipeMakers, class_2378<B> registry) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        class_5321 registryKey = registry.method_30517();
        class_2960 registryLocation = registryKey.method_29177();
        RecipeType<ITagInfoRecipe> recipeType = JeiInternalPlugin.createTagInfoRecipeType(registryLocation);
        registration.addRecipeCategories(new TagInfoRecipeCategory(guiHelper, recipeType, registryLocation));
        tagInfoRecipeMakers.add(new TagInfoRecipeMaker<class_1935, class_1799>(VanillaTypes.ITEM_STACK, recipeType, class_1799::new, registryKey));
        return true;
    }
}

