/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.jei.tags;

import java.util.List;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IScrollGridWidgetFactory;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.common.util.StringUtil;
import mezz.jei.library.plugins.jei.tags.ITagInfoRecipe;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_6862;
import net.minecraft.class_8030;
import org.apache.commons.lang3.StringUtils;

public class TagInfoRecipeCategory<R extends ITagInfoRecipe, T extends RecipeType<R>>
implements IRecipeCategory<R> {
    private static final int WIDTH = 142;
    private static final int HEIGHT = 110;
    private final IDrawable background;
    private final IDrawable icon;
    private final T recipeType;
    private final class_2561 localizedName;
    private final ImmutableRect2i nameArea;
    private final IScrollGridWidgetFactory<?> scrollGridFactory;
    private final IDrawableStatic slotDrawable;

    public TagInfoRecipeCategory(IGuiHelper guiHelper, T recipeType, class_2960 registryLocation) {
        this.background = guiHelper.createBlankDrawable(142, 110);
        this.icon = guiHelper.createDrawableItemStack(new class_1799((class_1935)class_1802.field_8448));
        this.slotDrawable = guiHelper.getSlotDrawable();
        this.recipeType = recipeType;
        String registryName = StringUtils.capitalize((String)registryLocation.method_12832());
        this.localizedName = class_2561.method_43469((String)"gui.jei.category.tagInformation", (Object[])new Object[]{registryName});
        Objects.requireNonNull(class_310.method_1551().field_1772);
        int titleHeight = 9;
        this.nameArea = new ImmutableRect2i(22, 5, 120, titleHeight);
        this.scrollGridFactory = guiHelper.createScrollGridFactory(7, 5);
        class_8030 gridArea = this.scrollGridFactory.getArea();
        this.scrollGridFactory.setPosition((142 - gridArea.comp_1196()) / 2, 20);
    }

    public T getRecipeType() {
        return this.recipeType;
    }

    @Override
    public class_2561 getTitle() {
        return this.localizedName;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, R recipe, IFocusGroup focuses) {
        class_8030 gridArea = this.scrollGridFactory.getArea();
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, gridArea.comp_1195().comp_1193() + 1, 1).addTypedIngredients((List)recipe.getTypedIngredients())).setBackground(this.slotDrawable, -1, -1);
        for (ITypedIngredient<?> stack : recipe.getTypedIngredients()) {
            builder.addSlotToWidget(RecipeIngredientRole.OUTPUT, this.scrollGridFactory).addTypedIngredient(stack);
        }
    }

    @Override
    public void draw(R recipe, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        class_310 minecraft = class_310.method_1551();
        class_327 font = minecraft.field_1772;
        class_6862<?> tag = recipe.getTag();
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        class_2561 tagName = renderHelper.getName(tag);
        if (font.method_27525((class_5348)tagName) > this.nameArea.width()) {
            tagName = StringUtil.truncateStringToWidth(tagName, this.nameArea.width(), font);
        }
        ImmutableRect2i nameArea = MathUtil.centerTextArea(this.nameArea, font, (class_5348)tagName);
        guiGraphics.method_51439(font, tagName, nameArea.x(), nameArea.getY(), -11513776, false);
    }

    @Override
    public List<class_2561> getTooltipStrings(R recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (this.nameArea.contains(mouseX, mouseY)) {
            class_6862<?> tag = recipe.getTag();
            IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
            class_2561 tagName = renderHelper.getName(tag);
            return List.of(tagName, class_2561.method_43470((String)tag.comp_327().toString()).method_27692(class_124.field_1080));
        }
        return List.of();
    }

    @Override
    public void getTooltip(ITooltipBuilder tooltip, R recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (!this.nameArea.contains(mouseX, mouseY)) {
            return;
        }
        class_6862<?> tag = recipe.getTag();
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        class_2561 tagName = renderHelper.getName(tag);
        tooltip.add((class_5348)tagName);
        tooltip.add((class_5348)class_2561.method_43470((String)tag.comp_327().toString()).method_27692(class_124.field_1080));
    }

    @Override
    public class_2960 getRegistryName(R recipe) {
        return recipe.getTag().comp_327();
    }
}

