/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.anvil;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.IExtendableSmithingRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.ISmithingCategoryExtension;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_8059;
import org.jetbrains.annotations.Nullable;

public class SmithingRecipeCategory
implements IRecipeCategory<class_8059>,
IExtendableSmithingRecipeCategory {
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slot;
    private final IDrawable recipeArrow;
    private final Map<Class<? extends class_8059>, ISmithingCategoryExtension<?>> extensions = new HashMap();

    public SmithingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(108, 28);
        this.slot = guiHelper.getSlotDrawable();
        this.icon = guiHelper.createDrawableItemStack(new class_1799((class_1935)class_2246.field_16329));
        Textures textures = Internal.getTextures();
        this.recipeArrow = textures.getRecipeArrow();
    }

    @Override
    public RecipeType<class_8059> getRecipeType() {
        return RecipeTypes.SMITHING;
    }

    @Override
    public class_2561 getTitle() {
        return class_2246.field_16329.method_9518();
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, class_8059 recipe, IFocusGroup focuses) {
        ISmithingCategoryExtension<class_8059> extension = this.getExtension(recipe);
        if (extension == null) {
            return;
        }
        IRecipeSlotBuilder templateSlot = builder.addSlot(RecipeIngredientRole.INPUT, 1, 6).setBackground(this.slot, -1, -1);
        IRecipeSlotBuilder baseSlot = builder.addSlot(RecipeIngredientRole.INPUT, 19, 6).setBackground(this.slot, -1, -1);
        IRecipeSlotBuilder additionSlot = builder.addSlot(RecipeIngredientRole.INPUT, 37, 6).setBackground(this.slot, -1, -1);
        IRecipeSlotBuilder outputSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, 91, 6).setBackground(this.slot, -1, -1);
        extension.setTemplate(recipe, templateSlot);
        extension.setBase(recipe, baseSlot);
        extension.setAddition(recipe, additionSlot);
        extension.setOutput(recipe, outputSlot);
    }

    @Override
    public void onDisplayedIngredientsUpdate(class_8059 recipe, List<IRecipeSlotDrawable> recipeSlots, IFocusGroup focuses) {
        IRecipeSlotDrawable templateSlot = recipeSlots.get(0);
        IRecipeSlotDrawable baseSlot = recipeSlots.get(1);
        IRecipeSlotDrawable additionSlot = recipeSlots.get(2);
        IRecipeSlotDrawable outputSlot = recipeSlots.get(3);
        List<IFocus<?>> outputFocuses = focuses.getFocuses(RecipeIngredientRole.OUTPUT).toList();
        if (outputFocuses.isEmpty()) {
            class_1799 template = templateSlot.getDisplayedItemStack().orElse(class_1799.field_8037);
            class_1799 base = baseSlot.getDisplayedItemStack().orElse(class_1799.field_8037);
            class_1799 addition = additionSlot.getDisplayedItemStack().orElse(class_1799.field_8037);
            class_1263 recipeInput = SmithingRecipeCategory.createInput(template, base, addition);
            class_1799 output = RecipeUtil.assembleResultItem(recipeInput, recipe);
            outputSlot.createDisplayOverrides().addItemStack(output);
        } else {
            class_1799 output = outputSlot.getDisplayedItemStack().orElse(class_1799.field_8037);
            class_1799 base = new class_1799((class_1935)output.method_7909());
            class_1799 template = templateSlot.getDisplayedItemStack().orElse(class_1799.field_8037);
            class_1799 addition = additionSlot.getDisplayedItemStack().orElse(class_1799.field_8037);
            baseSlot.createDisplayOverrides().addItemStack(base);
            class_1263 recipeInput = SmithingRecipeCategory.createInput(template, base, addition);
            output = RecipeUtil.assembleResultItem(recipeInput, recipe);
            outputSlot.createDisplayOverrides().addItemStack(output);
        }
    }

    private static class_1263 createInput(class_1799 template, class_1799 base, class_1799 addition) {
        class_1277 container = new class_1277(3);
        container.method_5447(0, template);
        container.method_5447(1, base);
        container.method_5447(2, addition);
        return container;
    }

    @Override
    public void draw(class_8059 recipe, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        this.recipeArrow.draw(guiGraphics, 61, 7);
    }

    @Override
    public boolean isHandled(class_8059 recipe) {
        ISmithingCategoryExtension extension = this.getExtension(recipe);
        return extension != null;
    }

    @Override
    public class_2960 getRegistryName(class_8059 recipe) {
        return recipe.method_8114();
    }

    @Override
    public <R extends class_8059> void addExtension(Class<? extends R> recipeClass, ISmithingCategoryExtension<R> extension) {
        ErrorUtil.checkNotNull(recipeClass, "recipeClass");
        ErrorUtil.checkNotNull(extension, "extension");
        if (this.extensions.containsKey(recipeClass)) {
            throw new IllegalArgumentException("An extension has already been registered for: " + recipeClass);
        }
        this.extensions.put(recipeClass, extension);
    }

    @Nullable
    private <R extends class_8059> ISmithingCategoryExtension<? super R> getExtension(class_8059 recipe) {
        ISmithingCategoryExtension<?> extension = this.extensions.get(recipe.getClass());
        if (extension != null) {
            return extension;
        }
        for (Map.Entry<Class<class_8059>, ISmithingCategoryExtension<?>> e : this.extensions.entrySet()) {
            if (!e.getKey().isInstance(recipe)) continue;
            return e.getValue();
        }
        return null;
    }
}

