/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.crafting;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.extensions.IExtendableRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.common.Constants;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.recipes.ExtendableRecipeCategoryHelper;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_3955;

public class CraftingRecipeCategory
implements IExtendableRecipeCategory<class_3955, ICraftingCategoryExtension> {
    public static final int width = 116;
    public static final int height = 54;
    private final IDrawable background;
    private final IDrawable icon;
    private final class_2561 localizedName;
    private final ICraftingGridHelper craftingGridHelper;
    private final ExtendableRecipeCategoryHelper<class_1860<?>, ICraftingCategoryExtension> extendableHelper = new ExtendableRecipeCategoryHelper(class_3955.class);

    public CraftingRecipeCategory(IGuiHelper guiHelper) {
        class_2960 location = Constants.RECIPE_GUI_VANILLA;
        this.background = guiHelper.createDrawable(location, 0, 60, 116, 54);
        this.icon = guiHelper.createDrawableItemStack(new class_1799((class_1935)class_2246.field_9980));
        this.localizedName = class_2561.method_43471((String)"gui.jei.category.craftingTable");
        this.craftingGridHelper = guiHelper.createCraftingGridHelper();
    }

    @Override
    public RecipeType<class_3955> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Override
    public class_2561 getTitle() {
        return this.localizedName;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, class_3955 recipe, IFocusGroup focuses) {
        ICraftingCategoryExtension recipeExtension = this.extendableHelper.getRecipeExtension(recipe);
        recipeExtension.setRecipe(builder, this.craftingGridHelper, focuses);
    }

    @Override
    public void createRecipeExtras(IRecipeExtrasBuilder builder, class_3955 recipe, IFocusGroup focuses) {
        ICraftingCategoryExtension recipeExtension = this.extendableHelper.getRecipeExtension(recipe);
        recipeExtension.createRecipeExtras(builder, this.craftingGridHelper, focuses);
    }

    @Override
    public void draw(class_3955 recipe, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        ICraftingCategoryExtension extension = this.extendableHelper.getRecipeExtension(recipe);
        int recipeWidth = this.getWidth();
        int recipeHeight = this.getHeight();
        extension.drawInfo(recipeWidth, recipeHeight, guiGraphics, mouseX, mouseY);
    }

    @Override
    public void getTooltip(ITooltipBuilder tooltip, class_3955 recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ICraftingCategoryExtension extension = this.extendableHelper.getRecipeExtension(recipe);
        extension.getTooltip(tooltip, mouseX, mouseY);
    }

    @Override
    public List<class_2561> getTooltipStrings(class_3955 recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ICraftingCategoryExtension extension = this.extendableHelper.getRecipeExtension(recipe);
        return extension.getTooltipStrings(mouseX, mouseY);
    }

    @Override
    public boolean handleInput(class_3955 recipe, double mouseX, double mouseY, class_3675.class_306 input) {
        ICraftingCategoryExtension extension = this.extendableHelper.getRecipeExtension(recipe);
        return extension.handleInput(mouseX, mouseY, input);
    }

    @Override
    public boolean isHandled(class_3955 recipe) {
        return this.extendableHelper.getOptionalRecipeExtension(recipe).isPresent();
    }

    @Override
    public <R extends class_3955> void addCategoryExtension(Class<? extends R> recipeClass, Function<R, ? extends ICraftingCategoryExtension> extensionFactory) {
        ErrorUtil.checkNotNull(recipeClass, "recipeClass");
        ErrorUtil.checkNotNull(extensionFactory, "extensionFactory");
        this.extendableHelper.addRecipeExtensionFactory(recipeClass, null, extensionFactory);
    }

    @Override
    public <R extends class_3955> void addCategoryExtension(Class<? extends R> recipeClass, Predicate<R> extensionFilter, Function<R, ? extends ICraftingCategoryExtension> extensionFactory) {
        ErrorUtil.checkNotNull(recipeClass, "recipeClass");
        ErrorUtil.checkNotNull(extensionFilter, "extensionFilter");
        ErrorUtil.checkNotNull(extensionFactory, "extensionFactory");
        this.extendableHelper.addRecipeExtensionFactory(recipeClass, extensionFilter, extensionFactory);
    }

    @Override
    public class_2960 getRegistryName(class_3955 recipe) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        return this.extendableHelper.getOptionalRecipeExtension(recipe).flatMap(extension -> Optional.ofNullable(extension.getRegistryName())).orElseGet(() -> ((class_3955)recipe).method_8114());
    }
}

