/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.integration.ModernFixCompat;
import net.mehvahdjukaar.moonlight.api.misc.PathTrie;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.core.CompatHandler;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3272;
import net.minecraft.class_3274;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import net.minecraft.class_7699;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicResourcePack
implements class_3262 {
    private static final List<DynamicResourcePack> INSTANCES = new ArrayList<DynamicResourcePack>();
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final boolean hidden;
    protected final boolean fixed;
    protected final class_3288.class_3289 position;
    protected final class_3264 packType;
    protected final Supplier<class_3272> metadata;
    protected final class_2561 title;
    protected final class_2960 resourcePackName;
    protected final Set<String> namespaces = new HashSet<String>();
    protected final Map<class_2960, byte[]> resources = new ConcurrentHashMap<class_2960, byte[]>();
    protected final PathTrie<class_2960> searchTrie = new PathTrie();
    protected final Map<String, byte[]> rootResources = new ConcurrentHashMap<String, byte[]>();
    protected final String mainNamespace;
    protected boolean clearOnReload = true;
    protected Set<class_2960> staticResources = new HashSet<class_2960>();
    protected boolean generateDebugResources;
    boolean addToStatic = false;
    private static final boolean MODERN_FIX = CompatHandler.MODERNFIX && ModernFixCompat.areLazyResourcesOn();

    @ApiStatus.Internal
    public static void clearAfterReload(class_3264 targetType) {
        for (DynamicResourcePack p : INSTANCES) {
            if (p.packType != targetType) continue;
            p.clearNonStatic();
        }
    }

    @ApiStatus.Internal
    public static void clearBeforeReload(class_3264 targetType) {
        for (DynamicResourcePack p : INSTANCES) {
            if (p.packType != targetType) continue;
            p.clearAllContent();
        }
    }

    protected DynamicResourcePack(class_2960 name, class_3264 type) {
        this(name, type, class_3288.class_3289.field_14280, false, false);
    }

    protected DynamicResourcePack(class_2960 name, class_3264 type, class_3288.class_3289 position, boolean fixed, boolean hidden) {
        this.packType = type;
        this.resourcePackName = name;
        this.mainNamespace = name.method_12836();
        this.namespaces.add(this.mainNamespace);
        this.title = class_2561.method_43471((String)LangBuilder.getReadableName(name.toString()));
        this.position = position;
        this.fixed = fixed;
        this.hidden = hidden;
        this.metadata = Suppliers.memoize(() -> new class_3272(this.makeDescription(), class_155.method_16673().method_48017(type)));
        this.generateDebugResources = PlatHelper.isDev();
    }

    public class_2561 makeDescription() {
        return class_2561.method_43471((String)LangBuilder.getReadableName(this.mainNamespace + "_dynamic_resources"));
    }

    public void setClearOnReload(boolean canBeCleared) {
        this.clearOnReload = canBeCleared;
    }

    @Deprecated(forRemoval=true)
    public void clearOnReload(boolean canBeCleared) {
        this.clearOnReload = canBeCleared;
    }

    public void markNotClearable(class_2960 staticResources) {
        this.staticResources.add(staticResources);
    }

    public void unMarkNotClearable(class_2960 staticResources) {
        this.staticResources.remove(staticResources);
    }

    public void setGenerateDebugResources(boolean generateDebugResources) {
        this.generateDebugResources = generateDebugResources;
    }

    public void addNamespaces(String ... namespaces) {
        this.namespaces.addAll(Arrays.asList(namespaces));
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public String method_14409() {
        return this.title.getString();
    }

    public class_2960 id() {
        return this.resourcePackName;
    }

    public String toString() {
        return this.method_14409();
    }

    public void registerPack() {
        if (!INSTANCES.contains(this)) {
            PlatHelper.registerResourcePack(this.packType, () -> class_3288.method_14456((String)this.method_14409(), (class_2561)this.getTitle(), (boolean)true, s -> this, (class_3288.class_7679)new class_3288.class_7679(this.metadata.get().method_14423(), this.metadata.get().method_14424(), class_7699.method_45397()), (class_3264)this.packType, (class_3288.class_3289)class_3288.class_3289.field_14280, (boolean)this.fixed, (class_5352)class_5352.field_25348));
            INSTANCES.add(this);
        }
    }

    public Set<String> method_14406(class_3264 packType) {
        return this.namespaces;
    }

    public <T> T method_14407(class_3270<T> serializer) {
        return (T)(serializer instanceof class_3274 ? this.metadata : null);
    }

    public void addRootResource(String name, byte[] resource) {
        this.rootResources.put(name, resource);
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... strings) {
        String fileName = String.join((CharSequence)"/", strings);
        byte[] resource = this.rootResources.get(fileName);
        return resource == null ? null : () -> new ByteArrayInputStream(resource);
    }

    public void method_14408(class_3264 packType, String namespace, String id, class_3262.class_7664 output) {
        if (packType == this.packType) {
            this.searchTrie.search(namespace + "/" + id).forEach(r -> output.accept(r, () -> {
                byte[] buf = this.resources.get(r);
                if (buf == null) {
                    throw new IllegalStateException("Somehow search tree returned a resource not in resources " + String.valueOf(r));
                }
                return new ByteArrayInputStream(buf);
            }));
        }
    }

    public class_7367<InputStream> method_14405(class_3264 type, class_2960 id) {
        byte[] res = this.resources.get(id);
        if (res != null) {
            return () -> {
                if (type != this.packType) {
                    throw new IOException(String.format("Tried to access wrong type of resource on %s.", this.resourcePackName));
                }
                return new ByteArrayInputStream(res);
            };
        }
        return null;
    }

    public void close() {
    }

    public FileNotFoundException makeFileNotFoundException(String path) {
        return new FileNotFoundException(String.format("'%s' in ResourcePack '%s'", path, this.resourcePackName));
    }

    protected void addBytes(class_2960 id, byte[] bytes) {
        this.namespaces.add(id.method_12836());
        this.resources.put(id, (byte[])Preconditions.checkNotNull((Object)bytes));
        this.searchTrie.insert(id, id);
        if (this.addToStatic) {
            this.markNotClearable(id);
        }
        if (this.generateDebugResources) {
            try {
                Path p = Paths.get("debug", "generated_resource_pack").resolve(id.method_12836() + "/" + id.method_12832());
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
                Files.write(p, bytes, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void removeResource(class_2960 res) {
        this.resources.remove(res);
        this.staticResources.remove(res);
        this.searchTrie.remove(res);
    }

    public void addResource(StaticResource resource) {
        this.addBytes(resource.location, resource.data);
    }

    private void addJson(class_2960 path, JsonElement json) {
        try {
            this.addBytes(path, RPUtils.serializeJson(json).getBytes());
        }
        catch (IOException e) {
            LOGGER.error("Failed to write JSON {} to resource pack {}.", (Object)path, (Object)this.resourcePackName, (Object)e);
        }
    }

    public void addJson(class_2960 location, JsonElement json, ResType resType) {
        this.addJson(resType.getPath(location), json);
    }

    public void addBytes(class_2960 location, byte[] bytes, ResType resType) {
        this.addBytes(resType.getPath(location), bytes);
    }

    public class_3264 getPackType() {
        return this.packType;
    }

    @ApiStatus.Internal
    protected void clearNonStatic() {
        Stopwatch watch = Stopwatch.createStarted();
        boolean mf = MODERN_FIX && this.getPackType() == class_3264.field_14188;
        boolean hasLessStatic = false;
        for (class_2960 class_29602 : this.resources.keySet()) {
            if (mf && this.modernFixHack(class_29602.method_12832()) || this.staticResources.contains(class_29602)) continue;
            this.resources.remove(class_29602);
            if (hasLessStatic) continue;
            this.searchTrie.remove(class_29602);
        }
        if (hasLessStatic) {
            if (!mf) {
                this.searchTrie.clear();
            } else {
                ArrayList<CallSite> toRemove = new ArrayList<CallSite>();
                for (String namespace : this.searchTrie.listFolders("")) {
                    for (String f : this.searchTrie.listFolders(namespace)) {
                        if (this.modernFixHack(f)) continue;
                        toRemove.add((CallSite)((Object)(namespace + "/" + f)));
                    }
                }
                toRemove.forEach(this.searchTrie::remove);
            }
            for (class_2960 class_29603 : this.staticResources) {
                this.searchTrie.insert(class_29603, class_29603);
            }
        }
        Moonlight.LOGGER.info("Cleared non-static resources for pack {} in: {} ms", (Object)this.resourcePackName, (Object)watch.elapsed().toMillis());
    }

    @ApiStatus.Internal
    protected void clearAllContent() {
        if (this.clearOnReload) {
            this.resources.clear();
            this.searchTrie.clear();
        }
    }

    private boolean modernFixHack(String s) {
        return s.startsWith("model") || s.startsWith("blockstate");
    }
}

