/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.skin;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.lionarius.skinrestorer.skin.SkinIO;
import net.lionarius.skinrestorer.skin.SkinValue;

public class SkinStorage {
    private final Map<UUID, SkinValue> skinMap = new ConcurrentHashMap<UUID, SkinValue>();
    private final SkinIO skinIO;

    public SkinStorage(SkinIO skinIO) {
        this.skinIO = skinIO;
    }

    public boolean hasSavedSkin(UUID uuid) {
        return this.skinMap.containsKey(uuid) || this.skinIO.skinExists(uuid);
    }

    public SkinValue getSkin(UUID uuid) {
        if (!this.skinMap.containsKey(uuid)) {
            SkinValue skin = this.skinIO.loadSkin(uuid);
            this.setSkin(uuid, skin);
        }
        return this.skinMap.get(uuid);
    }

    public void removeSkin(UUID uuid, boolean save) {
        SkinValue skin = this.skinMap.remove(uuid);
        if (skin != null && save) {
            this.skinIO.saveSkin(uuid, skin);
        }
    }

    public void removeSkin(UUID uuid) {
        this.removeSkin(uuid, true);
    }

    public void deleteSkin(UUID uuid) {
        this.removeSkin(uuid, false);
        this.skinIO.deleteSkin(uuid);
    }

    public void setSkin(UUID uuid, SkinValue skin) {
        if (skin == null) {
            skin = SkinValue.EMPTY;
        }
        if (this.skinMap.containsKey(uuid) && skin.originalValue() == null) {
            skin = skin.setOriginalValue(this.skinMap.get(uuid).originalValue());
        }
        this.skinMap.put(uuid, skin);
    }
}

