/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.skin.provider;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.authlib.properties.Property;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import net.lionarius.skinrestorer.skin.SkinVariant;
import net.lionarius.skinrestorer.skin.provider.SkinProvider;
import net.lionarius.skinrestorer.util.JsonUtils;
import net.lionarius.skinrestorer.util.PlayerUtils;
import net.lionarius.skinrestorer.util.Result;
import net.lionarius.skinrestorer.util.WebUtils;

public final class ElyBySkinProvider
implements SkinProvider {
    public static final String PROVIDER_NAME = "ely.by";
    private static final URI API_URI;

    @Override
    public String getArgumentName() {
        return "username";
    }

    @Override
    public boolean hasVariantSupport() {
        return false;
    }

    @Override
    public Result<Optional<Property>, Exception> getSkin(String username, SkinVariant variant) {
        try {
            JsonObject profile = ElyBySkinProvider.getElyByProfile(username);
            JsonArray properties = profile.getAsJsonArray("properties");
            Property textures = PlayerUtils.findTexturesProperty(properties);
            return Result.ofNullable(textures);
        }
        catch (Exception e) {
            return Result.error(e);
        }
    }

    private static JsonObject getElyByProfile(String username) throws IOException {
        HttpRequest request = HttpRequest.newBuilder().uri(API_URI.resolve("textures/signed/").resolve(username + "?unsigned=false")).GET().build();
        HttpResponse<String> response = WebUtils.executeRequest(request);
        WebUtils.throwOnClientErrors(response);
        if (response.statusCode() != 200) {
            throw new IllegalArgumentException("no profile with name " + username);
        }
        return JsonUtils.parseJson(response.body());
    }

    static {
        try {
            API_URI = new URI("http://skinsystem.ely.by/");
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

