/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.skin.provider;

import com.google.gson.JsonObject;
import com.mojang.authlib.properties.Property;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import net.lionarius.skinrestorer.skin.SkinVariant;
import net.lionarius.skinrestorer.skin.provider.SkinProvider;
import net.lionarius.skinrestorer.util.JsonUtils;
import net.lionarius.skinrestorer.util.Result;
import net.lionarius.skinrestorer.util.WebUtils;

public final class MineskinSkinProvider
implements SkinProvider {
    public static final String PROVIDER_NAME = "web";
    private static final URI API_URI;

    @Override
    public String getArgumentName() {
        return "url";
    }

    @Override
    public boolean hasVariantSupport() {
        return true;
    }

    @Override
    public Result<Optional<Property>, Exception> getSkin(String url, SkinVariant variant) {
        try {
            JsonObject result = MineskinSkinProvider.uploadToMineskin(url, variant);
            JsonObject texture = result.getAsJsonObject("data").getAsJsonObject("texture");
            return Result.ofNullable(new Property("textures", texture.get("value").getAsString(), texture.get("signature").getAsString()));
        }
        catch (Exception e) {
            return Result.error(e);
        }
    }

    private static JsonObject uploadToMineskin(String url, SkinVariant variant) throws IOException {
        String body = "{\"variant\":\"%s\",\"name\":\"%s\",\"visibility\":%d,\"url\":\"%s\"}".formatted(variant.toString(), "none", 0, url);
        HttpRequest request = HttpRequest.newBuilder().uri(API_URI.resolve("generate/url")).POST(HttpRequest.BodyPublishers.ofString(body)).header("Content-Type", "application/json").build();
        HttpResponse<String> response = WebUtils.executeRequest(request);
        WebUtils.throwOnClientErrors(response);
        if (response.statusCode() != 200) {
            throw new IllegalArgumentException("could not get mineskin skin");
        }
        return JsonUtils.parseJson(response.body());
    }

    static {
        try {
            API_URI = new URI("https://api.mineskin.org/");
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

