/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.skin.provider;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import net.lionarius.skinrestorer.skin.SkinVariant;
import net.lionarius.skinrestorer.skin.provider.SkinProvider;
import net.lionarius.skinrestorer.skin.provider.SkinProviderContext;
import net.lionarius.skinrestorer.util.JsonUtils;
import net.lionarius.skinrestorer.util.PlayerUtils;
import net.lionarius.skinrestorer.util.Result;
import net.lionarius.skinrestorer.util.WebUtils;

public final class MojangSkinProvider
implements SkinProvider {
    public static final String PROVIDER_NAME = "mojang";
    private static final URI API_URI;
    private static final URI SESSION_SERVER_URI;

    public static SkinProviderContext skinProviderContextFromProfile(GameProfile gameProfile) {
        return new SkinProviderContext(PROVIDER_NAME, gameProfile.getName(), null);
    }

    @Override
    public String getArgumentName() {
        return "username";
    }

    @Override
    public boolean hasVariantSupport() {
        return false;
    }

    @Override
    public Result<Optional<Property>, Exception> getSkin(String username, SkinVariant variant) {
        try {
            String uuid = MojangSkinProvider.getUuid(username);
            JsonObject profile = MojangSkinProvider.getMojangProfile(uuid);
            JsonArray properties = profile.getAsJsonArray("properties");
            Property textures = PlayerUtils.findTexturesProperty(properties);
            return Result.ofNullable(textures);
        }
        catch (Exception e) {
            return Result.error(e);
        }
    }

    private static String getUuid(String name) throws IOException {
        HttpRequest request = HttpRequest.newBuilder().uri(API_URI.resolve("users/profiles/minecraft/").resolve(name)).GET().build();
        HttpResponse<String> response = WebUtils.executeRequest(request);
        WebUtils.throwOnClientErrors(response);
        if (response.statusCode() != 200) {
            throw new IllegalArgumentException("no profile with name " + name);
        }
        JsonObject profile = JsonUtils.parseJson(response.body());
        if (profile == null) {
            return null;
        }
        return profile.get("id").getAsString();
    }

    private static JsonObject getMojangProfile(String uuid) throws IOException {
        HttpRequest request = HttpRequest.newBuilder().uri(SESSION_SERVER_URI.resolve("session/minecraft/profile/").resolve(uuid + "?unsigned=false")).GET().build();
        HttpResponse<String> response = WebUtils.executeRequest(request);
        WebUtils.throwOnClientErrors(response);
        if (response.statusCode() != 200) {
            throw new IllegalArgumentException("no profile with uuid " + uuid);
        }
        return JsonUtils.parseJson(response.body());
    }

    static {
        try {
            API_URI = new URI("https://api.mojang.com/");
            SESSION_SERVER_URI = new URI("https://sessionserver.mojang.com/");
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

