/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.compatibility.checks;

import me.jellysquid.mods.sodium.client.gui.console.Console;
import me.jellysquid.mods.sodium.client.gui.console.message.MessageLevel;
import net.minecraft.class_2561;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostLaunchChecks {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Sodium-PostlaunchChecks");

    public static void onContextInitialized() {
        if (PostLaunchChecks.isUsingPojavLauncher()) {
            Console.instance().logMessage(MessageLevel.SEVERE, (class_2561)class_2561.method_43471((String)"sodium.console.pojav_launcher"), 30.0);
            LOGGER.error("It appears that PojavLauncher is being used with an OpenGL compatibility layer. This will likely cause severe performance issues, graphical issues, and crashes when used with Sodium. This configuration is not supported -- you are on your own!");
        }
    }

    private static boolean isUsingPojavLauncher() {
        String workingDirectory;
        if (System.getenv("POJAV_RENDERER") != null) {
            LOGGER.warn("Detected presence of environment variable POJAV_LAUNCHER, which seems to indicate we are running on Android");
            return true;
        }
        String librarySearchPaths = System.getProperty("java.library.path", null);
        if (librarySearchPaths != null) {
            for (String path : librarySearchPaths.split(":")) {
                if (!PostLaunchChecks.isKnownAndroidPathFragment(path)) continue;
                LOGGER.warn("Found a library search path which seems to be hosted in an Android filesystem: {}", (Object)path);
                return true;
            }
        }
        if ((workingDirectory = System.getProperty("user.home", null)) != null && PostLaunchChecks.isKnownAndroidPathFragment(workingDirectory)) {
            LOGGER.warn("Working directory seems to be hosted in an Android filesystem: {}", (Object)workingDirectory);
        }
        return false;
    }

    private static boolean isKnownAndroidPathFragment(String path) {
        return path.matches("/data/user/[0-9]+/net\\.kdt\\.pojavlaunch");
    }
}

