/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper;

import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntConsumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IEnergyStorageUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IFluidHandlerWrapperUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackFluidHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackInventoryHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackRenderInfo;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackSettingsHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.InventoryModificationHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.common.BackpackWrapperLookup;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageFluidHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SortBy;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryIOHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stack.StackUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.InventorySorter;
import net.p3pp3rf1y.sophisticatedcore.util.LootHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;
import team.reborn.energy.api.EnergyStorage;

public class BackpackWrapper
implements IBackpackWrapper {
    public static final int DEFAULT_CLOTH_COLOR = 13394234;
    public static final int DEFAULT_BORDER_COLOR = 6434330;
    private static final String CLOTH_COLOR_TAG = "clothColor";
    private static final String BORDER_COLOR_TAG = "borderColor";
    private static final String OPEN_TAB_ID_TAG = "openTabId";
    private static final String SORT_BY_TAG = "sortBy";
    private static final String CONTENTS_UUID_TAG = "contentsUuid";
    private static final String INVENTORY_SLOTS_TAG = "inventorySlots";
    private static final String UPGRADE_SLOTS_TAG = "upgradeSlots";
    private static final String LOOT_TABLE_NAME_TAG = "lootTableName";
    private static final String LOOT_PERCENTAGE_TAG = "lootPercentage";
    private static final String COLUMNS_TAKEN_TAG = "columnsTaken";
    private final class_1799 backpack;
    private Runnable backpackSaveHandler = () -> {};
    private Runnable inventorySlotChangeHandler = () -> {};
    @Nullable
    private InventoryHandler handler = null;
    @Nullable
    private UpgradeHandler upgradeHandler = null;
    @Nullable
    private InventoryIOHandler inventoryIOHandler = null;
    @Nullable
    private InventoryModificationHandler inventoryModificationHandler = null;
    @Nullable
    private BackpackSettingsHandler settingsHandler = null;
    private boolean fluidHandlerInitialized = false;
    @Nullable
    private IStorageFluidHandler fluidHandler = null;
    private boolean energyStorageInitialized = false;
    @Nullable
    private EnergyStorage energyStorage = null;
    private final BackpackRenderInfo renderInfo;
    private IntConsumer onSlotsChange = diff -> {};
    private Runnable onInventoryHandlerRefresh = () -> {};
    private Runnable upgradeCachesInvalidatedHandler = () -> {};

    public BackpackWrapper(class_1799 backpack) {
        this.backpack = backpack;
        this.renderInfo = new BackpackRenderInfo(backpack, () -> this.backpackSaveHandler);
    }

    public void setSaveHandler(Runnable saveHandler) {
        this.backpackSaveHandler = saveHandler;
        this.refreshInventoryForUpgradeProcessing();
    }

    public void setInventorySlotChangeHandler(Runnable slotChangeHandler) {
        this.inventorySlotChangeHandler = slotChangeHandler;
    }

    public ITrackedContentsItemHandler getInventoryForUpgradeProcessing() {
        if (this.inventoryModificationHandler == null) {
            this.inventoryModificationHandler = new InventoryModificationHandler(this);
        }
        return this.inventoryModificationHandler.getModifiedInventoryHandler();
    }

    public InventoryHandler getInventoryHandler() {
        if (this.handler == null) {
            this.handler = new BackpackInventoryHandler(this.getNumberOfInventorySlots() - this.getNumberOfSlotRows() * this.getColumnsTaken(), this, this.getBackpackContentsNbt(), () -> {
                this.markBackpackContentsDirty();
                this.inventorySlotChangeHandler.run();
            }, StackUpgradeItem.getInventorySlotLimit((IStorageWrapper)this));
            this.handler.addListener(arg_0 -> ((ItemDisplaySettingsCategory)((ItemDisplaySettingsCategory)this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class))).itemChanged(arg_0));
        }
        return this.handler;
    }

    private int getNumberOfInventorySlots() {
        Optional inventorySlots = NBTHelper.getInt((class_1799)this.backpack, (String)INVENTORY_SLOTS_TAG);
        if (inventorySlots.isPresent()) {
            return (Integer)inventorySlots.get();
        }
        int itemInventorySlots = ((BackpackItem)this.backpack.method_7909()).getNumberOfSlots();
        this.setNumberOfInventorySlots(itemInventorySlots);
        return itemInventorySlots;
    }

    public int getNumberOfSlotRows() {
        int itemInventorySlots = this.getNumberOfInventorySlots();
        return (int)Math.ceil(itemInventorySlots <= 81 ? (double)itemInventorySlots / 9.0 : (double)itemInventorySlots / 12.0);
    }

    private void setNumberOfInventorySlots(int itemInventorySlots) {
        NBTHelper.setInteger((class_1799)this.backpack, (String)INVENTORY_SLOTS_TAG, (int)itemInventorySlots);
    }

    private class_2487 getBackpackContentsNbt() {
        return BackpackStorage.get().getOrCreateBackpackContents(this.getOrCreateContentsUuid());
    }

    private void markBackpackContentsDirty() {
        BackpackStorage.get().method_80();
    }

    public ITrackedContentsItemHandler getInventoryForInputOutput() {
        if (this.inventoryIOHandler == null) {
            this.inventoryIOHandler = new InventoryIOHandler((IStorageWrapper)this);
        }
        return this.inventoryIOHandler.getFilteredItemHandler();
    }

    public Optional<IStorageFluidHandler> getFluidHandler() {
        if (!this.fluidHandlerInitialized) {
            BackpackFluidHandler wrappedHandler = this.getUpgradeHandler().getTypeWrappers(TankUpgradeItem.TYPE).isEmpty() ? null : new BackpackFluidHandler(this);
            List fluidHandlerWrapperUpgrades = this.getUpgradeHandler().getWrappersThatImplement(IFluidHandlerWrapperUpgrade.class);
            for (IFluidHandlerWrapperUpgrade fluidHandlerWrapperUpgrade : fluidHandlerWrapperUpgrades) {
                wrappedHandler = fluidHandlerWrapperUpgrade.wrapHandler(wrappedHandler, this.backpack);
            }
            this.fluidHandler = wrappedHandler;
        }
        return Optional.ofNullable(this.fluidHandler);
    }

    public Optional<EnergyStorage> getEnergyStorage() {
        if (!this.energyStorageInitialized) {
            EnergyStorage wrappedStorage = this.getUpgradeHandler().getWrappersThatImplement(EnergyStorage.class).stream().findFirst().orElse(null);
            for (IEnergyStorageUpgradeWrapper energyStorageWrapperUpgrade : this.getUpgradeHandler().getWrappersThatImplement(IEnergyStorageUpgradeWrapper.class)) {
                wrappedStorage = energyStorageWrapperUpgrade.wrapStorage(wrappedStorage);
            }
            this.energyStorage = wrappedStorage;
        }
        return this.energyStorage == null || this.energyStorage.getCapacity() == 0L ? Optional.empty() : Optional.of(this.energyStorage);
    }

    @Override
    public void copyDataTo(IStorageWrapper otherStorageWrapper) {
        this.getContentsUuid().ifPresent(originalUuid -> {
            this.getInventoryHandler().copyStacksTo(otherStorageWrapper.getInventoryHandler());
            this.getUpgradeHandler().copyTo(otherStorageWrapper.getUpgradeHandler());
            this.getSettingsHandler().copyTo(otherStorageWrapper.getSettingsHandler());
        });
    }

    @Override
    public BackpackSettingsHandler getSettingsHandler() {
        if (this.settingsHandler == null) {
            this.settingsHandler = this.getContentsUuid().isPresent() ? new BackpackSettingsHandler(this, this.getBackpackContentsNbt(), this::markBackpackContentsDirty) : IBackpackWrapper.Noop.INSTANCE.getSettingsHandler();
        }
        return this.settingsHandler;
    }

    public UpgradeHandler getUpgradeHandler() {
        if (this.upgradeHandler == null) {
            this.upgradeHandler = this.getContentsUuid().isPresent() ? new UpgradeHandler(this.getNumberOfUpgradeSlots(), this, this.getBackpackContentsNbt(), this::markBackpackContentsDirty, () -> {
                if (this.handler != null) {
                    this.handler.clearListeners();
                    this.handler.setBaseSlotLimit(StackUpgradeItem.getInventorySlotLimit((IStorageWrapper)this));
                }
                this.getInventoryHandler().clearListeners();
                this.handler.addListener(arg_0 -> ((ItemDisplaySettingsCategory)((ItemDisplaySettingsCategory)this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class))).itemChanged(arg_0));
                this.inventoryIOHandler = null;
                this.inventoryModificationHandler = null;
                this.fluidHandlerInitialized = false;
                this.fluidHandler = null;
                this.energyStorageInitialized = false;
                this.energyStorage = null;
                this.upgradeCachesInvalidatedHandler.run();
            }){

                public boolean isItemValid(int slot, ItemVariant resource, int count) {
                    return super.isItemValid(slot, resource, count) && ("sophisticatedbackpacks".equals(class_7923.field_41178.method_10221((Object)resource.getItem()).method_12836()) || resource.toStack(count).method_31573(ModItems.BACKPACK_UPGRADE_TAG));
                }
            } : IBackpackWrapper.Noop.INSTANCE.getUpgradeHandler();
        }
        return this.upgradeHandler;
    }

    public void setUpgradeCachesInvalidatedHandler(Runnable handler) {
        this.upgradeCachesInvalidatedHandler = handler;
    }

    private int getNumberOfUpgradeSlots() {
        Optional upgradeSlots = NBTHelper.getInt((class_1799)this.backpack, (String)UPGRADE_SLOTS_TAG);
        if (upgradeSlots.isPresent()) {
            return (Integer)upgradeSlots.get();
        }
        int itemUpgradeSlots = ((BackpackItem)this.backpack.method_7909()).getNumberOfUpgradeSlots();
        this.setNumberOfUpgradeSlots(itemUpgradeSlots);
        return itemUpgradeSlots;
    }

    public Optional<UUID> getContentsUuid() {
        return NBTHelper.getUniqueId((class_1799)this.backpack, (String)CONTENTS_UUID_TAG);
    }

    private UUID getOrCreateContentsUuid() {
        Optional<UUID> contentsUuid = this.getContentsUuid();
        if (contentsUuid.isPresent()) {
            return contentsUuid.get();
        }
        this.clearDummyHandlers();
        UUID newUuid = UUID.randomUUID();
        this.setContentsUuid(newUuid);
        this.migrateBackpackContents(newUuid);
        return newUuid;
    }

    private void clearDummyHandlers() {
        if (this.upgradeHandler == IBackpackWrapper.Noop.INSTANCE.getUpgradeHandler()) {
            this.upgradeHandler = null;
        }
        if (this.settingsHandler == IBackpackWrapper.Noop.INSTANCE.getSettingsHandler()) {
            this.settingsHandler = null;
        }
    }

    private void migrateBackpackContents(UUID newUuid) {
        this.migrateNbtTag(newUuid, "inventory");
        this.migrateNbtTag(newUuid, "upgradeInventory");
    }

    private void migrateNbtTag(UUID newUuid, String key) {
        NBTHelper.getCompound((class_1799)this.backpack, (String)key).ifPresent(nbt -> {
            BackpackStorage.get().getOrCreateBackpackContents(newUuid).method_10566(key, (class_2520)nbt);
            this.markBackpackContentsDirty();
            NBTHelper.removeTag((class_1799)this.backpack, (String)key);
        });
    }

    public int getMainColor() {
        return NBTHelper.getInt((class_1799)this.backpack, (String)CLOTH_COLOR_TAG).orElse(13394234);
    }

    public int getAccentColor() {
        return NBTHelper.getInt((class_1799)this.backpack, (String)BORDER_COLOR_TAG).orElse(6434330);
    }

    public Optional<Integer> getOpenTabId() {
        return NBTHelper.getInt((class_1799)this.backpack, (String)OPEN_TAB_ID_TAG);
    }

    public void setOpenTabId(int openTabId) {
        NBTHelper.setInteger((class_1799)this.backpack, (String)OPEN_TAB_ID_TAG, (int)openTabId);
        this.backpackSaveHandler.run();
    }

    public void removeOpenTabId() {
        this.backpack.method_7948().method_10551(OPEN_TAB_ID_TAG);
        this.backpackSaveHandler.run();
    }

    public void setColors(int mainColor, int accentColor) {
        this.backpack.method_7959(CLOTH_COLOR_TAG, (class_2520)class_2497.method_23247((int)mainColor));
        this.backpack.method_7959(BORDER_COLOR_TAG, (class_2520)class_2497.method_23247((int)accentColor));
        this.backpackSaveHandler.run();
    }

    public void setSortBy(SortBy sortBy) {
        this.backpack.method_7959(SORT_BY_TAG, (class_2520)class_2519.method_23256((String)sortBy.method_15434()));
        this.backpackSaveHandler.run();
    }

    public SortBy getSortBy() {
        return NBTHelper.getEnumConstant((class_1799)this.backpack, (String)SORT_BY_TAG, SortBy::fromName).orElse(SortBy.NAME);
    }

    public void sort() {
        HashSet slotIndexesExcludedFromSort = new HashSet();
        slotIndexesExcludedFromSort.addAll(((NoSortSettingsCategory)this.getSettingsHandler().getTypeCategory(NoSortSettingsCategory.class)).getNoSortSlots());
        slotIndexesExcludedFromSort.addAll(((MemorySettingsCategory)this.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).getSlotIndexes());
        InventorySorter.sortHandler((SlottedStackStorage)this.getInventoryHandler(), this.getComparator(), slotIndexesExcludedFromSort);
    }

    private Comparator<Map.Entry<ItemStackKey, Integer>> getComparator() {
        return switch (this.getSortBy()) {
            default -> throw new IncompatibleClassChangeError();
            case SortBy.COUNT -> InventorySorter.BY_COUNT;
            case SortBy.TAGS -> InventorySorter.BY_TAGS;
            case SortBy.NAME -> InventorySorter.BY_NAME;
        };
    }

    @Override
    public class_1799 getBackpack() {
        return this.backpack;
    }

    @Override
    public class_1799 cloneBackpack() {
        class_1799 clonedBackpack = this.cloneBackpack(this);
        BackpackWrapperLookup.get(clonedBackpack).ifPresent(this::cloneSubbackpacks);
        return clonedBackpack;
    }

    private void cloneSubbackpacks(IStorageWrapper wrapperCloned) {
        InventoryHandler inventoryHandler = wrapperCloned.getInventoryHandler();
        for (int slot = 0; slot < inventoryHandler.getSlotCount(); ++slot) {
            class_1799 stack = inventoryHandler.getStackInSlot(slot);
            if (!(stack.method_7909() instanceof BackpackItem)) {
                return;
            }
            inventoryHandler.setStackInSlot(slot, BackpackWrapperLookup.get(stack).map(this::cloneBackpack).orElse(class_1799.field_8037));
        }
    }

    private class_1799 cloneBackpack(IBackpackWrapper originalWrapper) {
        class_1799 backpackCopy = originalWrapper.getBackpack().method_7972();
        backpackCopy.method_7983(CONTENTS_UUID_TAG);
        return BackpackWrapperLookup.get(backpackCopy).map(wrapperCopy -> {
            originalWrapper.copyDataTo((IStorageWrapper)wrapperCopy);
            return wrapperCopy.getBackpack();
        }).orElse(class_1799.field_8037);
    }

    public void refreshInventoryForInputOutput() {
        this.inventoryIOHandler = null;
        this.upgradeCachesInvalidatedHandler.run();
    }

    public void setPersistent(boolean persistent) {
        this.getInventoryHandler().setPersistent(persistent);
        this.getUpgradeHandler().setPersistent(persistent);
    }

    @Override
    public void setSlotNumbers(int numberOfInventorySlots, int numberOfUpgradeSlots) {
        this.setNumberOfInventorySlots(numberOfInventorySlots);
        this.setNumberOfUpgradeSlots(numberOfUpgradeSlots);
    }

    @Override
    public void setLoot(class_2960 lootTableName, float lootPercentage) {
        this.backpack.method_7959(LOOT_TABLE_NAME_TAG, (class_2520)class_2519.method_23256((String)lootTableName.toString()));
        this.backpack.method_7959(LOOT_PERCENTAGE_TAG, (class_2520)class_2494.method_23244((float)lootPercentage));
        this.backpackSaveHandler.run();
    }

    public void fillWithLoot(class_1657 playerEntity) {
        if (playerEntity.method_37908().field_9236) {
            return;
        }
        NBTHelper.getString((class_1799)this.backpack, (String)LOOT_TABLE_NAME_TAG).ifPresent(ltName -> this.fillWithLootFromTable(playerEntity, (String)ltName));
    }

    @Override
    public void setContentsUuid(UUID storageUuid) {
        NBTHelper.setUniqueId((class_1799)this.backpack, (String)CONTENTS_UUID_TAG, (UUID)storageUuid);
    }

    @Override
    public void removeContentsUuid() {
        this.getContentsUuid().ifPresent(BackpackStorage.get()::removeBackpackContents);
        this.removeContentsUUIDTag();
    }

    @Override
    public void removeContentsUUIDTag() {
        NBTHelper.removeTag((class_1799)this.backpack, (String)CONTENTS_UUID_TAG);
    }

    public BackpackRenderInfo getRenderInfo() {
        return this.renderInfo;
    }

    public void setColumnsTaken(int columnsTaken, boolean hasChanged) {
        int originalColumnsTaken = this.getColumnsTaken();
        NBTHelper.setInteger((class_1799)this.backpack, (String)COLUMNS_TAKEN_TAG, (int)columnsTaken);
        if (hasChanged) {
            int diff = (columnsTaken - originalColumnsTaken) * this.getNumberOfSlotRows();
            this.onSlotsChange.accept(diff);
        }
        this.backpackSaveHandler.run();
    }

    @Override
    public void registerOnSlotsChangeListener(IntConsumer onSlotsChange) {
        this.onSlotsChange = onSlotsChange;
    }

    @Override
    public void unregisterOnSlotsChangeListener() {
        this.onSlotsChange = diff -> {};
    }

    public int getColumnsTaken() {
        return NBTHelper.getInt((class_1799)this.backpack, (String)COLUMNS_TAKEN_TAG).orElse(0);
    }

    private void fillWithLootFromTable(class_1657 playerEntity, String lootName) {
        class_1937 class_19372;
        MinecraftServer server = playerEntity.method_37908().method_8503();
        if (server == null || !((class_19372 = playerEntity.method_37908()) instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        class_2960 lootTableName = new class_2960(lootName);
        float lootPercentage = NBTHelper.getFloat((class_1799)this.backpack, (String)LOOT_PERCENTAGE_TAG).orElse(Float.valueOf(0.0f)).floatValue();
        this.backpack.method_7983(LOOT_TABLE_NAME_TAG);
        this.backpack.method_7983(LOOT_PERCENTAGE_TAG);
        List loot = LootHelper.getLoot((class_2960)lootTableName, (MinecraftServer)server, (class_3218)serverLevel, (class_1297)playerEntity);
        loot.removeIf(stack -> stack.method_7909() instanceof BackpackItem);
        loot = RandHelper.getNRandomElements((List)loot, (int)((int)((float)loot.size() * lootPercentage)));
        LootHelper.fillWithLoot((class_5819)serverLevel.field_9229, (List)loot, (SlottedStackStorage)this.getInventoryHandler());
    }

    private void setNumberOfUpgradeSlots(int numberOfUpgradeSlots) {
        NBTHelper.setInteger((class_1799)this.backpack, (String)UPGRADE_SLOTS_TAG, (int)numberOfUpgradeSlots);
    }

    public void refreshInventoryForUpgradeProcessing() {
        this.inventoryModificationHandler = null;
        this.fluidHandler = null;
        this.fluidHandlerInitialized = false;
        this.energyStorage = null;
        this.energyStorageInitialized = false;
        this.refreshInventoryForInputOutput();
    }

    public void onContentsNbtUpdated() {
        this.handler = null;
        this.upgradeHandler = null;
        this.refreshInventoryForUpgradeProcessing();
        this.onInventoryHandlerRefresh.run();
    }

    @Override
    public void registerOnInventoryHandlerRefreshListener(Runnable onInventoryHandlerRefresh) {
        this.onInventoryHandlerRefresh = onInventoryHandlerRefresh;
    }

    @Override
    public void unregisterOnInventoryHandlerRefreshListener() {
        this.onInventoryHandlerRefresh = () -> {};
    }

    public class_1799 getWrappedStorageStack() {
        return this.getBackpack();
    }
}

