/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.render;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_583;
import net.minecraft.class_742;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackModelManager;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.IBackpackModel;
import net.p3pp3rf1y.sophisticatedbackpacks.common.BackpackWrapperLookup;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedcore.api.IUpgradeRenderer;
import net.p3pp3rf1y.sophisticatedcore.client.render.UpgradeRenderRegistry;
import net.p3pp3rf1y.sophisticatedcore.renderdata.IUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.renderdata.UpgradeRenderDataType;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BackpackLayerRenderer<T extends class_1309, M extends class_583<T>>
extends class_3887<T, M> {
    public BackpackLayerRenderer(class_3883<T, M> entityRendererIn) {
        super(entityRendererIn);
        BackpackModelManager.initModels();
    }

    public void render(class_4587 matrixStack, class_4597 buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof class_742) {
            class_742 player = (class_742)entity;
            PlayerInventoryProvider.get().getBackpackFromRendered((class_1657)player).ifPresent(backpackRenderInfo -> {
                matrixStack.method_22903();
                class_1799 backpack = backpackRenderInfo.getBackpack();
                IBackpackModel model = BackpackModelManager.getBackpackModel(backpack.method_7909());
                class_1304 equipmentSlot = model.getRenderEquipmentSlot();
                boolean wearsArmor = (equipmentSlot != class_1304.field_6174 || !backpackRenderInfo.isArmorSlot()) && !((class_1799)player.method_31548().field_7548.get(equipmentSlot.method_5927())).method_7960();
                BackpackLayerRenderer.renderBackpack(this.method_17165(), (class_1309)player, matrixStack, buffer, packedLight, backpack, wearsArmor, model);
                matrixStack.method_22909();
            });
        } else {
            class_1799 chestStack = entity.method_6118(class_1304.field_6174);
            if (chestStack.method_7909() instanceof BackpackItem) {
                BackpackLayerRenderer.renderBackpack(this.method_17165(), entity, matrixStack, buffer, packedLight, chestStack, false, BackpackModelManager.getBackpackModel(chestStack.method_7909()));
            }
        }
    }

    public static <T extends class_1309, M extends class_583<T>> void renderBackpack(M parentModel, class_1309 livingEntity, class_4587 matrixStack, class_4597 buffer, int packedLight, class_1799 backpack, boolean wearsArmor, IBackpackModel model) {
        model.translateRotateAndScale(parentModel, livingEntity, matrixStack, wearsArmor);
        BackpackWrapperLookup.get(backpack).ifPresent(wrapper -> {
            int clothColor = wrapper.getMainColor();
            int borderColor = wrapper.getAccentColor();
            model.render(parentModel, livingEntity, matrixStack, buffer, packedLight, clothColor, borderColor, backpack.method_7909(), wrapper.getRenderInfo());
            BackpackLayerRenderer.renderUpgrades(livingEntity, wrapper.getRenderInfo());
            BackpackLayerRenderer.renderItemShown(matrixStack, buffer, packedLight, wrapper.getRenderInfo(), livingEntity.method_37908());
        });
    }

    private static void renderItemShown(class_4587 matrixStack, class_4597 buffer, int packedLight, RenderInfo renderInfo, @Nullable class_1937 level) {
        renderInfo.getItemDisplayRenderInfo().getDisplayItem().ifPresent(displayItem -> {
            matrixStack.method_22903();
            matrixStack.method_22904(0.0, 0.9, -0.25);
            matrixStack.method_22905(0.5f, 0.5f, 0.5f);
            matrixStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f + (float)displayItem.getRotation()));
            class_310.method_1551().method_1480().method_23178(displayItem.getItem(), class_811.field_4319, packedLight, class_4608.field_21444, matrixStack, buffer, level, 0);
            matrixStack.method_22909();
        });
    }

    private static void renderUpgrades(class_1309 livingEntity, RenderInfo renderInfo) {
        if (class_310.method_1551().method_1493() || livingEntity.method_37908().field_9229.method_43048(32) != 0) {
            return;
        }
        HashMap<UpgradeRenderDataType, IUpgradeRenderData> upgradeRenderData = new HashMap<UpgradeRenderDataType, IUpgradeRenderData>(renderInfo.getUpgradeRenderData());
        upgradeRenderData.forEach((type, data) -> UpgradeRenderRegistry.getUpgradeRenderer((UpgradeRenderDataType)type).ifPresent(renderer -> BackpackLayerRenderer.renderUpgrade(renderer, livingEntity, type, data)));
    }

    private static Vector3f getBackpackMiddleFacePoint(class_1309 livingEntity, Vector3f vector) {
        Vector3f point = new Vector3f((Vector3fc)vector);
        point.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(livingEntity.method_18276() ? 25.0f : 0.0f));
        point.add(0.0f, 0.8f, livingEntity.method_18276() ? 0.9f : 0.7f);
        point.rotate((Quaternionfc)class_7833.field_40715.rotationDegrees(livingEntity.field_6283 - 180.0f));
        point.add((Vector3fc)livingEntity.method_19538().method_46409());
        return point;
    }

    private static <T extends IUpgradeRenderData> void renderUpgrade(IUpgradeRenderer<T> renderer, class_1309 livingEntity, UpgradeRenderDataType<?> type, IUpgradeRenderData data) {
        type.cast(data).ifPresent(renderData -> renderer.render(livingEntity.method_37908(), livingEntity.method_37908().field_9229, vector3d -> BackpackLayerRenderer.getBackpackMiddleFacePoint(livingEntity, vector3d), renderData));
    }
}

