/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.porting_lib.transfer.items;

import io.github.fabricators_of_create.porting_lib.core.util.INBTSerializable;
import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import io.github.fabricators_of_create.porting_lib.util.DualSortedSetIterator;
import io.github.fabricators_of_create.porting_lib.util.EmptySortedSet;
import it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.p3pp3rf1y.porting_lib.transfer.items.SCItemStackHandlerSlot;
import org.jetbrains.annotations.NotNull;

public class SCItemStackHandler
implements SlottedStackStorage,
INBTSerializable<class_2487> {
    private final List<SCItemStackHandlerSlot> slots;
    private final SortedSet<SCItemStackHandlerSlot> nonEmptySlots;
    private final Map<class_1792, SortedSet<SCItemStackHandlerSlot>> lookup;

    public SCItemStackHandler() {
        this(1);
    }

    public SCItemStackHandler(int stacks) {
        this(SCItemStackHandler.createEmptyStackArray(stacks));
    }

    public SCItemStackHandler(class_1799[] stacks) {
        this.slots = new ArrayList<SCItemStackHandlerSlot>(stacks.length);
        this.nonEmptySlots = SCItemStackHandler.createSlotSet();
        this.lookup = new HashMap<class_1792, SortedSet<SCItemStackHandlerSlot>>();
        for (int i = 0; i < stacks.length; ++i) {
            class_1799 stack = stacks[i];
            this.slots.add(this.makeSlot(i, stack));
        }
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        SCItemStackHandlerSlot slot;
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        long inserted = 0L;
        Iterator<SCItemStackHandlerSlot> iter = this.getInsertableSlotsFor(resource);
        while (iter.hasNext() && (inserted += (slot = iter.next()).insert(resource, maxAmount - inserted, transaction)) < maxAmount) {
        }
        return inserted;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        SCItemStackHandlerSlot slot;
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        class_1792 item = resource.getItem();
        SortedSet<SCItemStackHandlerSlot> slots = this.getSlotsContaining(item);
        if (slots.isEmpty()) {
            return 0L;
        }
        long extracted = 0L;
        Iterator iterator = slots.iterator();
        while (iterator.hasNext() && (extracted += (slot = (SCItemStackHandlerSlot)((Object)iterator.next())).extract(resource, maxAmount - extracted, transaction)) < maxAmount) {
        }
        return extracted;
    }

    @Nullable
    public StorageView<ItemVariant> exactView(ItemVariant resource) {
        StoragePreconditions.notBlank((TransferVariant)resource);
        SortedSet<SCItemStackHandlerSlot> slots = this.getSlotsContaining(resource.getItem());
        return slots.isEmpty() ? null : (StorageView)slots.first();
    }

    public Iterable<StorageView<ItemVariant>> nonEmptyViews() {
        return this.nonEmptySlots;
    }

    public Iterator<StorageView<ItemVariant>> nonEmptyIterator() {
        return this.nonEmptySlots.iterator();
    }

    public int getSlotCount() {
        return this.slots.size();
    }

    public SCItemStackHandlerSlot getSlot(int slot) {
        return this.slots.get(slot);
    }

    public List<SingleSlotStorage<ItemVariant>> getSlots() {
        return this.slots;
    }

    public class_1799 getStackInSlot(int slot) {
        return this.getSlot(slot).getStack();
    }

    public void setStackInSlot(int slot, @NotNull class_1799 stack) {
        this.getSlot(slot).setNewStack(stack);
    }

    public ItemVariant getVariantInSlot(int slot) {
        return this.getSlot(slot).getResource();
    }

    public int getSlotLimit(int slot) {
        return this.getStackInSlot(slot).method_7914();
    }

    protected int getStackLimit(int slot, ItemVariant resource) {
        return Math.min(this.getSlotLimit(slot), resource.getItem().method_7882());
    }

    protected void onContentsChanged(int slot) {
    }

    public SortedSet<SCItemStackHandlerSlot> getSlotsContaining(class_1792 item) {
        return this.lookup.containsKey(item) ? this.lookup.get(item) : EmptySortedSet.cast();
    }

    protected void onLoad() {
    }

    public boolean empty() {
        return this.nonEmptySlots.isEmpty();
    }

    public void setSize(int size) {
        this.slots.clear();
        this.nonEmptySlots.clear();
        this.lookup.clear();
        for (int i = 0; i < size; ++i) {
            this.slots.add(this.makeSlot(i, class_1799.field_8037));
        }
    }

    protected SCItemStackHandlerSlot makeSlot(int index, class_1799 stack) {
        return new SCItemStackHandlerSlot(index, this, stack);
    }

    public class_2487 serializeNBT() {
        class_2487 nbt = new class_2487();
        nbt.method_10569("Size", this.slots.size());
        class_2499 slots = new class_2499();
        for (SCItemStackHandlerSlot slot : this.slots) {
            class_2487 slotTag = slot.save();
            if (slotTag == null) continue;
            slotTag.method_10569("Slot", slot.getIndex());
            slots.add((Object)slotTag);
        }
        nbt.method_10566("Items", (class_2520)slots);
        return nbt;
    }

    public void deserializeNBT(class_2487 nbt) {
        this.setSize(nbt.method_10573("Size", 3) ? nbt.method_10550("Size") : this.slots.size());
        class_2499 slots = nbt.method_10554("Items", 10);
        for (int i = 0; i < slots.size(); ++i) {
            class_2487 slotTag = slots.method_10602(i);
            int index = slotTag.method_10550("Slot");
            if (index < 0 || index >= this.slots.size()) continue;
            this.slots.get(index).load(slotTag);
        }
        this.onLoad();
    }

    void onStackChange(SCItemStackHandlerSlot slot, class_1799 oldStack, class_1799 newStack) {
        if (class_1799.method_7973((class_1799)oldStack, (class_1799)newStack)) {
            return;
        }
        SortedSet<SCItemStackHandlerSlot> oldItemSlots = this.getSlotsContaining(oldStack.method_7909());
        if (!oldItemSlots.isEmpty()) {
            oldItemSlots.remove((Object)slot);
        }
        this.lookup.computeIfAbsent(newStack.method_7909(), $ -> SCItemStackHandler.createSlotSet()).add(slot);
        if (oldStack.method_7960()) {
            this.nonEmptySlots.add(slot);
        } else if (newStack.method_7960()) {
            this.nonEmptySlots.remove((Object)slot);
        }
    }

    void initSlot(SCItemStackHandlerSlot slot) {
        class_1799 stack = slot.getStack();
        this.lookup.computeIfAbsent(stack.method_7909(), $ -> SCItemStackHandler.createSlotSet()).add(slot);
        if (!stack.method_7960()) {
            this.nonEmptySlots.add(slot);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.slots) + "]";
    }

    private Iterator<SCItemStackHandlerSlot> getInsertableSlotsFor(ItemVariant variant) {
        SortedSet<SCItemStackHandlerSlot> slots = this.getSlotsContaining(variant.getItem());
        SortedSet<SCItemStackHandlerSlot> emptySlots = this.getSlotsContaining(class_1802.field_8162);
        if (slots.isEmpty()) {
            return emptySlots.isEmpty() ? Collections.emptyIterator() : emptySlots.iterator();
        }
        return emptySlots.isEmpty() ? slots.iterator() : new DualSortedSetIterator(slots, emptySlots);
    }

    private static SortedSet<SCItemStackHandlerSlot> createSlotSet() {
        return new ObjectAVLTreeSet(Comparator.comparingInt(SCItemStackHandlerSlot::getIndex));
    }

    public static class_1799[] createEmptyStackArray(int size) {
        Object[] stacks = new class_1799[size];
        Arrays.fill(stacks, class_1799.field_8037);
        return stacks;
    }
}

