/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore;

import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import fuzs.forgeconfigapiport.api.config.v2.ModConfigEvents;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.client.gui.SortButtonsPosition;
import net.p3pp3rf1y.sophisticatedcore.util.RegistryHelper;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    private static final Map<ModConfig.Type, BaseConfig> CONFIGS = new EnumMap<ModConfig.Type, BaseConfig>(ModConfig.Type.class);
    public static Client CLIENT;
    public static Common COMMON;

    private static <T extends BaseConfig> T register(Function<ForgeConfigSpec.Builder, T> factory, ModConfig.Type side) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(factory);
        BaseConfig config = (BaseConfig)specPair.getLeft();
        config.specification = (ForgeConfigSpec)specPair.getRight();
        CONFIGS.put(side, config);
        return (T)config;
    }

    public static void register() {
        CLIENT = Config.register(Client::new, ModConfig.Type.CLIENT);
        COMMON = Config.register(Common::new, ModConfig.Type.SERVER);
        for (Map.Entry<ModConfig.Type, BaseConfig> pair : CONFIGS.entrySet()) {
            ForgeConfigRegistry.INSTANCE.register("sophisticatedcore", pair.getKey(), (IConfigSpec)pair.getValue().specification);
        }
        ModConfigEvents.loading((String)"sophisticatedcore").register(Config::onConfigLoad);
        ModConfigEvents.reloading((String)"sophisticatedcore").register(Config::onConfigReload);
    }

    public static void onConfigLoad(ModConfig modConfig) {
        for (BaseConfig config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onConfigLoad();
        }
    }

    public static void onConfigReload(ModConfig modConfig) {
        for (BaseConfig config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onConfigReload();
        }
    }

    public static class BaseConfig {
        public ForgeConfigSpec specification;

        public void onConfigLoad() {
        }

        public void onConfigReload() {
        }
    }

    public static class Client
    extends BaseConfig {
        public final ForgeConfigSpec.EnumValue<SortButtonsPosition> sortButtonsPosition;
        public final ForgeConfigSpec.BooleanValue playButtonSound;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client Settings").push("client");
            this.sortButtonsPosition = builder.comment("Positions where sort buttons can display to help with conflicts with controls from other mods").defineEnum("sortButtonsPosition", (Enum)SortButtonsPosition.TITLE_LINE_RIGHT);
            this.playButtonSound = builder.comment("Whether click sound should play when custom buttons are clicked in gui").define("playButtonSound", true);
            builder.pop();
        }
    }

    public static class Common
    extends BaseConfig {
        public final EnabledItems enabledItems;

        @Override
        public void onConfigReload() {
            this.enabledItems.enabledMap.clear();
        }

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common Settings").push("common");
            this.enabledItems = new EnabledItems(builder);
        }

        public static class EnabledItems {
            private final ForgeConfigSpec.ConfigValue<List<String>> itemsEnableList;
            private final Map<class_2960, Boolean> enabledMap = new ConcurrentHashMap<class_2960, Boolean>();

            EnabledItems(ForgeConfigSpec.Builder builder) {
                this.itemsEnableList = builder.comment("Disable / enable any items here (disables their recipes)").define("enabledItems", new ArrayList());
            }

            public boolean isItemEnabled(class_1792 item) {
                return RegistryHelper.getRegistryName(class_7923.field_41178, item).map(this::isItemEnabled).orElse(false);
            }

            public boolean isItemEnabled(class_2960 itemRegistryName) {
                if (!Config.COMMON.specification.isLoaded()) {
                    return true;
                }
                if (this.enabledMap.isEmpty()) {
                    this.loadEnabledMap();
                }
                return this.enabledMap.computeIfAbsent(itemRegistryName, irn -> {
                    this.addEnabledItemToConfig(itemRegistryName);
                    return true;
                });
            }

            private void addEnabledItemToConfig(class_2960 itemRegistryName) {
                List list = (List)this.itemsEnableList.get();
                list.add(String.valueOf(itemRegistryName) + "|true");
                this.itemsEnableList.set((Object)list);
            }

            private void loadEnabledMap() {
                for (String itemEnabled : (List)this.itemsEnableList.get()) {
                    String[] data = itemEnabled.split("\\|");
                    if (data.length == 2) {
                        this.enabledMap.put(new class_2960(data[0]), Boolean.valueOf(data[1]));
                        continue;
                    }
                    SophisticatedCore.LOGGER.error("Wrong data for enabledItems - expected registry name|true/false when {} was provided", (Object)itemEnabled);
                }
            }
        }
    }
}

